/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage.segment;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.common.meta.DiskFileInfo;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.network.protocol.SubPartitionReadData;
import org.apache.celeborn.service.deploy.worker.memory.BufferRecycler;
import org.apache.celeborn.service.deploy.worker.memory.RecyclableBuffer;
import org.apache.celeborn.service.deploy.worker.memory.RecyclableSegmentIdBuffer;
import org.apache.celeborn.service.deploy.worker.storage.MapPartitionDataReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMapPartitionDataReader
extends MapPartitionDataReader {
    public static final Logger logger = LoggerFactory.getLogger(SegmentMapPartitionDataReader.class);
    private static final int END_OF_SEGMENT_BUFFER_DATA_TYPE = 7;
    private final int startPartitionIndex;
    private final int endPartitionIndex;
    @GuardedBy(value="lock")
    private final Deque<Integer> backlogs = new LinkedList<Integer>();
    @GuardedBy(value="lock")
    private Map<Integer, Integer> subPartitionRequiredSegmentIds = new HashMap<Integer, Integer>();
    @GuardedBy(value="lock")
    private boolean hasUpdateSegmentId = false;
    @GuardedBy(value="lock")
    private Map<Integer, Integer> subPartitionLastSegmentIds = new HashMap<Integer, Integer>();
    @GuardedBy(value="lock")
    private Map<Integer, Integer> subPartitionNextBufferIndex = new HashMap<Integer, Integer>();

    public SegmentMapPartitionDataReader(int startPartitionIndex, int endPartitionIndex, DiskFileInfo fileInfo, long streamId, Channel associatedChannel, Runnable recycleStream) {
        super(startPartitionIndex, endPartitionIndex, fileInfo, streamId, associatedChannel, recycleStream);
        this.startPartitionIndex = startPartitionIndex;
        this.endPartitionIndex = endPartitionIndex;
        for (int i = startPartitionIndex; i <= endPartitionIndex; ++i) {
            this.subPartitionLastSegmentIds.put(i, -1);
            this.subPartitionRequiredSegmentIds.put(i, -1);
            this.subPartitionNextBufferIndex.put(i, 0);
        }
    }

    @Override
    protected void tryNotifyBacklog(int numDataBuffers) {
        this.notifyBacklog(this.getBacklog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sendData() {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                RecyclableBuffer buffer;
                if (!this.hasUpdateSegmentId) {
                    logger.debug("The required segment id is not updated for {}, skip sending data.", (Object)this.getStreamId());
                    return;
                }
                boolean breakLoop = false;
                while ((buffer = (RecyclableBuffer)this.buffersToSend.peek()) instanceof RecyclableSegmentIdBuffer) {
                    int requiredSegmentId;
                    RecyclableSegmentIdBuffer recyclableSegmentIdBuffer = (RecyclableSegmentIdBuffer)buffer;
                    int subPartitionId = recyclableSegmentIdBuffer.getSubPartitionId();
                    int segmentId = recyclableSegmentIdBuffer.getSegmentId();
                    if (segmentId != (requiredSegmentId = this.subPartitionRequiredSegmentIds.get(subPartitionId).intValue())) {
                        logger.info("The queued head buffer is not the required segment id, do not sent it. details: streamId {}, subPartitionId: {}, current segment id: {}, required segment id: {}, reader: {}", new Object[]{this.streamId, subPartitionId, segmentId, requiredSegmentId, this});
                        breakLoop = true;
                        break;
                    }
                    this.buffersToSend.poll();
                }
                if (breakLoop) {
                    break;
                }
                buffer = this.fetchBufferToSend();
                if (buffer == null) {
                    break;
                }
                if (buffer instanceof RecyclableSegmentIdBuffer) {
                    logger.warn("Wrong type of buffer, the RecyclableSegmentIdBuffer is not expected.");
                    return;
                }
                this.sendDataInternal(buffer);
            }
        }
        this.tryRecycleReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addBuffer(ByteBuf buffer, BufferRecycler bufferRecycler) {
        if (buffer == null) {
            return;
        }
        buffer.markReaderIndex();
        int subPartitionId = buffer.readInt();
        boolean isEndOfSegment = this.isEndOfSegment(buffer, subPartitionId);
        buffer.resetReaderIndex();
        Object object = this.lock;
        synchronized (object) {
            if (this.isReleased) {
                bufferRecycler.recycle(buffer);
                this.numInUseBuffers.decrementAndGet();
                throw new RuntimeException("Partition reader has been failed or finished.", this.errorCause);
            }
            this.buffersToSend.add(new RecyclableBuffer(buffer, subPartitionId, bufferRecycler));
            this.increaseBacklog();
            this.subPartitionNextBufferIndex.compute(subPartitionId, (k, v) -> v + 1);
            if (isEndOfSegment) {
                this.updateSegmentId(subPartitionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RecyclableBuffer fetchBufferToSend() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isReleased || this.buffersToSend.isEmpty()) {
                return null;
            }
            RecyclableBuffer buffer = null;
            int numCredit = this.credits.get();
            if (numCredit > 0) {
                buffer = (RecyclableBuffer)this.buffersToSend.poll();
            }
            if (numCredit <= 1) {
                this.notifyBacklog(this.getBacklog());
            }
            return buffer;
        }
    }

    @Override
    protected void notifyBacklog(int backlog) {
        if (backlog == 0) {
            return;
        }
        super.notifyBacklog(backlog);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SegmentMapDataPartitionReader{");
        sb.append("startPartitionIndex=").append(this.startPartitionIndex);
        sb.append(", endPartitionIndex=").append(this.endPartitionIndex);
        sb.append(", streamId=").append(this.streamId);
        sb.append('}');
        return sb.toString();
    }

    private boolean isEndOfSegment(ByteBuf buffer, int subPartitionId) {
        boolean isEndOfSegment = false;
        Preconditions.checkState((subPartitionId >= this.startPartitionIndex && subPartitionId <= this.endPartitionIndex ? 1 : 0) != 0);
        if (this.mapFileMeta.hasPartitionSegmentIds()) {
            buffer.skipBytes(12);
            byte dataType = buffer.readByte();
            isEndOfSegment = 7 == dataType;
        }
        return isEndOfSegment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBacklog() {
        Object object = this.lock;
        synchronized (object) {
            Integer backlog = this.backlogs.peekFirst();
            while (backlog != null && backlog == 0) {
                this.backlogs.pollFirst();
                backlog = this.backlogs.peekFirst();
            }
            if (backlog != null) {
                this.backlogs.pollFirst();
            }
            return backlog == null ? 0 : backlog;
        }
    }

    @GuardedBy(value="lock")
    private void addNewBacklog() {
        this.backlogs.addLast(0);
    }

    @GuardedBy(value="lock")
    private void increaseBacklog() {
        Integer backlog = this.backlogs.pollLast();
        if (backlog == null) {
            this.backlogs.addLast(1);
        } else {
            this.backlogs.addLast(backlog + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSegmentId(int subPartitionId) {
        Object object = this.lock;
        synchronized (object) {
            Integer segmentId = this.mapFileMeta.getSegmentIdByFirstBufferIndex(subPartitionId, this.subPartitionNextBufferIndex.get(subPartitionId).intValue());
            if (segmentId == null) {
                return;
            }
            if (segmentId != -1) {
                int subPartitionLastSegmentId = this.subPartitionLastSegmentIds.get(subPartitionId);
                if (segmentId == 0 || !segmentId.equals(subPartitionLastSegmentId) && !segmentId.equals(subPartitionLastSegmentId + 1)) {
                    this.addNewBacklog();
                }
                this.subPartitionLastSegmentIds.put(subPartitionId, segmentId);
            }
            logger.debug("Insert a buffer to indicate the current segment id subPartitionId={}, segmentId={} for {}.", new Object[]{subPartitionId, segmentId, this});
            this.buffersToSend.add(new RecyclableSegmentIdBuffer(subPartitionId, segmentId));
        }
    }

    @Override
    public RequestMessage generateReadDataMessage(long streamId, int subPartitionId, ByteBuf byteBuf) {
        return new SubPartitionReadData(streamId, subPartitionId, byteBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRequiredSegmentId(int segmentId, int subPartitionId) {
        Object object = this.lock;
        synchronized (object) {
            logger.debug("Update the required segment id to {}, {}, subPartitionId: {}", new Object[]{segmentId, this, subPartitionId});
            this.subPartitionRequiredSegmentIds.put(subPartitionId, segmentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSegmentId() {
        Object object = this.lock;
        synchronized (object) {
            this.hasUpdateSegmentId = true;
            for (int i = this.startPartitionIndex; i <= this.endPartitionIndex; ++i) {
                if (this.subPartitionLastSegmentIds.get(i) >= 0) continue;
                this.updateSegmentId(i);
            }
        }
    }
}

