/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.Closeable;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Debugger;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.Engine32;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.internal.TemplateEngine;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.JexlParser;
import org.apache.commons.jexl3.parser.JexlScriptParser;
import org.apache.commons.jexl3.parser.Parser;
import org.apache.commons.jexl3.parser.Provider;
import org.apache.commons.jexl3.parser.StringProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Issues400Test {
    static final char[] EQ_FRIEND;

    private static void run404(JexlEngine jexl, String src, Object ... a) {
        JexlScript script = jexl.createScript(src, new String[]{"a", "b"});
        if (!src.endsWith(";")) {
            Assertions.assertEquals((Object)script.getSourceText(), (Object)script.getParsedText());
        }
        Object result = script.execute(null, a);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    void test402() {
        MapContext jc = new MapContext();
        String[] sources = new String[]{"if (true) { return }", "if (true) { 3; return }", "(x->{ 3; return })()"};
        JexlEngine jexl = new JexlBuilder().create();
        for (String source : sources) {
            JexlScript e = jexl.createScript(source);
            Object o = e.execute((JexlContext)jc);
            Assertions.assertNull((Object)o);
        }
    }

    @Test
    void test403() {
        String[] strings;
        for (String setmap : strings = new String[]{"  map1.`${item.a}` = 1;\n", "  map1[`${item.a}`] = 1;\n", "  map1[item.a] = 1;\n"}) {
            String src = "var a = {'a': 1};\nvar list = [a, a];\nlet map1 = {:};\nfor (let item : list) {\n" + setmap + "}\n map1";
            JexlEngine jexl = new JexlBuilder().cache(64).create();
            JexlScript script = jexl.createScript(src);
            for (int i = 0; i < 2; ++i) {
                Object result = script.execute(null);
                Assertions.assertInstanceOf(Map.class, (Object)result);
                Map map = (Map)result;
                Assertions.assertEquals((int)1, (int)map.size());
                Object val = jexl.createScript("m -> m[1]").execute(null, new Object[]{map});
                Assertions.assertEquals((Object)1, (Object)val);
            }
        }
    }

    @Test
    void test404a() {
        JexlEngine jexl = new JexlBuilder().cache(64).strict(true).safe(false).create();
        Map<String, Object> a = Collections.singletonMap("b", 42);
        for (String src : new String[]{"a.b", "a?.b", "a['b']", "a?['b']", "a?.`b`"}) {
            Issues400Test.run404(jexl, src, a);
            Issues400Test.run404(jexl, src + ";", a);
        }
        for (String src : new String[]{"a[b]", "a?[b]", "a?.`${b}`"}) {
            Issues400Test.run404(jexl, src, a, "b");
            Issues400Test.run404(jexl, src + ";", a, "b");
        }
        Map<String, Integer> b = Collections.singletonMap("c", 42);
        a = Collections.singletonMap("b", b);
        for (String src : new String[]{"a[b].c", "a?[b]?['c']", "a?.`${b}`.c"}) {
            Issues400Test.run404(jexl, src, a, "b");
        }
    }

    @Test
    void test404b() {
        JexlEngine jexl = new JexlBuilder().cache(64).strict(true).safe(false).create();
        Map<String, Integer> b = Collections.singletonMap("c", 42);
        Map<String, Map<String, Integer>> a = Collections.singletonMap("b", b);
        JexlScript script = jexl.createScript("a?['B']?['C']", new String[]{"a"});
        Object result = script.execute(null, new Object[]{a});
        Assertions.assertEquals((Object)script.getSourceText(), (Object)script.getParsedText());
        Assertions.assertNull((Object)result);
        script = jexl.createScript("a?['b']?['C']", new String[]{"a"});
        Assertions.assertEquals((Object)script.getSourceText(), (Object)script.getParsedText());
        result = script.execute(null, new Object[]{a});
        Assertions.assertNull((Object)result);
        script = jexl.createScript("a?['b']?['c']", new String[]{"a"});
        Assertions.assertEquals((Object)script.getSourceText(), (Object)script.getParsedText());
        result = script.execute(null, new Object[]{a});
        Assertions.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("a?['B']?['C']?: 1042", new String[]{"a"});
        Assertions.assertEquals((Object)script.getSourceText(), (Object)script.getParsedText());
        result = script.execute(null, new Object[]{a});
        Assertions.assertEquals((Object)1042, (Object)result);
        script = jexl.createScript("a? ['B']:['C']", new String[]{"a"});
        result = script.execute(null, new Object[]{a});
        Assertions.assertArrayEquals((Object[])new String[]{"B"}, (Object[])((String[])result));
        script = jexl.createScript("a?['b'] ?: ['C']", new String[]{"a"});
        result = script.execute(null, new Object[]{a});
        Assertions.assertEquals(b, (Object)result);
        script = jexl.createScript("a?['B'] ?: ['C']", new String[]{"a"});
        result = script.execute(null, new Object[]{a});
        Assertions.assertArrayEquals((Object[])new String[]{"C"}, (Object[])((String[])result));
    }

    @Test
    void test406a() {
        JexlEngine jexl = new JexlBuilder().cache(64).strict(true).safe(false).create();
        XuContext context = new XuContext();
        List<String> list = Arrays.asList("[1, 2, 3, 4, ...].join('-')", "[1, 2, 3, 4,].join('-')", "(1 .. 4).join('-')", "join([1, 2, 3, 4, ...], '-')", "join([1, 2, 3, 4], '-')", "join((1 .. 4), '-')");
        for (String src : list) {
            JexlScript script = jexl.createScript(src);
            Object result = script.execute((JexlContext)context);
            Assertions.assertEquals((Object)"1-2-3-4", (Object)result, (String)src);
        }
        String src0 = "x.join('*')";
        JexlScript script0 = jexl.createScript("x.join('*')", new String[]{"x"});
        String src1 = "join(x, '*')";
        JexlScript script1 = jexl.createScript("join(x, '*')", new String[]{"x"});
        for (Object x : Arrays.asList(Arrays.asList(1, 2, 3, 4), new int[]{1, 2, 3, 4})) {
            Object result = script0.execute((JexlContext)context, new Object[]{x});
            Assertions.assertEquals((Object)"1*2*3*4", (Object)result, (String)"x.join('*')");
            result = script1.execute((JexlContext)context, new Object[]{x});
            Assertions.assertEquals((Object)"1*2*3*4", (Object)result, (String)"join(x, '*')");
        }
    }

    @Test
    void test407() {
        double r = -7.105427357601002E-15;
        Assertions.assertEquals((double)0.0, (double)-7.105427357601002E-15, (double)8.0E-15);
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript script = jexl.createScript("a + b - a - b", new String[]{"a", "b"});
        Number result = (Number)script.execute(null, new Object[]{99.0, 7.82});
        Assertions.assertEquals((double)0.0, (double)result.doubleValue(), (double)8.0E-15);
        result = (Number)script.execute(null, new Object[]{new BigDecimal("99.0"), new BigDecimal("7.82")});
        Assertions.assertEquals((double)0.0, (double)result.doubleValue(), (double)3.0E-32);
    }

    @Test
    void test412() {
        HashMap<String, Integer> ctl = new HashMap<String, Integer>();
        ctl.put("one", 1);
        ctl.put("two", 2);
        String fnsrc0 = "function f(x) { x }\nlet one = 'one', two = 'two';\n";
        List<String> list = Arrays.asList("{ one : f(1), two:f(2) }", "{ one: f(1), two: f(2) }", "{ one: f(1), two:f(2) }", "{ one :f(1), two:f(2) }");
        for (String map0 : list) {
            String fnsrc = "function f(x) { x }\nlet one = 'one', two = 'two';\n" + map0;
            MapContext jc = new MapContext();
            JexlEngine jexl = new JexlBuilder().create();
            JexlScript e = jexl.createScript(fnsrc);
            Object o = e.execute((JexlContext)jc);
            Assertions.assertInstanceOf(Map.class, (Object)o);
            Map map = (Map)o;
            Assertions.assertEquals((Object)map, ctl);
        }
    }

    @Test
    void test413a() {
        JexlBuilder builder = new JexlBuilder();
        JexlEngine jexl = builder.create();
        JexlScript script = jexl.createScript("var c = 42; var f = y -> c += y; f(z)", new String[]{"z"});
        Number result = (Number)script.execute(null, new Object[]{12});
        Assertions.assertEquals((Object)54, (Object)result);
    }

    @Test
    void test413b() {
        JexlBuilder builder = new JexlBuilder();
        JexlOptions options = builder.options();
        options.setConstCapture(true);
        options.setLexical(true);
        JexlEngine jexl = builder.create();
        JexlScript script = jexl.createScript("var c = 42; var f = y -> c += y; f(z)", new String[]{"z"});
        JexlException.Variable xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> script.execute(null, new Object[]{12}), (String)"c should be const");
        Assertions.assertEquals((Object)"c", (Object)xvar.getVariable());
    }

    @Test
    void test413c() {
        JexlBuilder builder = new JexlBuilder();
        JexlEngine jexl = builder.create();
        String pragma = "#pragma jexl.options '+constCapture'\nvar c = 42; var f = y -> c += y; f(z)";
        JexlScript script = jexl.createScript("#pragma jexl.options '+constCapture'\nvar c = 42; var f = y -> c += y; f(z)", new String[]{"z"});
        JexlException.Variable xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> script.execute(null, new Object[]{12}), (String)"c should be const");
        Assertions.assertEquals((Object)"c", (Object)xvar.getVariable());
    }

    @Test
    void test413d() {
        JexlBuilder builder = new JexlBuilder().features(new JexlFeatures().constCapture(true));
        JexlEngine jexl = builder.create();
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createScript("var c = 42; var f = y -> c += y; f(z)", new String[]{"z"}), (String)"c should be const");
        Assertions.assertTrue((boolean)xparse.getMessage().contains("const"));
    }

    @Test
    void test415() {
        JexlBuilder builder = new JexlBuilder().features(new JexlFeatures().constCapture(true));
        JexlEngine jexl = builder.create();
        JexlScript script = jexl.createScript("`#${c}`", new String[]{"c"});
        Object result = script.execute(null, new Object[]{42});
        Assertions.assertEquals((Object)"#42", (Object)result.toString());
        script = jexl.createScript("`$${c}`", new String[]{"c"});
        result = script.execute(null, new Object[]{42});
        Assertions.assertEquals((Object)"$42", (Object)result.toString());
        script = jexl.createScript("`$#{c}`", new String[]{"c"});
        result = script.execute(null, new Object[]{42});
        Assertions.assertEquals((Object)"$42", (Object)result.toString());
        script = jexl.createScript("`##{c}`", new String[]{"c"});
        result = script.execute(null, new Object[]{42});
        Assertions.assertEquals((Object)"#42", (Object)result.toString());
        script = jexl.createScript("`--##{c}`", new String[]{"c"});
        result = script.execute(null, new Object[]{42});
        Assertions.assertEquals((Object)"--#42", (Object)result.toString());
    }

    @Test
    void test419() throws NoSuchMethodException {
        Method currentTimeMillis = System.class.getMethod("currentTimeMillis", new Class[0]);
        Assertions.assertFalse((boolean)JexlPermissions.RESTRICTED.allow(currentTimeMillis));
        JexlPermissions permissions = JexlPermissions.RESTRICTED.compose(new String[]{"java.lang { +System { currentTimeMillis(); } }"});
        Assertions.assertTrue((boolean)permissions.allow(currentTimeMillis));
        Assertions.assertFalse((boolean)JexlPermissions.RESTRICTED.allow(currentTimeMillis));
        JexlEngine jexl = new JexlBuilder().namespaces(Collections.singletonMap("sns", System.class)).permissions(permissions).create();
        AtomicLong result = new AtomicLong();
        Assertions.assertEquals((long)0L, (long)result.get());
        long now = System.currentTimeMillis();
        jexl.createScript("result.set(sns:currentTimeMillis())", new String[]{"result"}).execute(null, new Object[]{result});
        Assertions.assertTrue((result.get() >= now ? 1 : 0) != 0);
        JexlScript script = jexl.createScript("sns:gc()");
        JexlException.Method method = (JexlException.Method)Assertions.assertThrows(JexlException.Method.class, () -> script.execute(null));
        Assertions.assertEquals((Object)"gc", (Object)method.getMethod());
    }

    @Test
    void testDocBreakContinue() {
        JexlBuilder builder = new JexlBuilder().features(new JexlFeatures().constCapture(true));
        JexlEngine jexl = builder.create();
        String srcContinue = "let text = '';\nfor (let i : (4..2)) { if (i == 3) continue; text += i; }\ntext;";
        JexlScript script = jexl.createScript("let text = '';\nfor (let i : (4..2)) { if (i == 3) continue; text += i; }\ntext;");
        Object result = script.execute(null);
        Assertions.assertEquals((Object)"42", (Object)result);
        String srcBreak = "let i = 33;\nwhile (i < 66) { if (i == 42) { break; } i += 1; }\ni;";
        script = jexl.createScript("let i = 33;\nwhile (i < 66) { if (i == 42) { break; } i += 1; }\ni;");
        result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    void testNamespaceVsTernary0() {
        VinzContext ctxt = new VinzContext();
        ctxt.set("Users", "USERS");
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).silent(false).create();
        JexlScript script = jexl.createScript("() -> {\n  var fn = (user) -> {\n     user ? user : member(Users, 'user');\n  }\n}");
        Object r = script.execute((JexlContext)ctxt);
        Assertions.assertNotNull((Object)r);
        script = (JexlScript)r;
        r = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)"USERS.user", (Object)r);
    }

    @Test
    void testNamespaceVsTernary1() {
        VinzContext ctxt = new VinzContext();
        ctxt.set("Users", "USERS");
        ctxt.set("vinz", new VinzCaller((JexlContext)ctxt));
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).silent(false).create();
        JexlScript script = jexl.createScript("vinz.execute(() -> {\n  var test = 42;\n  var user = useTest ? test : member(Users, 'user');\n})\n", new String[]{"useTest"});
        Object r = script.execute((JexlContext)ctxt, new Object[]{false});
        Assertions.assertNotNull((Object)r);
        Assertions.assertEquals((Object)"USERS.user", (Object)r);
        r = script.execute((JexlContext)ctxt, new Object[]{true});
        Assertions.assertNotNull((Object)r);
        Assertions.assertEquals((Object)42, (Object)r);
    }

    @Test
    void test429a() {
        MapContext ctxt = new MapContext();
        JexlFeatures features = JexlFeatures.createDefault();
        JexlEngine jexl = new JexlBuilder().features(features).safe(false).strict(true).silent(false).create();
        JexlScript f = jexl.createScript("x -> x");
        ctxt.set("f", (Object)f);
        String src = "#pragma jexl.namespace.b " + Ns429.class.getName() + "\nb ? b : f(2);";
        JexlScript script = jexl.createScript(src, new String[]{"b"});
        Assertions.assertEquals((int)1, (int)((Integer)script.execute((JexlContext)ctxt, new Object[]{1})));
        src = "#pragma jexl.namespace.b " + Ns429.class.getName() + "\nb ? b:f(2) : 1;";
        script = jexl.createScript(src, new String[]{"b"});
        Assertions.assertEquals((int)20042, (int)((Integer)script.execute((JexlContext)ctxt, new Object[]{1})));
    }

    @Test
    void test429b() {
        MapContext ctxt = new MapContext();
        ctxt.set("b", (Object)1);
        JexlFeatures features = JexlFeatures.createDefault();
        features.namespaceIdentifier(true);
        JexlEngine jexl = new JexlBuilder().features(features).safe(false).strict(true).silent(false).create();
        JexlScript f = jexl.createScript("x -> x");
        ctxt.set("f", (Object)f);
        String src = "#pragma jexl.namespace.b " + Ns429.class.getName() + "\nb ? b : f(2);";
        JexlScript script = jexl.createScript(src);
        Assertions.assertEquals((int)1, (int)((Integer)script.execute((JexlContext)ctxt)));
        src = "#pragma jexl.namespace.b " + Ns429.class.getName() + "\nb ? b:f(2) : 1;";
        script = jexl.createScript(src);
        Assertions.assertEquals((int)20042, (int)((Integer)script.execute((JexlContext)ctxt)));
    }

    @Test
    void test431a() {
        JexlEngine jexl = new JexlBuilder().create();
        String src = "let x = 0; try { x += 19 } catch (let error) { return 169 } try { x += 23 } catch (let error) { return 169 }";
        JexlScript script = jexl.createScript("let x = 0; try { x += 19 } catch (let error) { return 169 } try { x += 23 } catch (let error) { return 169 }");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    Closeable foo() {
        return null;
    }

    @Test
    void test431b() {
        JexlEngine jexl = new JexlBuilder().create();
        String src = "let x = 0; try(let error) { x += 19 } catch (let error) { return 169 } try { x += 23 } catch (let error) { return 169 }";
        JexlScript script = jexl.createScript("let x = 0; try(let error) { x += 19 } catch (let error) { return 169 } try { x += 23 } catch (let error) { return 169 }");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    void test431c() {
        JexlEngine jexl = new JexlBuilder().create();
        String src = "let xx = 0; try { xx += 19 } catch (let xx) { return 169 }";
        try {
            JexlScript script = jexl.createScript("let xx = 0; try { xx += 19 } catch (let xx) { return 169 }");
            Assertions.fail((String)"xx is already defined in scope");
        }
        catch (JexlException.Parsing parsing) {
            Assertions.assertTrue((boolean)parsing.getDetail().contains("xx"));
        }
    }

    @Test
    void test433() {
        JexlEngine jexl = new JexlBuilder().create();
        String src = "let condition = true; if (condition) { return; }";
        JexlScript script = jexl.createScript("let condition = true; if (condition) { return; }");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertNull((Object)result);
        Debugger debugger = new Debugger();
        Assertions.assertTrue((boolean)debugger.debug(script));
        String dbgStr = debugger.toString();
        Assertions.assertTrue((boolean)JexlTestCase.equalsIgnoreWhiteSpace("let condition = true; if (condition) { return; }", dbgStr));
    }

    @Test
    void test434() {
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        String src = "let foo = null; let value = foo?[bar]";
        JexlScript script = jexl.createScript("let foo = null; let value = foo?[bar]");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertNull((Object)result);
    }

    @Test
    void test435() {
        Arithmetic435 arithmetic = new Arithmetic435(true);
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)arithmetic).create();
        String src = "empty('list')";
        JexlScript script = jexl.createScript("empty('list')");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertInstanceOf(List.class, (Object)result);
    }

    @Test
    void test436a() {
        String[] srcs = new String[]{"let i = null; ++i", "let i; ++i;", "let i; i--;", "let i; i++;"};
        this.run436(null, srcs);
    }

    @Test
    void test436b() {
        String[] srcs = new String[]{"var i = null; ++i", "var i; ++i;", "var i; i--;", "var i; i++;"};
        this.run436(null, srcs);
    }

    @Test
    void test436c() {
        MapContext ctxt = new MapContext();
        ctxt.set("i", null);
        String[] srcs = new String[]{"++i", "++i;", "i--;", "i++;"};
        this.run436(null, srcs);
    }

    void run436(JexlContext ctxt, String[] srcs) {
        JexlEngine jexl = new JexlBuilder().create();
        for (String src : srcs) {
            JexlScript script = jexl.createScript(src);
            Assertions.assertThrows(JexlException.Operator.class, () -> script.execute(ctxt));
        }
    }

    @Test
    void test437a() {
        JexlEngine jexl = new JexlBuilder().create();
        String src = "let values = [...]\nfunction append(const value) {\n  values.add(value)\n}\n\nappend(1)\nappend(2)\nreturn values ";
        JexlScript script = jexl.createScript("let values = [...]\nfunction append(const value) {\n  values.add(value)\n}\n\nappend(1)\nappend(2)\nreturn values ");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertInstanceOf(List.class, (Object)result);
        List values = (List)result;
        Assertions.assertEquals((int)2, (int)values.size());
    }

    @Test
    void test437b() {
        JexlFeatures features = JexlFeatures.createDefault().ambiguousStatement(true);
        Assertions.assertTrue((boolean)features.supportsAmbiguousStatement());
        JexlEngine jexl = new JexlBuilder().features(features).create();
        String src = "let values = [...]function append(const value) {  values.add(value)}append(1)append(2)return values ";
        JexlScript script = jexl.createScript("let values = [...]function append(const value) {  values.add(value)}append(1)append(2)return values ");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertInstanceOf(List.class, (Object)result);
        List values = (List)result;
        Assertions.assertEquals((int)2, (int)values.size());
    }

    private static String transcodeSQLExpr(CharSequence expr) {
        StringBuilder strb = new StringBuilder(expr.length());
        int end = expr.length();
        char previous = '\u0000';
        for (int i = 0; i < end; ++i) {
            char c = expr.charAt(i);
            if (previous == '<') {
                if (c == '>') {
                    strb.append("!=");
                    previous = c;
                    continue;
                }
                strb.append('<');
            }
            if (c != '<') {
                if (c == '=') {
                    if (Arrays.binarySearch(EQ_FRIEND, previous) >= 0) {
                        strb.append(c);
                    } else {
                        strb.append("==");
                    }
                } else {
                    strb.append(c);
                    if (c == '\"' || c == '\'') {
                        boolean escape = false;
                        ++i;
                        while (i < end) {
                            char ec = expr.charAt(i);
                            strb.append(ec);
                            if (ec == '\\') {
                                escape = !escape;
                            } else if (escape) {
                                escape = false;
                            } else if (ec == c) break;
                            ++i;
                        }
                    }
                }
            }
            previous = c;
        }
        return strb.toString();
    }

    @Test
    void testSQLTranspose() {
        String[] e = new String[]{"a<>b", "a = 2", "a.b.c <> '1<>0'"};
        String[] j = new String[]{"a!=b", "a == 2", "a.b.c != '1<>0'"};
        for (int i = 0; i < e.length; ++i) {
            String je = Issues400Test.transcodeSQLExpr(e[i]);
            Assertions.assertEquals((Object)j[i], (Object)je);
        }
    }

    @Test
    void testSQLNoChange() {
        String[] e;
        for (String element : e = new String[]{"a <= 2", "a >= 2", "a := 2", "a + 3 << 4 > 5"}) {
            String je = Issues400Test.transcodeSQLExpr(element);
            Assertions.assertEquals((Object)element, (Object)je);
        }
    }

    @Test
    void test438() {
        JexlFeatures f = new JexlFeatures().localVar(false).lambda(false).loops(false).sideEffect(false).sideEffectGlobal(false);
        JexlBuilder builder = new JexlBuilder().parserFactory(SQLParser::new).cache(32).features(f);
        JexlEngine sqle = builder.create();
        Assertions.assertTrue((boolean)((Boolean)sqle.createScript("a <> 25", new String[]{"a"}).execute(null, new Object[]{24})));
        Assertions.assertFalse((boolean)((Boolean)sqle.createScript("a <> 25", new String[]{"a"}).execute(null, new Object[]{25})));
        Assertions.assertFalse((boolean)((Boolean)sqle.createScript("a = 25", new String[]{"a"}).execute(null, new Object[]{24})));
        Assertions.assertTrue((boolean)((Boolean)sqle.createScript("a != 25", new String[]{"a"}).execute(null, new Object[]{24})));
        Assertions.assertTrue((boolean)((Boolean)sqle.createScript("a = 25", new String[]{"a"}).execute(null, new Object[]{25})));
        Assertions.assertFalse((boolean)((Boolean)sqle.createScript("a != 25", new String[]{"a"}).execute(null, new Object[]{25})));
    }

    @Test
    void testIssue441() {
        JexlEngine jexl = new JexlBuilder().create();
        String ctl = "\nab\nc`d\n";
        JexlExpression e = jexl.createExpression("`\nab\nc\\`d\n`");
        Object o = e.evaluate(null);
        Assertions.assertEquals((Object)ctl, (Object)o);
        MapContext context = new MapContext();
        context.set("name", (Object)"Hello");
        String code = "return `${name + '\\n' + name}`;";
        JexlScript script = jexl.createScript("return `${name + '\\n' + name}`;");
        o = script.execute((JexlContext)context);
        ctl = "Hello\nHello";
        Assertions.assertEquals((Object)ctl, (Object)o);
    }

    @Test
    void testIssue442() {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext context = new MapContext();
        String code = "var x = 'hello';\nfunction test(z) {\n`${x} ${z}`;\n}\ntest('world');";
        JexlScript script = jexl.createScript("var x = 'hello';\nfunction test(z) {\n`${x} ${z}`;\n}\ntest('world');");
        Object result = script.execute((JexlContext)context);
        Assertions.assertEquals((Object)"hello world", (Object)result);
    }

    @Test
    void testIssue447() {
        JexlEngine jexl = new JexlBuilder().create();
        String src = "const c = `${a}\n?= ${b}`; function foo(const left, const right) { `${left}\n?== ${right}` } c+foo(a, b)";
        JexlScript script = jexl.createScript("const c = `${a}\n?= ${b}`; function foo(const left, const right) { `${left}\n?== ${right}` } c+foo(a, b)", new String[]{"a", "b"});
        Object result = script.execute(null, new Object[]{"a", "b"});
        Assertions.assertEquals((Object)"a\n?= ba\n?== b", (Object)result);
        Object[] locals = script.getLocalVariables();
        Assertions.assertArrayEquals((Object[])new String[]{"c", "foo"}, (Object[])locals);
        String TEST447 = "src/test/scripts/test447.jexl";
        File src447 = new File("src/test/scripts/test447.jexl");
        JexlScript script447 = jexl.createScript(src447);
        Object result447 = script447.execute(null);
        Assertions.assertInstanceOf(List.class, (Object)result447);
        List list = (List)result447;
        for (Boolean item : list) {
            Assertions.assertTrue((boolean)item);
        }
    }

    @Test
    void test450a() {
        JexlEngine jexl0 = new JexlBuilder().silent(false).permissions(JexlPermissions.RESTRICTED).create();
        Assertions.assertThrows(JexlException.Method.class, () -> jexl0.newInstance("org.apache.commons.jexl3.internal.introspection.Uberspect", new Object[]{null, null}), (String)"should not be able to create Uberspect with RESTRICTED");
        JexlPermissions.ClassPermissions perm = new JexlPermissions.ClassPermissions(new Class[]{Uberspect.class});
        JexlEngine jexl1 = new JexlBuilder().silent(false).permissions((JexlPermissions)perm).create();
        Assertions.assertNotNull((Object)jexl1.newInstance("org.apache.commons.jexl3.internal.introspection.Uberspect", new Object[]{null, null}), (String)"should able to create Uberspect with Uberspect permission");
    }

    @Test
    void test450b() {
        Assertions.assertThrows(JexlException.Method.class, () -> Issues400Test.run450b(JexlPermissions.RESTRICTED), (String)"should not be able to load System with RESTRICTED");
        Assertions.assertEquals(System.class, (Object)Issues400Test.run450b(JexlPermissions.UNRESTRICTED));
        JexlPermissions.ClassPermissions perm = new JexlPermissions.ClassPermissions(new Class[]{this.getClass().getClassLoader().getClass(), Uberspect.class});
        Assertions.assertEquals(System.class, (Object)Issues400Test.run450b((JexlPermissions)perm));
    }

    private static Object run450b(JexlPermissions perm) {
        JexlEngine jexl = new JexlBuilder().silent(false).permissions(perm).create();
        String uscript = "new('org.apache.commons.jexl3.internal.introspection.Uberspect', null, null, perm).getClassLoader().loadClass('java.lang.System')";
        JexlScript u0 = jexl.createScript(uscript, new String[]{"perm"});
        return u0.execute(null, new Object[]{perm});
    }

    @Test
    void test450c() {
        Assertions.assertNotNull((Object)Issues400Test.run450c(JexlPermissions.UNRESTRICTED));
        JexlPermissions.ClassPermissions perm = new JexlPermissions.ClassPermissions(new Class[]{JexlPermissions.ClassPermissions.class, Uberspect.class});
        Assertions.assertNotNull((Object)Issues400Test.run450c((JexlPermissions)perm));
        Assertions.assertThrows(JxltEngine.Exception.class, () -> Issues400Test.run450c(JexlPermissions.RESTRICTED), (String)"should not be able to load System with RESTRICTED");
    }

    private static Object run450c(JexlPermissions perm) {
        JexlBuilder builder = new JexlBuilder().silent(false).permissions(perm);
        Object result = new TemplateEngine((Engine)new Engine32(builder), false, 2, '$', '#').createExpression("${x = new ('org.apache.commons.jexl3.internal.introspection.Uberspect', null, null, UNRESTRICTED);sys = x?.getClassLoader()?.loadClass('java.lang.System') ?: SYSTEM;p = new('org.apache.commons.jexl3.introspection.JexlPermissions$ClassPermissions', [sys]);c = new('org.apache.commons.jexl3.internal.introspection.Uberspect', null, null, p);z = c.getMethod(sys,'currentTimeMillis').invoke(x,null);}").evaluate((JexlContext)new BrkContext());
        return result;
    }

    @Test
    void test450() {
        Assertions.assertNotNull((Object)Issues400Test.run450(JexlPermissions.UNRESTRICTED), (String)"should be able to reach and invoke System::currentTimeMillis with UNRESTRICTED");
        Assertions.assertNotNull((Object)Issues400Test.run450((JexlPermissions)new JexlPermissions.ClassPermissions(new Class[]{TemplateEngine.class})), (String)"should be able to reach and invoke System::currentTimeMillis with TemplateEngine permission");
        Assertions.assertThrows(JexlException.Method.class, () -> Issues400Test.run450(JexlPermissions.RESTRICTED), (String)"should not be able to reach and invoke System::currentTimeMillis with RESTRICTED");
    }

    private static Object run450(JexlPermissions perm) {
        JexlEngine jexl = new JexlBuilder().silent(false).strict(true).safe(false).permissions(perm).create();
        String script = "new('org.apache.commons.jexl3.internal.TemplateEngine',new('org.apache.commons.jexl3.Issues400Test$Engine33'),false,256,'$'.charAt(0),'#'.charAt(0)).createExpression(\"#{x = new ('org.apache.commons.jexl3.internal.introspection.Uberspect', null, null);sys = x?.getClassLoader().loadClass('java.lang.System') ?: SYSTEM;p = new('org.apache.commons.jexl3.introspection.JexlPermissions$ClassPermissions', [sys]);c = new('org.apache.commons.jexl3.internal.introspection.Uberspect', null, null, p);z = c.getMethod(sys,'currentTimeMillis').invoke(x,null);}\").evaluate(new('org.apache.commons.jexl3.Issues400Test$BrkContext'))";
        return jexl.createScript(script).execute(null);
    }

    @Test
    void test451() {
        JexlEngine jexl = new JexlBuilder().create();
        Assertions.assertEquals((Object)"42", (Object)jexl.createScript("o.toString()", new String[]{"o"}).execute(null, new Object[]{"42"}));
        JexlPermissions perms = JexlPermissions.RESTRICTED.compose(new String[]{"java.lang { +Class { getSimpleName(); } }"});
        JexlSandbox sandbox = new JexlSandbox(false, true);
        sandbox.permissions(Object.class.getName(), true, true, false, false);
        sandbox.allow(String.class.getName()).execute(new String[]{"toString"});
        JexlEngine jexl451 = new JexlBuilder().safe(false).silent(false).permissions(perms).sandbox(sandbox).create();
        Assertions.assertEquals((Object)"42", (Object)jexl451.createScript("o.toString()", new String[]{"o"}).execute(null, new Object[]{"42"}));
        Assertions.assertThrows(JexlException.Method.class, () -> jexl451.createScript("oo.getClass()", new String[]{"oo"}).execute(null, new Object[]{"42"}));
        Assertions.assertEquals(String.class, (Object)jexl451.createScript("o.class", new String[]{"o"}).execute(null, new Object[]{"42"}));
        Assertions.assertEquals((Object)"Object", (Object)jexl451.createScript("o.class.simpleName", new String[]{"o"}).execute(null, new Object[]{new Object()}));
        Assertions.assertThrows(JexlException.Property.class, () -> jexl451.createScript("o.class.classLoader", new String[]{"o"}).execute(null, new Object[]{new Object()}));
    }

    @Test
    void testIssue455a() {
        JexlEngine jexl = new JexlBuilder().create();
        String code = "name -> `${name +\n\t\f\r name}`";
        JexlScript script = jexl.createScript(code);
        Object o = script.execute(null, new Object[]{"Hello"});
        String ctl = "HelloHello";
        Assertions.assertEquals((Object)ctl, (Object)o);
    }

    @Test
    void testIssue455b() {
        JexlEngine jexl = new JexlBuilder().create();
        String code = "name -> `${name}\n${name}`;";
        JexlScript script = jexl.createScript(code);
        Object o = script.execute(null, new Object[]{"Hello"});
        String ctl = "Hello\nHello";
        Assertions.assertEquals((Object)ctl, (Object)o);
    }

    @Test
    void testIssue455c() {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext context = new MapContext();
        context.set("name", (Object)"Hello");
        JxltEngine jxlt = jexl.createJxltEngine();
        JxltEngine.Template template = jxlt.createTemplate("<b>\n\t${name\n\t+\r\f name}\n</b>");
        StringWriter writer = new StringWriter();
        template.evaluate((JexlContext)context, (Writer)writer);
        Assertions.assertEquals((Object)"<b>\n\tHelloHello\n</b>", (Object)writer.toString());
    }

    @Test
    void testIssue455d() {
        JexlEngine jexl = new JexlBuilder().create();
        String code = "`#{${\nref\t}}\n#{${\rref\f}}`;";
        JexlScript script = jexl.createScript(code, new String[]{"ref", "greeting"});
        Object o = script.execute(null, new Object[]{"greeting", "Hello"});
        String ctl = "Hello\nHello";
        Assertions.assertEquals((Object)ctl, (Object)o);
    }

    @Test
    void testIssue455e() {
        JexlEngine jexl = new JexlBuilder().create();
        String src = "(name, suffix) -> `#{name} Hello ${name} ! #{suffix}`";
        JexlScript script = jexl.createScript("(name, suffix) -> `#{name} Hello ${name} ! #{suffix}`");
        Object result = script.execute(null, new Object[]{"World", "~"});
        Assertions.assertEquals((Object)"World Hello World ! ~", (Object)result);
    }

    @Test
    void testIssue455f() {
        JexlEngine jexl = new JexlBuilder().create();
        String src = "(name, suffix) -> `#{name + ' Hello'} ${name + ' !'} #{suffix}`";
        JexlScript script = jexl.createScript("(name, suffix) -> `#{name + ' Hello'} ${name + ' !'} #{suffix}`");
        Object result = script.execute(null, new Object[]{"World", "~"});
        Assertions.assertEquals((Object)"World Hello World ! ~", (Object)result);
    }

    @Test
    void testIssue455g() {
        JexlEngine jexl = new JexlBuilder().create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JxltEngine.Template template = jxlt.createTemplate("${name} #{suffix}", new String[]{"name", "suffix"});
        StringWriter writer = new StringWriter();
        template.prepare(null, new Object[]{"World", null}).evaluate(null, (Writer)writer, new Object[]{null, "~"});
        Assertions.assertEquals((Object)"World ~", (Object)writer.toString());
    }

    @Test
    void testIssue455h() {
        JexlEngine jexl = new JexlBuilder().create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JxltEngine.Template template = jxlt.createTemplate("#{name + ' Hello'} ${name + ' !'} #{suffix}", new String[]{"name", "suffix"});
        StringWriter writer = new StringWriter();
        template.prepare(null, new Object[]{"World"}).evaluate(null, (Writer)writer, new Object[]{"World", "~"});
        Assertions.assertEquals((Object)"World Hello World ! ~", (Object)writer.toString());
    }

    static {
        char[] eq = new char[]{'!', ':', '<', '>', '^', '|', '&', '+', '-', '/', '*', '~', '='};
        Arrays.sort(eq);
        EQ_FRIEND = eq;
    }

    public static class XuContext
    extends MapContext {
        public String join(int[] list, String str) {
            return this.join(Arrays.stream(list).iterator(), str);
        }

        public String join(Iterable<?> list, String str) {
            return this.join(list.iterator(), str);
        }

        public String join(Iterator<?> iterator, String str) {
            if (!iterator.hasNext()) {
                return "";
            }
            StringBuilder strb = new StringBuilder(256);
            strb.append(iterator.next().toString());
            while (iterator.hasNext()) {
                strb.append(str);
                strb.append(Objects.toString(iterator.next(), "?"));
            }
            return strb.toString();
        }
    }

    public static class VinzContext
    extends MapContext {
        public String member(String m, String u) {
            return m + '.' + u;
        }
    }

    public static class VinzCaller {
        private final JexlContext context;

        VinzCaller(JexlContext context) {
            this.context = context;
        }

        public Object execute(JexlScript script) {
            return script.execute(this.context);
        }
    }

    public static class Ns429 {
        public int f(int x) {
            return x * 10000 + 42;
        }
    }

    public static class Arithmetic435
    extends JexlArithmetic {
        public Arithmetic435(boolean strict) {
            super(strict);
        }

        public Object empty(String type) {
            if ("list".equals(type)) {
                return Collections.emptyList();
            }
            return null;
        }
    }

    public static class BrkContext
    extends MapContext {
        public BrkContext() {
            this.set("SYSTEM", System.class);
            this.set("UNRESTRICTED", JexlPermissions.UNRESTRICTED);
        }

        public static Object brk(Object debug) {
            return debug;
        }
    }

    public static class Engine33
    extends Engine32 {
        public Engine33() {
            this(Engine33.createBuilder());
        }

        public Engine33(JexlBuilder builder) {
            super(builder);
        }

        static JexlBuilder createBuilder() {
            JexlPermissions.ClassPermissions perm = new JexlPermissions.ClassPermissions(new Class[]{Issues400Test.class.getClassLoader().getClass(), JexlPermissions.ClassPermissions.class, TemplateEngine.class, Uberspect.class});
            return new JexlBuilder().safe(false).silent(false).permissions((JexlPermissions)perm);
        }
    }

    public static class SQLParser
    implements JexlScriptParser {
        final Parser parser = new Parser((Provider)new StringProvider(";"));

        public ASTJexlScript parse(JexlInfo info, JexlFeatures features, String src, Scope scope) {
            return this.parser.parse(info, features, Issues400Test.transcodeSQLExpr(src), scope);
        }

        public ASTJexlScript jxltParse(JexlInfo info, JexlFeatures features, String src, Scope scope) {
            return new Parser((JexlParser)this.parser).parse(info, features, Issues400Test.transcodeSQLExpr(src), scope);
        }
    }
}

