/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.ConnectionErrorException;
import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2PushBackParser;
import java.nio.ByteBuffer;
import org.xnio.Bits;

class Http2DataFrameParser
extends Http2PushBackParser {
    private int padding = 0;

    Http2DataFrameParser(int frameLength) {
        super(frameLength);
    }

    @Override
    protected void handleData(ByteBuffer resource, Http2FrameHeaderParser headerParser) throws ConnectionErrorException {
        if (Bits.anyAreClear((int)headerParser.flags, (int)8)) {
            this.finish();
            return;
        }
        if (headerParser.length == 0) {
            throw new ConnectionErrorException(1);
        }
        if (resource.remaining() > 0) {
            this.padding = resource.get() & 0xFF;
            --headerParser.length;
            if (this.padding > headerParser.length) {
                throw new ConnectionErrorException(1);
            }
            this.finish();
        }
    }

    int getPadding() {
        return this.padding;
    }
}

