/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import jakarta.ws.rs.core.Form;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.common.UserInfo;
import org.apache.cxf.rs.security.oidc.rp.OidcClaimsValidator;

public class UserInfoClient
extends OidcClaimsValidator {
    private boolean sendTokenAsFormParameter;
    private WebClient profileClient;
    private boolean getUserInfoFromJwt;

    public UserInfo getUserInfo(ClientAccessToken at, IdToken idToken, Consumer client) {
        if (!this.sendTokenAsFormParameter) {
            OAuthClientUtils.setAuthorizationHeader((WebClient)this.profileClient, (ClientAccessToken)at);
            if (this.getUserInfoFromJwt) {
                String jwt = (String)this.profileClient.get(String.class);
                return this.getUserInfoFromJwt(jwt, idToken, client);
            }
            UserInfo profile = (UserInfo)((Object)this.profileClient.get(UserInfo.class));
            this.validateUserInfo(profile, idToken, client);
            return profile;
        }
        Form form = new Form().param("access_token", at.getTokenKey());
        if (this.getUserInfoFromJwt) {
            String jwt = (String)this.profileClient.form(form).readEntity(String.class);
            return this.getUserInfoFromJwt(jwt, idToken, client);
        }
        UserInfo profile = (UserInfo)((Object)this.profileClient.form(form).readEntity(UserInfo.class));
        this.validateUserInfo(profile, idToken, client);
        return profile;
    }

    public UserInfo getUserInfoFromJwt(String profileJwtToken, IdToken idToken, Consumer client) {
        JwtToken jwt = this.getUserInfoJwt(profileJwtToken, client);
        return this.getUserInfoFromJwt(jwt, idToken, client);
    }

    public UserInfo getUserInfoFromJwt(JwtToken jwt, IdToken idToken, Consumer client) {
        UserInfo profile = new UserInfo(jwt.getClaims().asMap());
        this.validateUserInfo(profile, idToken, client);
        return profile;
    }

    public JwtToken getUserInfoJwt(String profileJwtToken, Consumer client) {
        return this.getJwtToken(profileJwtToken);
    }

    public void validateUserInfo(UserInfo profile, IdToken idToken, Consumer client) {
        this.validateJwtClaims(profile, client.getClientId(), false);
        if (!idToken.getSubject().equals(profile.getSubject())) {
            throw new OAuthServiceException("Invalid subject");
        }
    }

    public void setUserInfoServiceClient(WebClient client) {
        this.profileClient = client;
    }

    public void setSendTokenAsFormParameter(boolean sendTokenAsFormParameter) {
        this.sendTokenAsFormParameter = sendTokenAsFormParameter;
    }

    public void setGetUserInfoFromJwt(boolean getUserInfoFromJwt) {
        this.getUserInfoFromJwt = getUserInfoFromJwt;
    }
}

