/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.jgroups;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.jgroups.JChannelManager;
import org.apache.activemq.artemis.api.core.jgroups.JGroupsReceiver;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JChannelWrapper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean connected = false;
    AtomicInteger refCount = new AtomicInteger(1);
    final JChannel channel;
    final String channelName;
    final List<JGroupsReceiver> receivers = new ArrayList<JGroupsReceiver>();
    private final JChannelManager manager;

    public JChannelWrapper(JChannelManager manager, final String channelName, JChannel channel) throws Exception {
        this.channelName = channelName;
        this.channel = channel;
        this.manager = manager;
        if (logger.isTraceEnabled() && channel.getReceiver() != null) {
            logger.trace("{} The channel already had a receiver previously!!!! == {}", new Object[]{this, channel.getReceiver(), new Exception("trace")});
        }
        channel.setReceiver(new Receiver(){
            final /* synthetic */ JChannelWrapper this$0;
            {
                this.this$0 = this$0;
            }

            public String toString() {
                return "ReceiverAdapter::" + String.valueOf(this.this$0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receive(Message msg) {
                if (logger.isTraceEnabled()) {
                    logger.trace("{}:: Wrapper received {} on channel {}", new Object[]{this, msg, channelName});
                }
                List<JGroupsReceiver> list = this.this$0.receivers;
                synchronized (list) {
                    for (JGroupsReceiver r : this.this$0.receivers) {
                        r.receive(msg);
                    }
                }
            }
        });
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void close(boolean closeWrappedChannel) {
        this.manager.closeWrapper(this, closeWrappedChannel);
    }

    public synchronized void closeChannel() {
        this.connected = false;
        this.channel.setReceiver(null);
        if (logger.isTraceEnabled()) {
            logger.trace("{}::Closing Channel: {}", new Object[]{this, this.channelName, new Exception("Trace")});
        }
        this.channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReceiver(JGroupsReceiver receiver) {
        if (logger.isTraceEnabled()) {
            logger.trace("{}::removeReceiver: {} on {}", new Object[]{this, receiver, this.channelName, new Exception("Trace")});
        }
        List<JGroupsReceiver> list = this.receivers;
        synchronized (list) {
            this.receivers.remove(receiver);
        }
    }

    public synchronized void connect() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("{}:: Connecting {}", new Object[]{this, this.channelName, new Exception("Trace")});
        }
        if (this.connected) {
            return;
        }
        this.connected = true;
        if (!this.channel.isConnected()) {
            this.channel.connect(this.channelName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReceiver(JGroupsReceiver jGroupsReceiver) {
        List<JGroupsReceiver> list = this.receivers;
        synchronized (list) {
            if (logger.isTraceEnabled()) {
                logger.trace("{}::Add Receiver: {} on {}", new Object[]{this, jGroupsReceiver, this.channelName});
            }
            this.receivers.add(jGroupsReceiver);
        }
    }

    public void send(Message msg) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("{}::Sending JGroups Message: Open={} on channel {} msg={}", new Object[]{this, this.channel.isOpen(), this.channelName, msg});
        }
        if (!this.manager.isLoopbackMessages()) {
            msg.setFlag(new Message.TransientFlag[]{Message.TransientFlag.DONT_LOOPBACK});
        }
        this.channel.send(msg);
    }

    public JChannelWrapper addRef() {
        int count = this.refCount.incrementAndGet();
        if (logger.isTraceEnabled()) {
            logger.trace("{}::RefCount++ = {} on channel {}", new Object[]{this, count, this.channelName});
        }
        return this;
    }

    public int decRef() {
        int count = this.refCount.decrementAndGet();
        if (logger.isTraceEnabled()) {
            logger.trace("{}::RefCount-- {} on channel {}", new Object[]{this, count, this.channelName, new Exception("Trace")});
        }
        return count;
    }

    public String toString() {
        return super.toString() + "{refCount=" + this.refCount.get() + ", channel=" + String.valueOf(this.channel) + ", channelName='" + this.channelName + "', connected=" + this.connected + "}";
    }
}

