/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.lc.type;

import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.lc.type.TypeFormatContext;
import org.mozilla.javascript.lc.type.VariableTypeInfo;
import org.mozilla.javascript.lc.type.impl.ArrayTypeInfo;
import org.mozilla.javascript.lc.type.impl.BasicClassTypeInfo;
import org.mozilla.javascript.lc.type.impl.InterfaceTypeInfo;
import org.mozilla.javascript.lc.type.impl.NoTypeInfo;
import org.mozilla.javascript.lc.type.impl.PrimitiveClassTypeInfo;

public interface TypeInfo {
    public static final TypeInfo NONE = NoTypeInfo.INSTANCE;
    public static final TypeInfo OBJECT = new BasicClassTypeInfo(Object.class);
    public static final TypeInfo OBJECT_ARRAY = new ArrayTypeInfo(OBJECT);
    public static final TypeInfo PRIMITIVE_VOID = new PrimitiveClassTypeInfo(Void.TYPE, null);
    public static final TypeInfo PRIMITIVE_BOOLEAN = new PrimitiveClassTypeInfo(Boolean.TYPE, false);
    public static final TypeInfo PRIMITIVE_BYTE = new PrimitiveClassTypeInfo(Byte.TYPE, (byte)0);
    public static final TypeInfo PRIMITIVE_SHORT = new PrimitiveClassTypeInfo(Short.TYPE, (short)0);
    public static final TypeInfo PRIMITIVE_INT = new PrimitiveClassTypeInfo(Integer.TYPE, 0);
    public static final TypeInfo PRIMITIVE_LONG = new PrimitiveClassTypeInfo(Long.TYPE, 0L);
    public static final TypeInfo PRIMITIVE_FLOAT = new PrimitiveClassTypeInfo(Float.TYPE, Float.valueOf(0.0f));
    public static final TypeInfo PRIMITIVE_DOUBLE = new PrimitiveClassTypeInfo(Double.TYPE, 0.0);
    public static final TypeInfo PRIMITIVE_CHARACTER = new PrimitiveClassTypeInfo(Character.TYPE, Character.valueOf('\u0000'));
    public static final TypeInfo VOID = new BasicClassTypeInfo(Void.class);
    public static final TypeInfo BOOLEAN = new BasicClassTypeInfo(Boolean.class);
    public static final TypeInfo BYTE = new BasicClassTypeInfo(Byte.class);
    public static final TypeInfo SHORT = new BasicClassTypeInfo(Short.class);
    public static final TypeInfo INT = new BasicClassTypeInfo(Integer.class);
    public static final TypeInfo LONG = new BasicClassTypeInfo(Long.class);
    public static final TypeInfo FLOAT = new BasicClassTypeInfo(Float.class);
    public static final TypeInfo DOUBLE = new BasicClassTypeInfo(Double.class);
    public static final TypeInfo CHARACTER = new BasicClassTypeInfo(Character.class);
    public static final TypeInfo NUMBER = new BasicClassTypeInfo(Number.class);
    public static final TypeInfo STRING = new BasicClassTypeInfo(String.class);
    public static final TypeInfo STRING_ARRAY = new ArrayTypeInfo(STRING);
    public static final TypeInfo RAW_CLASS = new BasicClassTypeInfo(Class.class);
    public static final TypeInfo DATE = new BasicClassTypeInfo(Date.class);
    public static final TypeInfo RUNNABLE = new InterfaceTypeInfo(Runnable.class, 1);
    public static final TypeInfo RAW_CONSUMER = new InterfaceTypeInfo(Consumer.class, 1);
    public static final TypeInfo RAW_SUPPLIER = new InterfaceTypeInfo(Supplier.class, 1);
    public static final TypeInfo RAW_FUNCTION = new InterfaceTypeInfo(Function.class, 1);
    public static final TypeInfo RAW_PREDICATE = new InterfaceTypeInfo(Predicate.class, 1);
    public static final TypeInfo RAW_LIST = new InterfaceTypeInfo(List.class, 0);
    public static final TypeInfo RAW_SET = new InterfaceTypeInfo(Set.class, 0);
    public static final TypeInfo RAW_MAP = new InterfaceTypeInfo(Map.class, 0);
    public static final TypeInfo RAW_OPTIONAL = new BasicClassTypeInfo(Optional.class);
    public static final TypeInfo RAW_ENUM_SET = new BasicClassTypeInfo(EnumSet.class);
    public static final TypeInfo BIG_INT = new BasicClassTypeInfo(BigInteger.class);

    public Class<?> asClass();

    default public TypeInfo param(int index) {
        return NONE;
    }

    default public boolean is(Class<?> c) {
        return this.asClass() == c;
    }

    default public boolean isNot(Class<?> c) {
        return !this.is(c);
    }

    default public boolean isPrimitive() {
        return false;
    }

    default public boolean shouldReplace() {
        return false;
    }

    public String toString();

    public String toString(TypeFormatContext var1);

    default public TypeInfo getComponentType() {
        return NONE;
    }

    default public Object newArray(int length) {
        return Array.newInstance(this.asClass(), length);
    }

    default public boolean isInterface() {
        return false;
    }

    default public boolean isFunctionalInterface() {
        return false;
    }

    default public boolean isEnum() {
        return false;
    }

    default public List<Object> enumConstants() {
        return List.of();
    }

    default public Object createDefaultValue() {
        return null;
    }

    default public boolean isVoid() {
        return false;
    }

    default public boolean isBoolean() {
        return false;
    }

    default public boolean isNumber() {
        return Number.class.isAssignableFrom(this.asClass());
    }

    default public boolean isByte() {
        return false;
    }

    default public boolean isShort() {
        return false;
    }

    default public boolean isInt() {
        return false;
    }

    default public boolean isLong() {
        return false;
    }

    default public boolean isFloat() {
        return false;
    }

    default public boolean isDouble() {
        return false;
    }

    default public boolean isCharacter() {
        return false;
    }

    default public boolean isString() {
        return false;
    }

    default public boolean isObjectExact() {
        return false;
    }

    default public boolean isArray() {
        return false;
    }

    default public boolean isAssignableFrom(TypeInfo another) {
        return this.asClass().isAssignableFrom(another.asClass());
    }

    default public boolean isInstance(Object o) {
        return this.asClass().isInstance(o);
    }

    default public int getTypeTag() {
        if (this == STRING) {
            return 1;
        }
        if (this.isInt()) {
            return 2;
        }
        if (this.isBoolean()) {
            return 3;
        }
        if (this.isDouble()) {
            return 4;
        }
        if (Scriptable.class.isAssignableFrom(this.asClass())) {
            return 5;
        }
        if (this.isObjectExact()) {
            return 6;
        }
        return 0;
    }

    default public TypeInfo consolidate(Map<VariableTypeInfo, TypeInfo> mapping) {
        return this;
    }
}

