/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.tools;

import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xmlresolver.Resolver;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.tools.ResolvingXMLFilter;

public class ResolvingXMLReader
extends ResolvingXMLFilter {
    public ResolvingXMLReader() {
        this.initialize(null);
    }

    public ResolvingXMLReader(SAXParserFactory factory) {
        this.initialize(factory);
    }

    public ResolvingXMLReader(Resolver resolver) {
        super(resolver);
        this.initialize(null);
    }

    public ResolvingXMLReader(SAXParserFactory factory, Resolver resolver) {
        super(resolver);
        this.initialize(factory);
    }

    private void initialize(SAXParserFactory userFactory) {
        SAXParserFactory factory = userFactory;
        if (factory != null) {
            try {
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                this.setParent(parser.getXMLReader());
                return;
            }
            catch (ParserConfigurationException | SAXException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
        Supplier<XMLReader> readerSupplier = this.resolver.getConfiguration().getFeature(ResolverFeature.XMLREADER_SUPPLIER);
        if (readerSupplier != null) {
            this.setParent(readerSupplier.get());
            return;
        }
        factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            SAXParser parser = factory.newSAXParser();
            this.setParent(parser.getXMLReader());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

