/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.dpath;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Numbers$;
import org.apache.daffodil.runtime1.dpath.CompiledDPath;
import org.apache.daffodil.runtime1.dpath.DState;
import org.apache.daffodil.runtime1.dpath.FNOneArg;
import org.apache.daffodil.runtime1.dpath.FNRound$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dpath.NodeInfo$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Decimal$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Double$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Float$;
import org.apache.daffodil.runtime1.infoset.DataValue;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public class FNRound
extends FNOneArg
implements Product {
    private final CompiledDPath recipe;
    private final NodeInfo.Kind argType;

    public static FNRound apply(CompiledDPath compiledDPath, NodeInfo.Kind kind) {
        return FNRound$.MODULE$.apply(compiledDPath, kind);
    }

    public static FNRound fromProduct(Product product) {
        return FNRound$.MODULE$.fromProduct(product);
    }

    public static FNRound unapply(FNRound fNRound) {
        return FNRound$.MODULE$.unapply(fNRound);
    }

    public FNRound(CompiledDPath recipe, NodeInfo.Kind argType) {
        this.recipe = recipe;
        this.argType = argType;
        super(recipe, argType);
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -91753959, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FNRound)) return false;
        FNRound fNRound = (FNRound)object;
        CompiledDPath compiledDPath = this.recipe();
        CompiledDPath compiledDPath2 = fNRound.recipe();
        if (compiledDPath == null) {
            if (compiledDPath2 != null) {
                return false;
            }
        } else if (!compiledDPath.equals(compiledDPath2)) return false;
        NodeInfo.Kind kind = this.argType();
        NodeInfo.Kind kind2 = fNRound.argType();
        if (kind == null) {
            if (kind2 != null) {
                return false;
            }
        } else if (!kind.equals(kind2)) return false;
        if (!fNRound.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FNRound;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "FNRound";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "recipe";
        }
        if (1 == n2) {
            return "argType";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public CompiledDPath recipe() {
        return this.recipe;
    }

    public NodeInfo.Kind argType() {
        return this.argType;
    }

    @Override
    public Object computeValue(Object value, DState dstate) {
        DataValue dataValue;
        NodeInfo.Kind kind = this.argType();
        NodeInfo$PrimType$Decimal$ nodeInfo$PrimType$Decimal$ = NodeInfo$.MODULE$.Decimal();
        NodeInfo.Kind kind2 = kind;
        if (!(nodeInfo$PrimType$Decimal$ != null ? !nodeInfo$PrimType$Decimal$.equals(kind2) : kind2 != null)) {
            BigDecimal bd = Numbers$.MODULE$.asBigDecimal(DataValue$.MODULE$.getAnyRef$extension(value));
            MathContext mc = MathContext.UNLIMITED;
            dataValue = new DataValue((Double)((Object)DataValue$.MODULE$.toDataValue(bd.setScale(0, RoundingMode.HALF_UP))));
        } else {
            NodeInfo$PrimType$Float$ nodeInfo$PrimType$Float$ = NodeInfo$.MODULE$.Float();
            NodeInfo.Kind kind3 = kind;
            if (!(nodeInfo$PrimType$Float$ != null ? !nodeInfo$PrimType$Float$.equals(kind3) : kind3 != null)) {
                float f = Numbers$.MODULE$.asFloat(DataValue$.MODULE$.getAnyRef$extension(value)).floatValue();
                if (RichFloat$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.floatWrapper(f)) || RichFloat$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.floatWrapper(f))) {
                    dataValue = new DataValue(DataValue$.MODULE$.toDataValue(f));
                } else {
                    if (Predef$.MODULE$.float2Float(f).isNaN()) {
                        throw new NumberFormatException("fn:round received NaN");
                    }
                    dataValue = new DataValue(DataValue$.MODULE$.toDataValue((float)RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper(f))));
                }
            } else {
                NodeInfo$PrimType$Double$ nodeInfo$PrimType$Double$ = NodeInfo$.MODULE$.Double();
                NodeInfo.Kind kind4 = kind;
                if (!(nodeInfo$PrimType$Double$ != null ? !nodeInfo$PrimType$Double$.equals(kind4) : kind4 != null)) {
                    double d = Numbers$.MODULE$.asDouble(DataValue$.MODULE$.getAnyRef$extension(value));
                    if (RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(d)) || RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(d))) {
                        dataValue = new DataValue(DataValue$.MODULE$.toDataValue(d));
                    } else {
                        if (Predef$.MODULE$.double2Double(d).isNaN()) {
                            throw new NumberFormatException("fn:round received NaN");
                        }
                        dataValue = new DataValue(DataValue$.MODULE$.toDataValue((double)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(d))));
                    }
                } else if (kind instanceof NodeInfo.NumericKind) {
                    dataValue = new DataValue((Double)value);
                } else {
                    throw Assert$.MODULE$.invariantFailed(String.format("Type %s is not a valid type for function round.", this.argType()));
                }
            }
        }
        DataValue dataValue2 = dataValue;
        Object res = dataValue2 == null ? null : dataValue2.v();
        return res;
    }

    public FNRound copy(CompiledDPath recipe, NodeInfo.Kind argType) {
        return new FNRound(recipe, argType);
    }

    public CompiledDPath copy$default$1() {
        return this.recipe();
    }

    public NodeInfo.Kind copy$default$2() {
        return this.argType();
    }

    public CompiledDPath _1() {
        return this.recipe();
    }

    public NodeInfo.Kind _2() {
        return this.argType();
    }
}

