/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import com.ibm.icu.text.DecimalFormat;
import java.text.ParsePosition;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextZonedSignStyle;
import org.apache.daffodil.lib.util.DecimalUtils$;
import org.apache.daffodil.runtime1.dpath.InvalidPrimitiveDataException;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.PrimProcessor;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.TextNumberFormatEv;
import org.apache.daffodil.runtime1.processors.ToBriefXMLImpl;
import org.apache.daffodil.runtime1.processors.parsers.ConvertZonedNumberParser$;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import org.apache.daffodil.runtime1.processors.parsers.TextDecimalVirtualPointMixin;
import org.apache.daffodil.runtime1.processors.parsers.TextPrimParser;
import scala.Enumeration;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class ConvertZonedNumberParser
implements ToBriefXMLImpl,
Processor,
PrimProcessor,
Parser,
TextPrimParser,
TextDecimalVirtualPointMixin,
Product {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(ConvertZonedNumberParser.class.getDeclaredField("virtualPointScaleFactor$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ConvertZonedNumberParser.class.getDeclaredField("parserName$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ConvertZonedNumberParser.class.getDeclaredField("org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1"));
    private volatile Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
    private boolean isInitialized;
    private volatile Object parserName$lzy1;
    private volatile Object virtualPointScaleFactor$lzy1;
    private final Enumeration.Value opl;
    private final TextNumberFormatEv textNumberFormatEv;
    private final Option optZonedSignStyle;
    private final ElementRuntimeData context;
    private final int textDecimalVirtualPoint;
    private final NodeInfo.PrimType.PrimNumeric primNumeric;

    public static ConvertZonedNumberParser apply(Enumeration.Value value, TextNumberFormatEv textNumberFormatEv, Option<TextZonedSignStyle> option, ElementRuntimeData elementRuntimeData, int n) {
        return ConvertZonedNumberParser$.MODULE$.apply(value, textNumberFormatEv, option, elementRuntimeData, n);
    }

    public static ConvertZonedNumberParser fromProduct(Product product) {
        return ConvertZonedNumberParser$.MODULE$.fromProduct(product);
    }

    public static ConvertZonedNumberParser unapply(ConvertZonedNumberParser convertZonedNumberParser) {
        return ConvertZonedNumberParser$.MODULE$.unapply(convertZonedNumberParser);
    }

    public ConvertZonedNumberParser(Enumeration.Value opl, TextNumberFormatEv textNumberFormatEv, Option<TextZonedSignStyle> optZonedSignStyle, ElementRuntimeData context, int textDecimalVirtualPoint) {
        this.opl = opl;
        this.textNumberFormatEv = textNumberFormatEv;
        this.optZonedSignStyle = optZonedSignStyle;
        this.context = context;
        this.textDecimalVirtualPoint = textDecimalVirtualPoint;
        ToBriefXMLImpl.$init$(this);
        Processor.$init$(this);
        Parser.$init$(this);
        TextDecimalVirtualPointMixin.$init$(this);
        this.primNumeric = (NodeInfo.PrimType.PrimNumeric)context.optPrimType().get();
    }

    @Override
    public String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_() {
        Object object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1();
    }

    private Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ToBriefXMLImpl.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    @Override
    public String parserName() {
        Object object = this.parserName$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.parserName$lzyINIT1();
    }

    private Object parserName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.parserName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = Parser.parserName$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.parserName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public final double virtualPointScaleFactor() {
        Object object = this.virtualPointScaleFactor$lzy1;
        if (object instanceof Double) {
            return BoxesRunTime.unboxToDouble((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToDouble(null);
        }
        return BoxesRunTime.unboxToDouble((Object)this.virtualPointScaleFactor$lzyINIT1());
    }

    private Object virtualPointScaleFactor$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.virtualPointScaleFactor$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Double d = null;
                    try {
                        d = BoxesRunTime.boxToDouble((double)TextDecimalVirtualPointMixin.virtualPointScaleFactor$(this));
                        object2 = d == null ? LazyVals.NullValue$.MODULE$ : d;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.virtualPointScaleFactor$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return d;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)388873677);
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.opl()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.textNumberFormatEv()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.optZonedSignStyle()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.context()));
        n = Statics.mix((int)n, (int)this.textDecimalVirtualPoint());
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ConvertZonedNumberParser)) return false;
        ConvertZonedNumberParser convertZonedNumberParser = (ConvertZonedNumberParser)object;
        if (this.textDecimalVirtualPoint() != convertZonedNumberParser.textDecimalVirtualPoint()) return false;
        Enumeration.Value value = this.opl();
        Enumeration.Value value2 = convertZonedNumberParser.opl();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        TextNumberFormatEv textNumberFormatEv = this.textNumberFormatEv();
        TextNumberFormatEv textNumberFormatEv2 = convertZonedNumberParser.textNumberFormatEv();
        if (textNumberFormatEv == null) {
            if (textNumberFormatEv2 != null) {
                return false;
            }
        } else if (!textNumberFormatEv.equals(textNumberFormatEv2)) return false;
        Option<TextZonedSignStyle> option = this.optZonedSignStyle();
        Option<TextZonedSignStyle> option2 = convertZonedNumberParser.optZonedSignStyle();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        ElementRuntimeData elementRuntimeData = this.context();
        ElementRuntimeData elementRuntimeData2 = convertZonedNumberParser.context();
        if (elementRuntimeData == null) {
            if (elementRuntimeData2 != null) {
                return false;
            }
        } else if (!((Object)elementRuntimeData).equals(elementRuntimeData2)) return false;
        if (!convertZonedNumberParser.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof ConvertZonedNumberParser;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "ConvertZonedNumberParser";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return BoxesRunTime.boxToInteger((int)this._5());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "opl";
            }
            case 1: {
                return "textNumberFormatEv";
            }
            case 2: {
                return "optZonedSignStyle";
            }
            case 3: {
                return "context";
            }
            case 4: {
                return "textDecimalVirtualPoint";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Enumeration.Value opl() {
        return this.opl;
    }

    public TextNumberFormatEv textNumberFormatEv() {
        return this.textNumberFormatEv;
    }

    public Option<TextZonedSignStyle> optZonedSignStyle() {
        return this.optZonedSignStyle;
    }

    @Override
    public ElementRuntimeData context() {
        return this.context;
    }

    @Override
    public int textDecimalVirtualPoint() {
        return this.textDecimalVirtualPoint;
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TextNumberFormatEv[]{this.textNumberFormatEv()}));
    }

    @Override
    public void parse(PState start) {
        Number numValue;
        Number number;
        Number num1;
        String string;
        DISimple node = start.simpleElement();
        String str = node.dataValueAsString();
        if (str == null) {
            throw Assert$.MODULE$.abort("Invariant broken: str.!=(null)");
        }
        String string2 = str;
        String string3 = "";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.PE(start, "Unable to parse zoned %s from empty string", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((NodeInfo.Kind)this.context().optPrimType().get()).globalQName()}));
            return;
        }
        int checkLength = str.length();
        DecimalFormat df = (DecimalFormat)this.textNumberFormatEv().evaluate(start);
        ParsePosition pos = new ParsePosition(0);
        try {
            string = DecimalUtils$.MODULE$.zonedToNumber(str, this.optZonedSignStyle(), this.opl());
        }
        catch (NumberFormatException e) {
            this.PE(start, "Unable to parse zoned %s from text: %s. %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((NodeInfo.Kind)this.context().optPrimType().get()).globalQName(), str, e.getMessage()}));
            return;
        }
        String decodedNum = string;
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(decodedNum), 0) == '-') {
            ++checkLength;
        }
        if ((num1 = df.parse(decodedNum, pos)) == null || pos.getIndex() != checkLength) {
            this.PE(start, "Unable to parse zoned %s from text: %s.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((NodeInfo.Kind)this.context().optPrimType().get()).globalQName(), str}));
            return;
        }
        Number num2 = this.applyTextDecimalVirtualPointForParse(num1);
        try {
            number = this.primNumeric.fromNumber(num2);
        }
        catch (InvalidPrimitiveDataException e) {
            this.PE(start, "%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()}));
            return;
        }
        Number numValue2 = numValue = number;
        node.overwriteDataValue(numValue2);
    }

    public ConvertZonedNumberParser copy(Enumeration.Value opl, TextNumberFormatEv textNumberFormatEv, Option<TextZonedSignStyle> optZonedSignStyle, ElementRuntimeData context, int textDecimalVirtualPoint) {
        return new ConvertZonedNumberParser(opl, textNumberFormatEv, optZonedSignStyle, context, textDecimalVirtualPoint);
    }

    public Enumeration.Value copy$default$1() {
        return this.opl();
    }

    public TextNumberFormatEv copy$default$2() {
        return this.textNumberFormatEv();
    }

    public Option<TextZonedSignStyle> copy$default$3() {
        return this.optZonedSignStyle();
    }

    public ElementRuntimeData copy$default$4() {
        return this.context();
    }

    public int copy$default$5() {
        return this.textDecimalVirtualPoint();
    }

    public Enumeration.Value _1() {
        return this.opl();
    }

    public TextNumberFormatEv _2() {
        return this.textNumberFormatEv();
    }

    public Option<TextZonedSignStyle> _3() {
        return this.optZonedSignStyle();
    }

    public ElementRuntimeData _4() {
        return this.context();
    }

    public int _5() {
        return this.textDecimalVirtualPoint();
    }
}

