/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.ConfigSerde;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.jackson.JacksonUtils;

public class JacksonConfigManager {
    private final ConfigManager configManager;
    private final ObjectMapper jsonMapper;
    private final AuditManager auditManager;

    @Inject
    public JacksonConfigManager(ConfigManager configManager, @Json ObjectMapper jsonMapper, AuditManager auditManager) {
        this.configManager = configManager;
        this.jsonMapper = jsonMapper;
        this.auditManager = auditManager;
    }

    public <T> AtomicReference<T> watch(String key, Class<? extends T> clazz) {
        return this.watch(key, clazz, null);
    }

    public <T> AtomicReference<T> watch(String key, Class<? extends T> clazz, T defaultVal) {
        return this.configManager.watchConfig(key, this.create(clazz, defaultVal));
    }

    public <T> AtomicReference<T> watch(String key, TypeReference<T> clazz, T defaultVal) {
        return this.configManager.watchConfig(key, this.create(clazz, defaultVal));
    }

    public <T> T convertByteToConfig(byte[] configInByte, Class<? extends T> clazz, T defaultVal) {
        if (configInByte == null) {
            return defaultVal;
        }
        ConfigSerde<T> serde = this.create(clazz, defaultVal);
        return serde.deserialize(configInByte);
    }

    public <T> ConfigManager.SetResult set(String key, T val, AuditInfo auditInfo) {
        return this.set(key, null, val, auditInfo);
    }

    public <T> ConfigManager.SetResult set(String key, @Nullable byte[] oldValue, T newValue, AuditInfo auditInfo) {
        ConfigSerde<Object> configSerde = this.create(newValue.getClass(), null);
        this.auditManager.doAudit(AuditEntry.builder().key(key).type(key).auditInfo(auditInfo).payload(newValue).build());
        return this.configManager.set(key, configSerde, oldValue, newValue);
    }

    @VisibleForTesting
    <T> ConfigSerde<T> create(final Class<? extends T> clazz, final T defaultVal) {
        return new ConfigSerde<T>(){

            @Override
            public byte[] serialize(T obj) {
                try {
                    return JacksonConfigManager.this.jsonMapper.writeValueAsBytes(obj);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public T deserialize(byte[] bytes) {
                if (bytes == null) {
                    return defaultVal;
                }
                return JacksonUtils.readValue(JacksonConfigManager.this.jsonMapper, bytes, clazz);
            }
        };
    }

    @VisibleForTesting
    <T> ConfigSerde<T> create(final TypeReference<? extends T> clazz, final T defaultVal) {
        return new ConfigSerde<T>(){

            @Override
            public byte[] serialize(T obj) {
                try {
                    return JacksonConfigManager.this.jsonMapper.writeValueAsBytes(obj);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public T deserialize(byte[] bytes) {
                if (bytes == null) {
                    return defaultVal;
                }
                try {
                    return JacksonConfigManager.this.jsonMapper.readValue(bytes, clazz);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

