/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.exception;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.druid.common.exception.ErrorResponseTransformStrategy;

public class AllowedRegexErrorResponseTransformStrategy
implements ErrorResponseTransformStrategy {
    @JsonProperty
    private final List<String> allowedRegexString;
    private final List<Pattern> allowedRegexPattern;

    @JsonCreator
    public AllowedRegexErrorResponseTransformStrategy(@JsonProperty(value="allowedRegex") List<String> allowedRegexString) {
        this.allowedRegexString = allowedRegexString;
        this.allowedRegexPattern = allowedRegexString == null ? ImmutableList.of() : allowedRegexString.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    @Override
    public Function<String, String> getErrorMessageTransformFunction() {
        return errorMessage -> {
            if (errorMessage == null || this.allowedRegexPattern.stream().anyMatch(pattern -> pattern.matcher((CharSequence)errorMessage).matches())) {
                return errorMessage;
            }
            return null;
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllowedRegexErrorResponseTransformStrategy that = (AllowedRegexErrorResponseTransformStrategy)o;
        return Objects.equals(this.allowedRegexString, that.allowedRegexString);
    }

    public int hashCode() {
        return Objects.hash(this.allowedRegexString);
    }
}

