/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.segment.RestrictedSegment;
import org.apache.druid.segment.SegmentReference;

public class RestrictedDataSource
implements DataSource {
    private final TableDataSource base;
    private final Policy policy;

    @JsonProperty(value="base")
    public TableDataSource getBase() {
        return this.base;
    }

    @JsonProperty(value="policy")
    public Policy getPolicy() {
        return this.policy;
    }

    RestrictedDataSource(TableDataSource base, Policy policy) {
        this.base = base;
        this.policy = policy;
    }

    @JsonCreator
    public static RestrictedDataSource create(@JsonProperty(value="base") DataSource base, @JsonProperty(value="policy") Policy policy) {
        if (!(base instanceof TableDataSource)) {
            throw new IAE("Expected a TableDataSource, got data source type [%s]", base.getClass());
        }
        if (Objects.isNull(policy)) {
            throw new IAE("Policy can't be null for RestrictedDataSource", new Object[0]);
        }
        return new RestrictedDataSource((TableDataSource)base, policy);
    }

    @Override
    public Set<String> getTableNames() {
        return this.base.getTableNames();
    }

    @Override
    public List<DataSource> getChildren() {
        return ImmutableList.of((Object)this.base);
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (children.size() != 1) {
            throw new IAE("Expected [1] child, got [%d]", children.size());
        }
        return RestrictedDataSource.create(children.get(0), this.policy);
    }

    @Override
    public boolean isCacheable(boolean isBroker) {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return this.base.isGlobal();
    }

    @Override
    public boolean isConcrete() {
        return this.base.isConcrete();
    }

    @Override
    public Function<SegmentReference, SegmentReference> createSegmentMapFunction(Query query) {
        Function<SegmentReference, SegmentReference> segmentMapFn = this.base.createSegmentMapFunction(query);
        return baseSegment -> new RestrictedSegment((SegmentReference)segmentMapFn.apply((SegmentReference)baseSegment), this.policy);
    }

    @Override
    public DataSource withUpdatedDataSource(DataSource newSource) {
        return RestrictedDataSource.create(newSource, this.policy);
    }

    @Override
    public DataSource withPolicies(Map<String, Optional<Policy>> policyMap) {
        if (!policyMap.containsKey(this.base.getName())) {
            throw new ISE("Missing policy check result for table [%s]", this.base.getName());
        }
        Optional newPolicy = policyMap.getOrDefault(this.base.getName(), Optional.empty());
        if (!newPolicy.isPresent()) {
            throw new ISE("No restriction found on table [%s], but had policy [%s] before.", this.base.getName(), this.policy);
        }
        if (!(newPolicy.get() instanceof NoRestrictionPolicy) && !((Policy)newPolicy.get()).equals(this.policy)) {
            throw new ISE("Different restrictions on table [%s]: previous policy [%s] and new policy [%s]", this.base.getName(), this.policy, newPolicy.get());
        }
        return this;
    }

    public String toString() {
        return "RestrictedDataSource{base=" + String.valueOf(this.base) + ", policy=" + String.valueOf(this.policy) + "}";
    }

    @Override
    public byte[] getCacheKey() {
        return new byte[0];
    }

    @Override
    public DataSourceAnalysis getAnalysis() {
        return this.base.getAnalysis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedDataSource that = (RestrictedDataSource)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.policy, that.policy);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.policy);
    }
}

