/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.nested.NestedPathArrayElement;
import org.apache.druid.segment.nested.NestedPathField;
import org.apache.druid.segment.nested.NestedPathPart;

public class NestedPathFinder {
    public static final String JSON_PATH_ROOT = "$";
    public static final String JQ_PATH_ROOT = ".";

    @Nullable
    public static Object find(@Nullable Object data, List<NestedPathPart> path) {
        Object currentObject = data;
        for (NestedPathPart pathPart : path) {
            Object objectAtPath = pathPart.find(currentObject);
            if (objectAtPath == null) {
                return null;
            }
            currentObject = objectAtPath;
        }
        return currentObject;
    }

    @Nullable
    public static Object[] findKeys(@Nullable Object data, List<NestedPathPart> path) {
        Object currentObject = NestedPathFinder.find(data, path);
        if (currentObject instanceof Map) {
            return ((Map)currentObject).keySet().toArray();
        }
        if (currentObject instanceof List) {
            return IntStream.range(0, ((List)currentObject).size()).mapToObj(Integer::toString).toArray();
        }
        if (currentObject instanceof Object[]) {
            return IntStream.range(0, ((Object[])currentObject).length).mapToObj(Integer::toString).toArray();
        }
        return null;
    }

    public static String toNormalizedJsonPath(List<NestedPathPart> paths) {
        if (paths.isEmpty()) {
            return JSON_PATH_ROOT;
        }
        StringBuilder bob = new StringBuilder();
        boolean first = true;
        for (NestedPathPart partFinder : paths) {
            if (partFinder instanceof NestedPathField) {
                String id;
                if (first) {
                    bob.append(JSON_PATH_ROOT);
                }
                if ((id = partFinder.getPartIdentifier()).contains(JQ_PATH_ROOT) || id.contains("'") || id.contains("\"") || id.contains("[") || id.contains("]")) {
                    bob.append("['").append(id).append("']");
                } else {
                    bob.append(JQ_PATH_ROOT);
                    bob.append(id);
                }
            } else if (partFinder instanceof NestedPathArrayElement) {
                if (first) {
                    bob.append(JSON_PATH_ROOT);
                }
                bob.append("[").append(partFinder.getPartIdentifier()).append("]");
            }
            first = false;
        }
        return bob.toString();
    }

    public static List<NestedPathPart> parseJsonPath(@Nullable String path) {
        if (path == null || path.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NestedPathPart> parts = new ArrayList<NestedPathPart>();
        if (!path.startsWith(JSON_PATH_ROOT)) {
            NestedPathFinder.badFormatJsonPath(path, "it must start with '$'", new Object[0]);
        }
        if (path.length() == 1) {
            return Collections.emptyList();
        }
        int partMark = -1;
        int dotMark = -1;
        int arrayMark = -1;
        int quoteMark = -1;
        for (int i = 1; i < path.length(); ++i) {
            char current = path.charAt(i);
            if (current == '.' && arrayMark < 0 && quoteMark < 0) {
                if (dotMark >= 0) {
                    parts.add(new NestedPathField(NestedPathFinder.getPathSubstring(path, partMark, i)));
                }
                dotMark = i;
                partMark = i + 1;
                continue;
            }
            if (current == '[' && arrayMark < 0 && quoteMark < 0) {
                if (dotMark == i - 1 && dotMark != 0) {
                    NestedPathFinder.badFormatJsonPath(path, "found '[' at invalid position [%s], must not follow '.' or must be contained with '", i);
                }
                if (dotMark >= 0 && i > 1) {
                    parts.add(new NestedPathField(NestedPathFinder.getPathSubstring(path, partMark, i)));
                    dotMark = -1;
                }
                arrayMark = i;
                partMark = i + 1;
                continue;
            }
            if (current == ']' && arrayMark >= 0 && quoteMark < 0) {
                String maybeNumber = NestedPathFinder.getPathSubstring(path, partMark, i);
                try {
                    int index = Integer.parseInt(maybeNumber);
                    parts.add(new NestedPathArrayElement(index));
                    dotMark = -1;
                    arrayMark = -1;
                    partMark = i + 1;
                }
                catch (NumberFormatException ignored) {
                    NestedPathFinder.badFormatJsonPath(path, "array specifier [%s] should be a number, it was not.  Use ' if this value was meant to be a field name", maybeNumber);
                }
                continue;
            }
            if (dotMark == -1 && arrayMark == -1) {
                NestedPathFinder.badFormatJsonPath(path, "path parts must be separated with '.'", new Object[0]);
                continue;
            }
            if (current == '\'' && quoteMark < 0) {
                if (arrayMark != i - 1) {
                    NestedPathFinder.badFormatJsonPath(path, "single-quote (') must be immediately after '['", new Object[0]);
                }
                quoteMark = i;
                partMark = i + 1;
                continue;
            }
            if (current != '\'' || quoteMark < 0 || path.charAt(i - 1) == '\\') continue;
            if (path.charAt(i + 1) != ']') {
                if (arrayMark >= 0) continue;
                NestedPathFinder.badFormatJsonPath(path, "closing single-quote (') must immediately precede ']'", new Object[0]);
            }
            parts.add(new NestedPathField(NestedPathFinder.getPathSubstring(path, partMark, i)));
            dotMark = -1;
            quoteMark = -1;
            if (++i == path.length()) break;
            partMark = i + 1;
            arrayMark = -1;
        }
        if (partMark < path.length()) {
            if (quoteMark != -1) {
                NestedPathFinder.badFormatJsonPath(path, "unterminated single-quote (')", new Object[0]);
            }
            if (arrayMark != -1) {
                NestedPathFinder.badFormatJsonPath(path, "unterminated '['", new Object[0]);
            }
            parts.add(new NestedPathField(path.substring(partMark)));
        }
        return parts;
    }

    public static String toNormalizedJqPath(List<NestedPathPart> paths) {
        if (paths.isEmpty()) {
            return JQ_PATH_ROOT;
        }
        StringBuilder bob = new StringBuilder();
        boolean first = true;
        for (NestedPathPart partFinder : paths) {
            if (partFinder instanceof NestedPathField) {
                bob.append(JQ_PATH_ROOT);
                bob.append("\"").append(partFinder.getPartIdentifier()).append("\"");
            } else {
                if (first) {
                    bob.append(JQ_PATH_ROOT);
                }
                bob.append("[").append(partFinder.getPartIdentifier()).append("]");
            }
            first = false;
        }
        return bob.toString();
    }

    public static List<NestedPathPart> parseJqPath(@Nullable String path) {
        if (path == null || path.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NestedPathPart> parts = new ArrayList<NestedPathPart>();
        if (path.charAt(0) != '.') {
            NestedPathFinder.badFormat(path, "it must start with '.'", new Object[0]);
        }
        int partMark = -1;
        int dotMark = -1;
        int arrayMark = -1;
        int quoteMark = -1;
        for (int i = 0; i < path.length(); ++i) {
            char current = path.charAt(i);
            if (current == '.' && arrayMark < 0 && quoteMark < 0) {
                if (dotMark >= 0) {
                    parts.add(new NestedPathField(NestedPathFinder.getPathSubstring(path, partMark, i)));
                }
                dotMark = i;
                partMark = i + 1;
                continue;
            }
            if (current == '?' && quoteMark < 0) {
                if (partMark != i) {
                    if (dotMark >= 0) {
                        parts.add(new NestedPathField(NestedPathFinder.getPathSubstring(path, partMark, i)));
                        dotMark = -1;
                    } else {
                        NestedPathFinder.badFormat(path, "found '?' at invalid position [%s]", i);
                    }
                }
                partMark = i + 1;
                continue;
            }
            if (current == '[' && arrayMark < 0 && quoteMark < 0) {
                if (dotMark == i - 1 && dotMark != 0) {
                    NestedPathFinder.badFormat(path, "found '[' at invalid position [%s], must not follow '.' or must be contained with '\"'", i);
                }
                if (dotMark >= 0 && i > 1) {
                    parts.add(new NestedPathField(NestedPathFinder.getPathSubstring(path, partMark, i)));
                    dotMark = -1;
                }
                arrayMark = i;
                partMark = i + 1;
                continue;
            }
            if (current == ']' && arrayMark >= 0 && quoteMark < 0) {
                String maybeNumber = NestedPathFinder.getPathSubstring(path, partMark, i);
                try {
                    int index = Integer.parseInt(maybeNumber);
                    parts.add(new NestedPathArrayElement(index));
                    dotMark = -1;
                    arrayMark = -1;
                    partMark = i + 1;
                }
                catch (NumberFormatException ignored) {
                    NestedPathFinder.badFormat(path, "array specifier [%s] should be a number, it was not.  Use \"\" if this value was meant to be a field name", maybeNumber);
                }
                continue;
            }
            if (dotMark == -1 && arrayMark == -1) {
                NestedPathFinder.badFormat(path, "path parts must be separated with '.'", new Object[0]);
                continue;
            }
            if (current == '\"' && quoteMark < 0) {
                if (partMark != i) {
                    NestedPathFinder.badFormat(path, "found '\"' at invalid position [%s], it must immediately follow '.' or '['", i);
                }
                if (arrayMark > 0 && arrayMark != i - 1) {
                    NestedPathFinder.badFormat(path, "'\"' within '[', must be immediately after", new Object[0]);
                }
                quoteMark = i;
                partMark = i + 1;
                continue;
            }
            if (current != '\"' || quoteMark < 0 || path.charAt(i - 1) == '\\') continue;
            parts.add(new NestedPathField(NestedPathFinder.getPathSubstring(path, partMark, i)));
            dotMark = -1;
            quoteMark = -1;
            if (arrayMark > 0) {
                if (++i == path.length()) break;
                if (path.charAt(i) != ']') {
                    NestedPathFinder.badFormat(path, "closing '\"' must immediately precede ']'", new Object[0]);
                }
                partMark = i + 1;
                arrayMark = -1;
                continue;
            }
            partMark = i + 1;
        }
        if (partMark < path.length()) {
            if (quoteMark != -1) {
                NestedPathFinder.badFormat(path, "unterminated '\"'", new Object[0]);
            }
            if (arrayMark != -1) {
                NestedPathFinder.badFormat(path, "unterminated '['", new Object[0]);
            }
            parts.add(new NestedPathField(path.substring(partMark)));
        }
        return parts;
    }

    private static String getPathSubstring(String path, int start, int end) {
        if (end - start < 1) {
            NestedPathFinder.badFormat(path, "path parts separated by '.' must not be empty", new Object[0]);
        }
        return path.substring(start, end);
    }

    private static void badFormat(String path, String message, Object ... args) {
        throw InvalidInput.exception("jq path [%s] is invalid, %s", path, StringUtils.format(message, args));
    }

    private static void badFormatJsonPath(String path, String message, Object ... args) {
        throw InvalidInput.exception("JSONPath [%s] is invalid, %s", path, StringUtils.format(message, args));
    }
}

