/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.logger.Logger;

public class TaskStorageDirTracker {
    private static final Logger log = new Logger(TaskStorageDirTracker.class);
    private final File[] baseTaskDirs;
    private final StorageSlot[] slots;
    private final AtomicInteger iterationCounter = new AtomicInteger(Integer.MIN_VALUE);

    public static TaskStorageDirTracker fromConfigs(WorkerConfig workerConfig, TaskConfig taskConfig) {
        List basePaths = workerConfig.getBaseTaskDirs();
        Object baseTaskDirs = basePaths == null ? ImmutableList.of((Object)taskConfig.getBaseTaskDir()) : basePaths.stream().map(File::new).collect(Collectors.toList());
        return TaskStorageDirTracker.fromBaseDirs((List<File>)baseTaskDirs, workerConfig.getCapacity(), workerConfig.getBaseTaskDirSize());
    }

    public static TaskStorageDirTracker fromBaseDirs(List<File> baseTaskDirs, int numSlots, long dirSize) {
        int slotsPerBaseTaskDir = numSlots / baseTaskDirs.size();
        if (slotsPerBaseTaskDir == 0) {
            slotsPerBaseTaskDir = 1;
        } else if (numSlots % baseTaskDirs.size() > 0) {
            ++slotsPerBaseTaskDir;
        }
        long sizePerSlot = dirSize / (long)slotsPerBaseTaskDir;
        File[] slotDirs = new File[numSlots];
        for (int i = 0; i < numSlots; ++i) {
            int whichDir = i % baseTaskDirs.size();
            int dirUsageCount = i / baseTaskDirs.size();
            slotDirs[i] = new File(baseTaskDirs.get(whichDir), StringUtils.format((String)"slot%d", (Object[])new Object[]{dirUsageCount}));
        }
        return new TaskStorageDirTracker(baseTaskDirs, slotDirs, sizePerSlot);
    }

    private TaskStorageDirTracker(List<File> baseTaskDirs, File[] slotDirs, long sizePerSlot) {
        this.baseTaskDirs = baseTaskDirs.toArray(new File[0]);
        this.slots = new StorageSlot[slotDirs.length];
        for (int i = 0; i < slotDirs.length; ++i) {
            this.slots[i] = new StorageSlot(slotDirs[i], sizePerSlot);
        }
    }

    @LifecycleStart
    public void ensureDirectories() {
        for (StorageSlot slot : this.slots) {
            if (slot.getDirectory().exists()) continue;
            try {
                FileUtils.mkdirp((File)slot.getDirectory());
            }
            catch (IOException e) {
                throw new ISE((Throwable)e, "directory for slot [%s] likely does not exist, please ensure it exists and the user has permissions.", new Object[]{slot});
            }
        }
    }

    public synchronized StorageSlot pickStorageSlot(String taskId) {
        for (StorageSlot slot : this.slots) {
            if (slot.runningTaskId == null || !slot.runningTaskId.equals(taskId)) continue;
            return slot;
        }
        for (int i = 0; i < this.slots.length; ++i) {
            int currIncrement = Math.abs(this.iterationCounter.getAndIncrement() % this.slots.length);
            StorageSlot candidateSlot = this.slots[currIncrement % this.slots.length];
            if (candidateSlot.runningTaskId != null) continue;
            candidateSlot.runningTaskId = taskId;
            return candidateSlot;
        }
        throw new ISE("Unable to pick a free slot, this should never happen, slot status [%s].", new Object[]{Arrays.toString(this.slots)});
    }

    public synchronized void returnStorageSlot(StorageSlot slot) {
        if (slot.getParentRef() != this) {
            throw new IAE("Cannot return storage slot for task [%s] that I don't own.", new Object[]{slot.runningTaskId});
        }
        slot.runningTaskId = null;
    }

    public synchronized Map<String, StorageSlot> findExistingTaskDirs(List<String> taskIds) {
        TreeMap<String, StorageSlot> retVal = new TreeMap<String, StorageSlot>();
        ArrayList<String> missingIds = new ArrayList<String>();
        for (String taskId : taskIds) {
            StorageSlot candidateSlot = Arrays.stream(this.slots).filter(slot -> slot.runningTaskId == null).filter(slot -> new File(slot.getDirectory(), taskId).exists()).findFirst().orElse(null);
            if (candidateSlot == null) {
                missingIds.add(taskId);
                continue;
            }
            candidateSlot.runningTaskId = taskId;
            retVal.put(taskId, candidateSlot);
        }
        for (String missingId : missingIds) {
            File definitelyExists = null;
            for (File baseTaskDir : this.baseTaskDirs) {
                File maybeExists = new File(baseTaskDir, missingId);
                if (!maybeExists.exists()) continue;
                definitelyExists = maybeExists;
                break;
            }
            if (definitelyExists == null) {
                retVal.put(missingId, null);
                continue;
            }
            StorageSlot pickedSlot = this.pickStorageSlot(missingId);
            File pickedLocation = new File(pickedSlot.getDirectory(), missingId);
            if (definitelyExists.renameTo(pickedLocation)) {
                retVal.put(missingId, pickedSlot);
                continue;
            }
            log.warn("Unable to relocate task ([%s] -> [%s]), pretend it didn't exist", new Object[]{definitelyExists, pickedLocation});
            retVal.put(missingId, null);
            this.returnStorageSlot(pickedSlot);
        }
        return retVal;
    }

    public class StorageSlot {
        private final File directory;
        private final long numBytes;
        private volatile String runningTaskId = null;

        private StorageSlot(File baseDirectory, long numBytes) {
            this.directory = baseDirectory;
            this.numBytes = numBytes;
        }

        public File getDirectory() {
            return this.directory;
        }

        public long getNumBytes() {
            return this.numBytes;
        }

        public TaskStorageDirTracker getParentRef() {
            return TaskStorageDirTracker.this;
        }

        public String toString() {
            return "StorageSlot{directory=" + String.valueOf(this.directory) + ", numBytes=" + this.numBytes + ", runningTaskId='" + this.runningTaskId + "'}";
        }
    }
}

