/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.TaskLocks;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.CriticalAction;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.timeline.DataSegment;

public class SegmentTransactionalReplaceAction
implements TaskAction<SegmentPublishResult> {
    private static final Logger log = new Logger(SegmentTransactionalReplaceAction.class);
    private final Set<DataSegment> segments;
    @Nullable
    private final SegmentSchemaMapping segmentSchemaMapping;

    public static SegmentTransactionalReplaceAction create(Set<DataSegment> segmentsToPublish, SegmentSchemaMapping segmentSchemaMapping) {
        return new SegmentTransactionalReplaceAction(segmentsToPublish, segmentSchemaMapping);
    }

    @JsonCreator
    private SegmentTransactionalReplaceAction(@JsonProperty(value="segments") Set<DataSegment> segments, @JsonProperty(value="segmentSchemaMapping") @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        this.segments = ImmutableSet.copyOf(segments);
        this.segmentSchemaMapping = segmentSchemaMapping;
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    @Nullable
    public SegmentSchemaMapping getSegmentSchemaMapping() {
        return this.segmentSchemaMapping;
    }

    @Override
    public TypeReference<SegmentPublishResult> getReturnTypeReference() {
        return new TypeReference<SegmentPublishResult>(){};
    }

    @Override
    public SegmentPublishResult perform(Task task, TaskActionToolbox toolbox) {
        SegmentPublishResult publishResult;
        TaskLocks.checkLockCoversSegments(task, toolbox.getTaskLockbox(), this.segments);
        Set<ReplaceTaskLock> replaceLocksForTask = toolbox.getTaskLockbox().findReplaceLocksForTask(task);
        try {
            publishResult = toolbox.getTaskLockbox().doInCriticalSection(task, this.segments.stream().map(DataSegment::getInterval).collect(Collectors.toSet()), CriticalAction.builder().onValidLocks(() -> toolbox.getIndexerMetadataStorageCoordinator().commitReplaceSegments(this.segments, replaceLocksForTask, this.segmentSchemaMapping)).onInvalidLocks(() -> SegmentPublishResult.fail((String)"Invalid task locks. Maybe they are revoked by a higher priority task. Please check the overlord log for details.", (Object[])new Object[0])).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IndexTaskUtils.emitSegmentPublishMetrics(publishResult, task, toolbox);
        if (publishResult.isSuccess() && toolbox.getSupervisorManager() != null) {
            try {
                this.registerUpgradedPendingSegmentsOnSupervisor(task, toolbox, publishResult.getUpgradedPendingSegments());
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error while upgrading pending segments for task[%s]", new Object[]{task.getId()});
            }
        }
        return publishResult;
    }

    private void registerUpgradedPendingSegmentsOnSupervisor(Task task, TaskActionToolbox toolbox, List<PendingSegmentRecord> upgradedPendingSegments) {
        SupervisorManager supervisorManager = toolbox.getSupervisorManager();
        Optional<String> activeSupervisorIdWithAppendLock = supervisorManager.getActiveSupervisorIdForDatasourceWithAppendLock(task.getDataSource());
        if (!activeSupervisorIdWithAppendLock.isPresent()) {
            return;
        }
        upgradedPendingSegments.forEach(upgradedPendingSegment -> supervisorManager.registerUpgradedPendingSegmentOnSupervisor((String)activeSupervisorIdWithAppendLock.get(), (PendingSegmentRecord)upgradedPendingSegment));
    }

    @Override
    public String toString() {
        return "SegmentTransactionalReplaceAction{segments=" + String.valueOf(SegmentUtils.commaSeparatedIdentifiers(this.segments)) + "}";
    }
}

