/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.SegmentLock;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TimeChunkLock;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class TaskLocks {
    static void checkLockCoversSegments(Task task, TaskLockbox taskLockbox, Collection<DataSegment> segments) {
        if (!TaskLocks.isLockCoversSegments(task, taskLockbox, segments)) {
            throw new ISE("Segments[%s] are not covered by locks[%s] for task[%s]", new Object[]{segments, taskLockbox.findLocksForTask(task), task.getId()});
        }
    }

    @VisibleForTesting
    static boolean isLockCoversSegments(Task task, TaskLockbox taskLockbox, Collection<DataSegment> segments) {
        NavigableMap<DateTime, List<TaskLock>> taskLockMap = TaskLocks.getTaskLockMap(taskLockbox, task);
        if (taskLockMap.isEmpty()) {
            return false;
        }
        return TaskLocks.isLockCoversSegments(taskLockMap, segments);
    }

    public static String defaultLockVersion(TaskLockType lockType) {
        return lockType == TaskLockType.APPEND ? DateTimes.EPOCH.toString() : DateTimes.nowUtc().toString();
    }

    public static boolean isLockCoversSegments(NavigableMap<DateTime, List<TaskLock>> taskLockMap, Collection<DataSegment> segments) {
        return segments.stream().allMatch(segment -> {
            Map.Entry entry = taskLockMap.floorEntry(segment.getInterval().getStart());
            if (entry == null) {
                return false;
            }
            List locks = ((List)entry.getValue()).stream().filter(lock -> !lock.isRevoked()).collect(Collectors.toList());
            return locks.stream().anyMatch(lock -> {
                if (lock.getGranularity() == LockGranularity.TIME_CHUNK) {
                    TimeChunkLock timeChunkLock = (TimeChunkLock)lock;
                    return timeChunkLock.getInterval().contains((ReadableInterval)segment.getInterval()) && timeChunkLock.getDataSource().equals(segment.getDataSource()) && (timeChunkLock.getVersion().compareTo(segment.getVersion()) >= 0 || TaskLockType.APPEND.equals((Object)timeChunkLock.getType()));
                }
                SegmentLock segmentLock = (SegmentLock)lock;
                return segmentLock.getInterval().contains((ReadableInterval)segment.getInterval()) && segmentLock.getDataSource().equals(segment.getDataSource()) && segmentLock.getVersion().compareTo(segment.getVersion()) >= 0 && segmentLock.getPartitionId() == segment.getShardSpec().getPartitionNum();
            });
        });
    }

    public static TaskLockType determineLockTypeForAppend(Map<String, Object> taskContext) {
        boolean useConcurrentLocks = (Boolean)taskContext.getOrDefault("useConcurrentLocks", false);
        if (useConcurrentLocks) {
            return TaskLockType.APPEND;
        }
        Object lockType = taskContext.get("taskLockType");
        if (lockType == null) {
            boolean useSharedLock = (Boolean)taskContext.getOrDefault("useSharedLock", false);
            return useSharedLock ? TaskLockType.SHARED : TaskLockType.EXCLUSIVE;
        }
        return TaskLockType.valueOf(lockType.toString());
    }

    public static Map<DataSegment, ReplaceTaskLock> findReplaceLocksCoveringSegments(String datasource, TaskLockbox taskLockbox, Set<DataSegment> segments) {
        HashMap<Interval, List> intervalToSegments = new HashMap<Interval, List>();
        segments.forEach(segment -> intervalToSegments.computeIfAbsent(segment.getInterval(), interval -> new ArrayList()).add(segment));
        Set<ReplaceTaskLock> replaceLocks = taskLockbox.getAllReplaceLocksForDatasource(datasource);
        HashMap<DataSegment, ReplaceTaskLock> segmentToReplaceLock = new HashMap<DataSegment, ReplaceTaskLock>();
        intervalToSegments.forEach((interval, segmentsInInterval) -> {
            for (ReplaceTaskLock lock : replaceLocks) {
                if (!lock.getInterval().contains((ReadableInterval)interval)) continue;
                segmentsInInterval.forEach(s -> segmentToReplaceLock.put((DataSegment)s, lock));
                return;
            }
        });
        return segmentToReplaceLock;
    }

    public static List<TaskLock> findLocksForSegments(Task task, TaskLockbox taskLockbox, Collection<DataSegment> segments) {
        NavigableMap<DateTime, List<TaskLock>> taskLockMap = TaskLocks.getTaskLockMap(taskLockbox, task);
        if (taskLockMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TaskLock> found = new ArrayList<TaskLock>();
        segments.forEach(segment -> {
            Map.Entry entry = taskLockMap.floorEntry(segment.getInterval().getStart());
            if (entry == null) {
                throw new ISE("Can't find lock for the interval of segment[%s]", new Object[]{segment.getId()});
            }
            List locks = (List)entry.getValue();
            locks.forEach(lock -> {
                if (lock.getGranularity() == LockGranularity.TIME_CHUNK) {
                    TimeChunkLock timeChunkLock = (TimeChunkLock)lock;
                    if (timeChunkLock.getInterval().contains((ReadableInterval)segment.getInterval()) && timeChunkLock.getDataSource().equals(segment.getDataSource()) && timeChunkLock.getVersion().compareTo(segment.getVersion()) >= 0) {
                        found.add((TaskLock)lock);
                    }
                } else {
                    SegmentLock segmentLock = (SegmentLock)lock;
                    if (segmentLock.getInterval().contains((ReadableInterval)segment.getInterval()) && segmentLock.getDataSource().equals(segment.getDataSource()) && segmentLock.getVersion().compareTo(segment.getVersion()) >= 0 && segmentLock.getPartitionId() == segment.getShardSpec().getPartitionNum()) {
                        found.add((TaskLock)lock);
                    }
                }
            });
        });
        return found;
    }

    private static NavigableMap<DateTime, List<TaskLock>> getTaskLockMap(TaskLockbox taskLockbox, Task task) {
        List<TaskLock> taskLocks = taskLockbox.findLocksForTask(task);
        TreeMap<DateTime, List<TaskLock>> taskLockMap = new TreeMap<DateTime, List<TaskLock>>();
        taskLocks.forEach(taskLock -> taskLockMap.computeIfAbsent(taskLock.getInterval().getStart(), k -> new ArrayList()).add(taskLock));
        return taskLockMap;
    }
}

