/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.SegmentMetadataEvent;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CircularBuffer;
import org.joda.time.DateTime;

public class IndexTaskUtils {
    @Nullable
    public static List<ParseExceptionReport> getReportListFromSavedParseExceptions(CircularBuffer<ParseExceptionReport> savedParseExceptionReports) {
        if (savedParseExceptionReports == null) {
            return null;
        }
        ArrayList<ParseExceptionReport> reports = new ArrayList<ParseExceptionReport>();
        for (int i = 0; i < savedParseExceptionReports.size(); ++i) {
            reports.add((ParseExceptionReport)savedParseExceptionReports.getLatest(i));
        }
        return reports;
    }

    public static AuthorizationResult datasourceAuthorizationCheck(HttpServletRequest req, Action action, String datasource, AuthorizerMapper authorizerMapper) {
        ResourceAction resourceAction = new ResourceAction(new Resource(datasource, "DATASOURCE"), action);
        AuthorizationResult authResult = AuthorizationUtils.authorizeResourceAction((HttpServletRequest)req, (ResourceAction)resourceAction, (AuthorizerMapper)authorizerMapper);
        if (!authResult.allowAccessWithNoRestriction()) {
            throw new ForbiddenException(authResult.getErrorMessage());
        }
        return authResult;
    }

    public static void setTaskDimensions(ServiceMetricEvent.Builder metricBuilder, Task task) {
        metricBuilder.setDimension("taskId", (Object)task.getId());
        metricBuilder.setDimension("taskType", (Object)task.getType());
        metricBuilder.setDimension("dataSource", (Object)task.getDataSource());
        metricBuilder.setDimensionIfNotNull("tags", task.getContextValue("tags"));
        metricBuilder.setDimensionIfNotNull("groupId", (Object)task.getGroupId());
    }

    public static void setTaskDimensions(ServiceMetricEvent.Builder metricBuilder, AbstractTask task) {
        metricBuilder.setDimension("taskId", (Object)task.getId());
        metricBuilder.setDimension("taskType", (Object)task.getType());
        metricBuilder.setDimension("dataSource", (Object)task.getDataSource());
        metricBuilder.setDimension("taskIngestionMode", (Object)task.getIngestionMode());
        metricBuilder.setDimensionIfNotNull("tags", task.getContextValue("tags"));
        metricBuilder.setDimensionIfNotNull("groupId", (Object)task.getGroupId());
    }

    public static void setTaskStatusDimensions(ServiceMetricEvent.Builder metricBuilder, TaskStatus taskStatus) {
        metricBuilder.setDimension("taskId", (Object)taskStatus.getId());
        metricBuilder.setDimension("taskStatus", (Object)taskStatus.getStatusCode().toString());
    }

    public static void setSegmentDimensions(ServiceMetricEvent.Builder metricBuilder, DataSegment segment) {
        String partitionType = segment.getShardSpec() == null ? null : segment.getShardSpec().getType();
        metricBuilder.setDimension("partitioningType", (Object)partitionType);
        metricBuilder.setDimension("interval", (Object)segment.getInterval().toString());
    }

    public static void emitSegmentPublishMetrics(SegmentPublishResult publishResult, Task task, TaskActionToolbox toolbox) {
        ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder();
        IndexTaskUtils.setTaskDimensions(metricBuilder, task);
        if (publishResult.isSuccess()) {
            toolbox.getEmitter().emit((ServiceEventBuilder)metricBuilder.setMetric("segment/txn/success", (Number)1));
            for (DataSegment segment : publishResult.getSegments()) {
                IndexTaskUtils.setSegmentDimensions(metricBuilder, segment);
                toolbox.getEmitter().emit((ServiceEventBuilder)metricBuilder.setMetric("segment/added/bytes", (Number)segment.getSize()));
                toolbox.getEmitter().emit((Event)SegmentMetadataEvent.create((DataSegment)segment, (DateTime)DateTimes.nowUtc()));
            }
        } else {
            toolbox.getEmitter().emit((ServiceEventBuilder)metricBuilder.setMetric("segment/txn/failure", (Number)1));
        }
    }
}

