/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.http;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.rpc.indexing.SegmentUpdateResponse;
import org.apache.druid.server.http.SegmentsToUpdateFilter;
import org.apache.druid.server.http.ServletResourceUtils;
import org.apache.druid.server.http.security.DatasourceResourceFilter;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

@Path(value="/druid/indexer/v1/datasources")
public class OverlordDataSourcesResource {
    private static final Logger log = new Logger(OverlordDataSourcesResource.class);
    private final SegmentsMetadataManager segmentsMetadataManager;
    private final IndexerMetadataStorageCoordinator metadataStorageCoordinator;
    private final TaskMaster taskMaster;
    private final AuditManager auditManager;

    @Inject
    public OverlordDataSourcesResource(TaskMaster taskMaster, SegmentsMetadataManager segmentsMetadataManager, IndexerMetadataStorageCoordinator metadataStorageCoordinator, AuditManager auditManager) {
        this.taskMaster = taskMaster;
        this.auditManager = auditManager;
        this.segmentsMetadataManager = segmentsMetadataManager;
        this.metadataStorageCoordinator = metadataStorageCoordinator;
    }

    @POST
    @Path(value="/{dataSourceName}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markAllNonOvershadowedSegmentsAsUsed(@PathParam(value="dataSourceName") String dataSourceName, @Context HttpServletRequest req) {
        SegmentUpdateOperation operation = () -> this.segmentsMetadataManager.markAsUsedAllNonOvershadowedSegmentsInDataSource(dataSourceName);
        return this.performSegmentUpdate(dataSourceName, operation);
    }

    @DELETE
    @Path(value="/{dataSourceName}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    public Response markAllSegmentsAsUnused(@PathParam(value="dataSourceName") String dataSourceName, @Context HttpServletRequest req) {
        SegmentUpdateOperation operation = () -> this.metadataStorageCoordinator.markAllSegmentsAsUnused(dataSourceName);
        Response response = this.performSegmentUpdate(dataSourceName, operation);
        int responseCode = response.getStatus();
        if (responseCode >= 200 && responseCode < 300) {
            this.auditMarkUnusedOperation(response.getEntity(), dataSourceName, req);
        }
        return response;
    }

    @POST
    @Path(value="/{dataSourceName}/markUsed")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markNonOvershadowedSegmentsAsUsed(@PathParam(value="dataSourceName") String dataSourceName, SegmentsToUpdateFilter payload) {
        if (payload == null || !payload.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid request payload. Specify either 'interval' or 'segmentIds', but not both. Optionally, include 'versions' only when 'interval' is provided.").build();
        }
        SegmentUpdateOperation operation = () -> {
            Interval interval = payload.getInterval();
            List versions = payload.getVersions();
            if (interval != null) {
                return this.segmentsMetadataManager.markAsUsedNonOvershadowedSegmentsInInterval(dataSourceName, interval, versions);
            }
            Set segmentIds = payload.getSegmentIds();
            if (segmentIds == null || segmentIds.isEmpty()) {
                return 0;
            }
            return this.segmentsMetadataManager.markAsUsedNonOvershadowedSegments(dataSourceName, IdUtils.getValidSegmentIds((String)dataSourceName, (Set)segmentIds));
        };
        return this.performSegmentUpdate(dataSourceName, operation);
    }

    @POST
    @Path(value="/{dataSourceName}/markUnused")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response markSegmentsAsUnused(@PathParam(value="dataSourceName") String dataSourceName, SegmentsToUpdateFilter payload, @Context HttpServletRequest req) {
        if (payload == null || !payload.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid request payload. Specify either 'interval' or 'segmentIds', but not both. Optionally, include 'versions' only when 'interval' is provided.").build();
        }
        SegmentUpdateOperation operation = () -> {
            int numUpdatedSegments;
            Interval interval = payload.getInterval();
            List versions = payload.getVersions();
            if (interval != null) {
                numUpdatedSegments = this.metadataStorageCoordinator.markSegmentsWithinIntervalAsUnused(dataSourceName, interval, versions);
            } else {
                Set segmentIds = payload.getSegmentIds().stream().map(id -> SegmentId.tryParse((String)dataSourceName, (String)id)).filter(Objects::nonNull).collect(Collectors.toSet());
                numUpdatedSegments = this.metadataStorageCoordinator.markSegmentsAsUnused(dataSourceName, segmentIds.stream().filter(segmentId -> segmentId.getDataSource().equals(dataSourceName)).collect(Collectors.toSet()));
            }
            this.auditMarkUnusedOperation(payload, dataSourceName, req);
            return numUpdatedSegments;
        };
        return this.performSegmentUpdate(dataSourceName, operation);
    }

    @POST
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markSegmentAsUsed(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        SegmentUpdateOperation operation = () -> this.segmentsMetadataManager.markSegmentAsUsed(segmentId) ? 1 : 0;
        return this.performSegmentUpdate(dataSourceName, operation);
    }

    @DELETE
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markSegmentAsUnused(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentIdString) {
        SegmentId segmentId = SegmentId.tryParse((String)dataSourceName, (String)segmentIdString);
        if (segmentId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringUtils.format((String)"Could not parse Segment ID[%s] for DataSource[%s]", (Object[])new Object[]{segmentIdString, dataSourceName})).build();
        }
        SegmentUpdateOperation operation = () -> this.metadataStorageCoordinator.markSegmentAsUnused(segmentId) ? 1 : 0;
        return this.performSegmentUpdate(dataSourceName, operation);
    }

    private Response performSegmentUpdate(String dataSourceName, SegmentUpdateOperation operation) {
        if (!this.taskMaster.isHalfOrFullLeader()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"I am not leader").build();
        }
        try {
            int numChangedSegments = operation.perform();
            return Response.ok((Object)new SegmentUpdateResponse(numChangedSegments)).build();
        }
        catch (DruidException e) {
            return ServletResourceUtils.buildErrorResponseFrom((DruidException)e);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error occurred while updating segments for datasource[%s]", new Object[]{dataSourceName});
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Server error", (Object)"message", (Object)Throwables.getRootCause((Throwable)e).toString())).build();
        }
    }

    private void auditMarkUnusedOperation(Object auditPayload, String dataSourceName, HttpServletRequest request) {
        this.auditManager.doAudit(AuditEntry.builder().key(dataSourceName).type("segment.markUnused").payload(auditPayload).auditInfo(AuthorizationUtils.buildAuditInfo((HttpServletRequest)request)).request(AuthorizationUtils.buildRequestInfo((String)"overlord", (HttpServletRequest)request)).build());
    }

    private static interface SegmentUpdateOperation {
        public int perform();
    }
}

