/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.DefaultEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.FilteredServerInventoryView;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.JsonParserIterator;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStatus;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamFullResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamFullResponseHolder;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.metadata.AvailableSegmentMetadata;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCache;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.MetadataSegmentView;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentStatusInCluster;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class SystemSchema
extends AbstractSchema {
    private static final String SEGMENTS_TABLE = "segments";
    private static final String SERVERS_TABLE = "servers";
    private static final String SERVER_SEGMENTS_TABLE = "server_segments";
    private static final String TASKS_TABLE = "tasks";
    private static final String SUPERVISOR_TABLE = "supervisors";
    private static final Function<SegmentStatusInCluster, Iterable<ResourceAction>> SEGMENT_STATUS_IN_CLUSTER_RA_GENERATOR = segment -> Collections.singletonList((ResourceAction)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getDataSegment().getDataSource()));
    private static final Function<DataSegment, Iterable<ResourceAction>> SEGMENT_RA_GENERATOR = segment -> Collections.singletonList((ResourceAction)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getDataSource()));
    private static final long REPLICATION_FACTOR_UNKNOWN = -1L;
    private static final long IS_ACTIVE_FALSE = 0L;
    private static final long IS_ACTIVE_TRUE = 1L;
    private static final long IS_PUBLISHED_FALSE = 0L;
    private static final long IS_PUBLISHED_TRUE = 1L;
    private static final long IS_AVAILABLE_TRUE = 1L;
    private static final long IS_OVERSHADOWED_FALSE = 0L;
    private static final long IS_OVERSHADOWED_TRUE = 1L;
    static final RowSignature SEGMENTS_SIGNATURE = RowSignature.builder().add("segment_id", ColumnType.STRING).add("datasource", ColumnType.STRING).add("start", ColumnType.STRING).add("end", ColumnType.STRING).add("size", ColumnType.LONG).add("version", ColumnType.STRING).add("partition_num", ColumnType.LONG).add("num_replicas", ColumnType.LONG).add("num_rows", ColumnType.LONG).add("is_active", ColumnType.LONG).add("is_published", ColumnType.LONG).add("is_available", ColumnType.LONG).add("is_realtime", ColumnType.LONG).add("is_overshadowed", ColumnType.LONG).add("shard_spec", ColumnType.STRING).add("dimensions", ColumnType.STRING).add("metrics", ColumnType.STRING).add("last_compaction_state", ColumnType.STRING).add("replication_factor", ColumnType.LONG).build();
    private static final int[] SEGMENTS_PROJECT_ALL = IntStream.range(0, SEGMENTS_SIGNATURE.size()).toArray();
    private static final IntSet SEGMENTS_JSON_FIELDS = new IntOpenHashSet(new int[]{SEGMENTS_SIGNATURE.indexOf("shard_spec"), SEGMENTS_SIGNATURE.indexOf("dimensions"), SEGMENTS_SIGNATURE.indexOf("metrics"), SEGMENTS_SIGNATURE.indexOf("last_compaction_state")});
    static final RowSignature SERVERS_SIGNATURE = RowSignature.builder().add("server", ColumnType.STRING).add("host", ColumnType.STRING).add("plaintext_port", ColumnType.LONG).add("tls_port", ColumnType.LONG).add("server_type", ColumnType.STRING).add("tier", ColumnType.STRING).add("curr_size", ColumnType.LONG).add("max_size", ColumnType.LONG).add("is_leader", ColumnType.LONG).add("start_time", ColumnType.STRING).build();
    static final RowSignature SERVER_SEGMENTS_SIGNATURE = RowSignature.builder().add("server", ColumnType.STRING).add("segment_id", ColumnType.STRING).build();
    static final RowSignature TASKS_SIGNATURE = RowSignature.builder().add("task_id", ColumnType.STRING).add("group_id", ColumnType.STRING).add("type", ColumnType.STRING).add("datasource", ColumnType.STRING).add("created_time", ColumnType.STRING).add("queue_insertion_time", ColumnType.STRING).add("status", ColumnType.STRING).add("runner_status", ColumnType.STRING).add("duration", ColumnType.LONG).add("location", ColumnType.STRING).add("host", ColumnType.STRING).add("plaintext_port", ColumnType.LONG).add("tls_port", ColumnType.LONG).add("error_msg", ColumnType.STRING).build();
    static final RowSignature SUPERVISOR_SIGNATURE = RowSignature.builder().add("supervisor_id", ColumnType.STRING).add("state", ColumnType.STRING).add("detailed_state", ColumnType.STRING).add("healthy", ColumnType.LONG).add("type", ColumnType.STRING).add("source", ColumnType.STRING).add("suspended", ColumnType.LONG).add("spec", ColumnType.STRING).build();
    private final Map<String, Table> tableMap;

    @Inject
    public SystemSchema(DruidSchema druidSchema, MetadataSegmentView metadataView, TimelineServerView serverView, FilteredServerInventoryView serverInventoryView, AuthorizerMapper authorizerMapper, @Coordinator DruidLeaderClient coordinatorDruidLeaderClient, OverlordClient overlordClient, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, ObjectMapper jsonMapper) {
        Preconditions.checkNotNull((Object)serverView, (Object)"serverView");
        this.tableMap = ImmutableMap.of((Object)SEGMENTS_TABLE, (Object)((Object)new SegmentsTable(druidSchema, metadataView, jsonMapper, authorizerMapper)), (Object)SERVERS_TABLE, (Object)((Object)new ServersTable(druidNodeDiscoveryProvider, serverInventoryView, authorizerMapper, overlordClient, coordinatorDruidLeaderClient)), (Object)SERVER_SEGMENTS_TABLE, (Object)((Object)new ServerSegmentsTable(serverView, authorizerMapper)), (Object)TASKS_TABLE, (Object)((Object)new TasksTable(overlordClient, authorizerMapper)), (Object)SUPERVISOR_TABLE, (Object)((Object)new SupervisorsTable(overlordClient, authorizerMapper)));
    }

    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    public static <T> JsonParserIterator<T> getThingsFromLeaderNode(String query, TypeReference<T> typeRef, DruidLeaderClient leaderClient, ObjectMapper jsonMapper) {
        InputStreamFullResponseHolder responseHolder;
        Request request;
        try {
            request = leaderClient.makeRequest(HttpMethod.GET, query);
            responseHolder = (InputStreamFullResponseHolder)leaderClient.go(request, (HttpResponseHandler)new InputStreamFullResponseHandler());
            if (responseHolder.getStatus().getCode() != 200) {
                throw new RE("Failed to talk to leader node at [%s]. Error code [%d], description [%s].", new Object[]{query, responseHolder.getStatus().getCode(), responseHolder.getStatus().getReasonPhrase()});
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        JavaType javaType = jsonMapper.getTypeFactory().constructType(typeRef);
        return new JsonParserIterator(javaType, (Future)Futures.immediateFuture((Object)responseHolder.getContent()), request.getUrl().toString(), null, request.getUrl().getHost(), jsonMapper);
    }

    private static <T> CloseableIterator<T> wrap(final Iterator<T> iterator, final Closeable closer) {
        return new CloseableIterator<T>(){

            public boolean hasNext() {
                boolean hasNext = iterator.hasNext();
                if (!hasNext) {
                    try {
                        closer.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return hasNext;
            }

            public T next() {
                return iterator.next();
            }

            public void close() throws IOException {
                closer.close();
            }
        };
    }

    @Nullable
    private static String toStringOrNull(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    private static void checkStateReadAccessForServers(AuthenticationResult authenticationResult, AuthorizerMapper authorizerMapper) {
        AuthorizationResult authResult = AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)authenticationResult, Collections.singletonList(new ResourceAction(Resource.STATE_RESOURCE, Action.READ)), (AuthorizerMapper)authorizerMapper);
        if (!authResult.allowAccessWithNoRestriction()) {
            throw new ForbiddenException("Insufficient permission to view servers: " + authResult.getErrorMessage());
        }
    }

    private static Object[] projectSegmentsRow(Object[] row, @Nullable int[] projects, ObjectMapper jsonMapper) {
        int[] nonNullProjects = projects == null ? SEGMENTS_PROJECT_ALL : projects;
        Object[] projectedRow = new Object[nonNullProjects.length];
        for (int i = 0; i < nonNullProjects.length; ++i) {
            Object o = row[nonNullProjects[i]];
            if (((ColumnType)SEGMENTS_SIGNATURE.getColumnType(nonNullProjects[i]).get()).is((TypeDescriptor)ValueType.STRING) && o != null && !(o instanceof String)) {
                if (SEGMENTS_JSON_FIELDS.contains(nonNullProjects[i])) {
                    try {
                        projectedRow[i] = jsonMapper.writeValueAsString(o);
                        continue;
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
                projectedRow[i] = o.toString();
                continue;
            }
            projectedRow[i] = o;
        }
        return projectedRow;
    }

    static class SegmentsTable
    extends AbstractTable
    implements ProjectableFilterableTable {
        private final DruidSchema druidSchema;
        private final ObjectMapper jsonMapper;
        private final AuthorizerMapper authorizerMapper;
        private final MetadataSegmentView metadataView;

        public SegmentsTable(DruidSchema druidSchemna, MetadataSegmentView metadataView, ObjectMapper jsonMapper, AuthorizerMapper authorizerMapper) {
            this.druidSchema = druidSchemna;
            this.metadataView = metadataView;
            this.jsonMapper = jsonMapper;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return RowSignatures.toRelDataType(SEGMENTS_SIGNATURE, typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root, List<RexNode> filters, @Nullable int[] projects) {
            BrokerSegmentMetadataCache availableMetadataCache = this.druidSchema.cache();
            HashSet segmentsAlreadySeen = Sets.newHashSetWithExpectedSize((int)availableMetadataCache.getTotalSegments());
            Iterator<SegmentStatusInCluster> metadataStoreSegments = this.metadataView.getSegments();
            FluentIterable publishedSegments = FluentIterable.from(() -> this.getAuthorizedPublishedSegments(metadataStoreSegments, root)).transform(val -> {
                boolean isPublished;
                DataSegment segment = val.getDataSegment();
                AvailableSegmentMetadata availableSegmentMetadata = availableMetadataCache.getAvailableSegmentMetadata(segment.getDataSource(), segment.getId());
                segmentsAlreadySeen.add(segment.getId());
                long numReplicas = 0L;
                long numRows = 0L;
                long isAvailable = 0L;
                if (availableSegmentMetadata != null) {
                    numReplicas = availableSegmentMetadata.getNumReplicas();
                    isAvailable = availableSegmentMetadata.getNumReplicas() > 0L ? 1L : 0L;
                    numRows = availableSegmentMetadata.getNumRows();
                }
                if (null != val.getNumRows()) {
                    numRows = val.getNumRows();
                }
                long isRealtime = val.isRealtime() ? 1L : 0L;
                boolean bl = isPublished = !val.isRealtime();
                boolean isActive = isPublished ? !val.isOvershadowed() : val.isRealtime();
                return new Object[]{segment.getId(), segment.getDataSource(), segment.getInterval().getStart(), segment.getInterval().getEnd(), segment.getSize(), segment.getVersion(), (long)segment.getShardSpec().getPartitionNum(), numReplicas, numRows, isActive ? 1L : 0L, isPublished ? 1L : 0L, isAvailable, isRealtime, val.isOvershadowed() ? 1L : 0L, segment.getShardSpec(), segment.getDimensions(), segment.getMetrics(), segment.getLastCompactionState(), val.getReplicationFactor() == null ? -1L : (long)val.getReplicationFactor().intValue()};
            });
            FluentIterable availableSegments = FluentIterable.from(() -> this.getAuthorizedAvailableSegments(availableMetadataCache.iterateSegmentMetadata(), root)).transform(val -> {
                DataSegment segment = val.getSegment();
                if (segmentsAlreadySeen.contains(segment.getId())) {
                    return null;
                }
                return new Object[]{segment.getId(), segment.getDataSource(), segment.getInterval().getStart(), segment.getInterval().getEnd(), segment.getSize(), segment.getVersion(), (long)segment.getShardSpec().getPartitionNum(), val.getNumReplicas(), val.getNumRows(), val.isRealtime(), 0L, 1L, val.isRealtime(), 0L, segment.getShardSpec(), segment.getDimensions(), segment.getMetrics(), null, -1L};
            });
            Iterable allSegments = Iterables.unmodifiableIterable((Iterable)Iterables.concat((Iterable)publishedSegments, (Iterable)availableSegments));
            return Linq4j.asEnumerable((Iterable)allSegments).where(Objects::nonNull).select(row -> SystemSchema.projectSegmentsRow(row, projects, this.jsonMapper));
        }

        private Iterator<SegmentStatusInCluster> getAuthorizedPublishedSegments(Iterator<SegmentStatusInCluster> it, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)root.get("authenticationResult"), (Object)"authenticationResult in dataContext");
            Iterable authorizedSegments = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> it, SEGMENT_STATUS_IN_CLUSTER_RA_GENERATOR, (AuthorizerMapper)this.authorizerMapper);
            return authorizedSegments.iterator();
        }

        private Iterator<AvailableSegmentMetadata> getAuthorizedAvailableSegments(Iterator<AvailableSegmentMetadata> availableSegmentEntries, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)root.get("authenticationResult"), (Object)"authenticationResult in dataContext");
            Function raGenerator = segment -> Collections.singletonList((ResourceAction)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getSegment().getDataSource()));
            Iterable authorizedSegments = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> availableSegmentEntries, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper);
            return authorizedSegments.iterator();
        }

        private static class PartialSegmentData {
            private final long isAvailable;
            private final long isRealtime;
            private final long numReplicas;
            private final long numRows;

            public PartialSegmentData(long isAvailable, long isRealtime, long numReplicas, long numRows) {
                this.isAvailable = isAvailable;
                this.isRealtime = isRealtime;
                this.numReplicas = numReplicas;
                this.numRows = numRows;
            }

            public long isAvailable() {
                return this.isAvailable;
            }

            public long isRealtime() {
                return this.isRealtime;
            }

            public long getNumReplicas() {
                return this.numReplicas;
            }

            public long getNumRows() {
                return this.numRows;
            }
        }
    }

    static class ServersTable
    extends AbstractTable
    implements ScannableTable {
        private static final long UNKNOWN_SIZE = 0L;
        private final AuthorizerMapper authorizerMapper;
        private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
        private final FilteredServerInventoryView serverInventoryView;
        private final OverlordClient overlordClient;
        private final DruidLeaderClient coordinatorLeaderClient;

        public ServersTable(DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, FilteredServerInventoryView serverInventoryView, AuthorizerMapper authorizerMapper, OverlordClient overlordClient, DruidLeaderClient coordinatorLeaderClient) {
            this.authorizerMapper = authorizerMapper;
            this.druidNodeDiscoveryProvider = druidNodeDiscoveryProvider;
            this.serverInventoryView = serverInventoryView;
            this.overlordClient = overlordClient;
            this.coordinatorLeaderClient = coordinatorLeaderClient;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return RowSignatures.toRelDataType(SERVERS_SIGNATURE, typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            Iterator<DiscoveryDruidNode> druidServers = ServersTable.getDruidServers(this.druidNodeDiscoveryProvider);
            AuthenticationResult authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)root.get("authenticationResult"), (Object)"authenticationResult in dataContext");
            SystemSchema.checkStateReadAccessForServers(authenticationResult, this.authorizerMapper);
            String tmpCoordinatorLeader = "";
            String tmpOverlordLeader = "";
            try {
                tmpCoordinatorLeader = this.coordinatorLeaderClient.findCurrentLeader();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tmpOverlordLeader = ((URI)FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.findCurrentLeader(), (boolean)true)).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String coordinatorLeader = tmpCoordinatorLeader;
            String overlordLeader = tmpOverlordLeader;
            FluentIterable results = FluentIterable.from(() -> druidServers).transform(discoveryDruidNode -> {
                boolean isDiscoverableDataServer = ServersTable.isDiscoverableDataServer((DataNodeService)discoveryDruidNode.getService("dataNodeService", DataNodeService.class));
                NodeRole serverRole = discoveryDruidNode.getNodeRole();
                if (isDiscoverableDataServer) {
                    DruidServer druidServer = this.serverInventoryView.getInventoryValue(discoveryDruidNode.getDruidNode().getHostAndPortToUse());
                    if (druidServer != null || NodeRole.HISTORICAL.equals((Object)serverRole)) {
                        return ServersTable.buildRowForDiscoverableDataServer(discoveryDruidNode, druidServer);
                    }
                    return ServersTable.buildRowForNonDataServer(discoveryDruidNode);
                }
                if (NodeRole.COORDINATOR.equals((Object)serverRole)) {
                    return ServersTable.buildRowForNonDataServerWithLeadership(discoveryDruidNode, coordinatorLeader.contains(discoveryDruidNode.getDruidNode().getHostAndPortToUse()));
                }
                if (NodeRole.OVERLORD.equals((Object)serverRole)) {
                    return ServersTable.buildRowForNonDataServerWithLeadership(discoveryDruidNode, overlordLeader.contains(discoveryDruidNode.getDruidNode().getHostAndPortToUse()));
                }
                return ServersTable.buildRowForNonDataServer(discoveryDruidNode);
            });
            return Linq4j.asEnumerable((Iterable)results);
        }

        private static Object[] buildRowForNonDataServer(DiscoveryDruidNode discoveryDruidNode) {
            DruidNode node = discoveryDruidNode.getDruidNode();
            return new Object[]{node.getHostAndPortToUse(), node.getHost(), (long)node.getPlaintextPort(), (long)node.getTlsPort(), StringUtils.toLowerCase((String)discoveryDruidNode.getNodeRole().toString()), null, 0L, 0L, null, SystemSchema.toStringOrNull(discoveryDruidNode.getStartTime())};
        }

        private static Object[] buildRowForNonDataServerWithLeadership(DiscoveryDruidNode discoveryDruidNode, boolean isLeader) {
            DruidNode node = discoveryDruidNode.getDruidNode();
            return new Object[]{node.getHostAndPortToUse(), node.getHost(), (long)node.getPlaintextPort(), (long)node.getTlsPort(), StringUtils.toLowerCase((String)discoveryDruidNode.getNodeRole().toString()), null, 0L, 0L, isLeader ? 1L : 0L, SystemSchema.toStringOrNull(discoveryDruidNode.getStartTime())};
        }

        private static Object[] buildRowForDiscoverableDataServer(DiscoveryDruidNode discoveryDruidNode, @Nullable DruidServer serverFromInventoryView) {
            DruidNode node = discoveryDruidNode.getDruidNode();
            DruidServer druidServerToUse = serverFromInventoryView == null ? ServersTable.toDruidServer(discoveryDruidNode) : serverFromInventoryView;
            long currentSize = serverFromInventoryView == null ? 0L : serverFromInventoryView.getCurrSize();
            return new Object[]{node.getHostAndPortToUse(), node.getHost(), (long)node.getPlaintextPort(), (long)node.getTlsPort(), StringUtils.toLowerCase((String)discoveryDruidNode.getNodeRole().toString()), druidServerToUse.getTier(), currentSize, druidServerToUse.getMaxSize(), null, SystemSchema.toStringOrNull(discoveryDruidNode.getStartTime())};
        }

        private static boolean isDiscoverableDataServer(DataNodeService dataNodeService) {
            return dataNodeService != null && dataNodeService.isDiscoverable();
        }

        private static DruidServer toDruidServer(DiscoveryDruidNode discoveryDruidNode) {
            DruidNode druidNode = discoveryDruidNode.getDruidNode();
            DataNodeService dataNodeService = (DataNodeService)discoveryDruidNode.getService("dataNodeService", DataNodeService.class);
            if (ServersTable.isDiscoverableDataServer(dataNodeService)) {
                return new DruidServer(druidNode.getHostAndPortToUse(), druidNode.getHostAndPort(), druidNode.getHostAndTlsPort(), dataNodeService.getMaxSize(), dataNodeService.getServerType(), dataNodeService.getTier(), dataNodeService.getPriority());
            }
            throw new ISE("[%s] is not a discoverable data server", new Object[]{discoveryDruidNode});
        }

        private static Iterator<DiscoveryDruidNode> getDruidServers(DruidNodeDiscoveryProvider druidNodeDiscoveryProvider) {
            return Arrays.stream(NodeRole.values()).flatMap(nodeRole -> druidNodeDiscoveryProvider.getForNodeRole(nodeRole).getAllNodes().stream()).collect(Collectors.toList()).iterator();
        }
    }

    static class ServerSegmentsTable
    extends AbstractTable
    implements ScannableTable {
        private final TimelineServerView serverView;
        final AuthorizerMapper authorizerMapper;

        public ServerSegmentsTable(TimelineServerView serverView, AuthorizerMapper authorizerMapper) {
            this.serverView = serverView;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return RowSignatures.toRelDataType(SERVER_SEGMENTS_SIGNATURE, typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)root.get("authenticationResult"), (Object)"authenticationResult in dataContext");
            SystemSchema.checkStateReadAccessForServers(authenticationResult, this.authorizerMapper);
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            List druidServers = this.serverView.getDruidServers();
            int serverSegmentsTableSize = SERVER_SEGMENTS_SIGNATURE.size();
            for (ImmutableDruidServer druidServer : druidServers) {
                Iterable authorizedServerSegments = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, (Iterable)druidServer.iterateAllSegments(), SEGMENT_RA_GENERATOR, (AuthorizerMapper)this.authorizerMapper);
                for (DataSegment segment : authorizedServerSegments) {
                    Object[] row = new Object[serverSegmentsTableSize];
                    row[0] = druidServer.getHost();
                    row[1] = segment.getId().toString();
                    rows.add(row);
                }
            }
            return Linq4j.asEnumerable(rows);
        }
    }

    static class TasksTable
    extends AbstractTable
    implements ScannableTable {
        private final OverlordClient overlordClient;
        private final AuthorizerMapper authorizerMapper;

        public TasksTable(OverlordClient overlordClient, AuthorizerMapper authorizerMapper) {
            this.overlordClient = overlordClient;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return RowSignatures.toRelDataType(TASKS_SIGNATURE, typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(final DataContext root) {
            class TasksEnumerable
            extends DefaultEnumerable<Object[]> {
                private final CloseableIterator<TaskStatusPlus> it;

                public TasksEnumerable(CloseableIterator<TaskStatusPlus> tasks) {
                    this.it = this$0.getAuthorizedTasks(tasks, root);
                }

                public Iterator<Object[]> iterator() {
                    throw new UnsupportedOperationException("Do not use iterator(), it cannot be closed.");
                }

                public Enumerator<Object[]> enumerator() {
                    return new Enumerator<Object[]>(){

                        public Object[] current() {
                            TaskStatusPlus task = (TaskStatusPlus)it.next();
                            return new Object[]{task.getId(), task.getGroupId(), task.getType(), task.getDataSource(), SystemSchema.toStringOrNull(task.getCreatedTime()), SystemSchema.toStringOrNull(task.getQueueInsertionTime()), SystemSchema.toStringOrNull(task.getStatusCode()), SystemSchema.toStringOrNull(task.getRunnerStatusCode()), task.getDuration() == null ? 0L : task.getDuration(), task.getLocation().getLocation(), task.getLocation().getHost(), (long)task.getLocation().getPort(), (long)task.getLocation().getTlsPort(), task.getErrorMsg()};
                        }

                        public boolean moveNext() {
                            return it.hasNext();
                        }

                        public void reset() {
                        }

                        public void close() {
                            try {
                                it.close();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
            }
            return new TasksEnumerable((CloseableIterator)FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.taskStatuses(null, null, null), (boolean)true));
        }

        private CloseableIterator<TaskStatusPlus> getAuthorizedTasks(CloseableIterator<TaskStatusPlus> it, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)root.get("authenticationResult"), (Object)"authenticationResult in dataContext");
            Function raGenerator = task -> Collections.singletonList((ResourceAction)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)task.getDataSource()));
            Iterable authorizedTasks = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> it, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper);
            return SystemSchema.wrap(authorizedTasks.iterator(), it);
        }
    }

    static class SupervisorsTable
    extends AbstractTable
    implements ScannableTable {
        private final OverlordClient overlordClient;
        private final AuthorizerMapper authorizerMapper;

        public SupervisorsTable(OverlordClient overlordClient, AuthorizerMapper authorizerMapper) {
            this.overlordClient = overlordClient;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return RowSignatures.toRelDataType(SUPERVISOR_SIGNATURE, typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(final DataContext root) {
            class SupervisorsEnumerable
            extends DefaultEnumerable<Object[]> {
                private final CloseableIterator<SupervisorStatus> it;

                public SupervisorsEnumerable(CloseableIterator<SupervisorStatus> tasks) {
                    this.it = this$0.getAuthorizedSupervisors(tasks, root);
                }

                public Iterator<Object[]> iterator() {
                    throw new UnsupportedOperationException("Do not use iterator(), it cannot be closed.");
                }

                public Enumerator<Object[]> enumerator() {
                    return new Enumerator<Object[]>(){

                        public Object[] current() {
                            SupervisorStatus supervisor = (SupervisorStatus)it.next();
                            return new Object[]{supervisor.getId(), supervisor.getState(), supervisor.getDetailedState(), supervisor.isHealthy() ? 1L : 0L, supervisor.getType(), supervisor.getSource(), supervisor.isSuspended() ? 1L : 0L, supervisor.getSpecString()};
                        }

                        public boolean moveNext() {
                            return it.hasNext();
                        }

                        public void reset() {
                        }

                        public void close() {
                            try {
                                it.close();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
            }
            return new SupervisorsEnumerable((CloseableIterator)FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.supervisorStatuses(), (boolean)true));
        }

        private CloseableIterator<SupervisorStatus> getAuthorizedSupervisors(CloseableIterator<SupervisorStatus> it, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)root.get("authenticationResult"), (Object)"authenticationResult in dataContext");
            Function raGenerator = supervisor -> Collections.singletonList((ResourceAction)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)supervisor.getSource()));
            Iterable authorizedSupervisors = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> it, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper);
            return SystemSchema.wrap(authorizedSupervisors.iterator(), it);
        }
    }
}

