/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

class InputStreamArgument
implements Argument {
    private final InputStream value;
    private final int length;
    private final boolean ascii;

    InputStreamArgument(InputStream value, int length, boolean ascii) {
        this.value = value;
        this.length = length;
        this.ascii = ascii;
    }

    @Override
    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.ascii) {
            if (this.value != null) {
                statement.setAsciiStream(position, this.value, this.length);
            } else {
                statement.setNull(position, -1);
            }
        } else if (this.value != null) {
            statement.setBinaryStream(position, this.value, this.length);
        } else {
            statement.setNull(position, -4);
        }
    }
}

