/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class LocalResource {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static LocalResource newInstance(URL url, LocalResourceType type, LocalResourceVisibility visibility, long size, long timestamp, String pattern) {
        return LocalResource.newInstance(url, type, visibility, size, timestamp, pattern, false);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static LocalResource newInstance(URL url, LocalResourceType type, LocalResourceVisibility visibility, long size, long timestamp, String pattern, boolean shouldBeUploadedToSharedCache) {
        LocalResource resource = Records.newRecord(LocalResource.class);
        resource.setResource(url);
        resource.setType(type);
        resource.setVisibility(visibility);
        resource.setSize(size);
        resource.setTimestamp(timestamp);
        resource.setPattern(pattern);
        resource.setShouldBeUploadedToSharedCache(shouldBeUploadedToSharedCache);
        return resource;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static LocalResource newInstance(URL url, LocalResourceType type, LocalResourceVisibility visibility, long size, long timestamp) {
        return LocalResource.newInstance(url, type, visibility, size, timestamp, null);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static LocalResource newInstance(URL url, LocalResourceType type, LocalResourceVisibility visibility, long size, long timestamp, boolean shouldBeUploadedToSharedCache) {
        return LocalResource.newInstance(url, type, visibility, size, timestamp, null, shouldBeUploadedToSharedCache);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract URL getResource();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setResource(URL var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract long getSize();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setSize(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract long getTimestamp();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setTimestamp(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract LocalResourceType getType();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setType(LocalResourceType var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract LocalResourceVisibility getVisibility();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setVisibility(LocalResourceVisibility var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getPattern();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setPattern(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract boolean getShouldBeUploadedToSharedCache();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setShouldBeUploadedToSharedCache(boolean var1);
}

