/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.BinaryBooleanOpExprBase;
import org.apache.druid.math.expr.BinaryOpExprBase;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeConversion;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorComparisonProcessors;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.index.AllUnknownBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.ValueIndexes;

class BinEqExpr
extends BinaryBooleanOpExprBase {
    BinEqExpr(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    protected BinaryOpExprBase copy(Expr left, Expr right) {
        return new BinEqExpr(this.op, left, right);
    }

    @Override
    protected boolean evalString(@Nullable String left, @Nullable String right) {
        return Objects.equals(left, right);
    }

    @Override
    protected boolean evalArray(ExprEval left, ExprEval right) {
        ExpressionType type = ExpressionTypeConversion.leastRestrictiveType(left.type(), right.type());
        return type.getNullableStrategy().compare(left.castTo(type).asArray(), right.castTo(type).asArray()) == 0;
    }

    @Override
    protected final boolean evalLong(long left, long right) {
        return left == right;
    }

    @Override
    protected final boolean evalDouble(double left, double right) {
        return left == right;
    }

    @Override
    public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        return VectorComparisonProcessors.equals().asProcessor(inspector, this.left, this.right);
    }

    @Override
    @Nullable
    public BitmapColumnIndex asBitmapColumnIndex(ColumnIndexSelector selector) {
        TypeSignature sourceType;
        ColumnIndexSupplier indexSupplier;
        Object matchValue;
        ColumnType matchType;
        ExpressionType matchExprType;
        if (this.right.isLiteral()) {
            matchExprType = this.right.getOutputType(InputBindings.nilBindings());
            matchType = matchExprType != null ? ExpressionType.toColumnType(matchExprType) : ColumnType.STRING;
            matchValue = this.right.getLiteralValue();
            indexSupplier = this.left.asColumnIndexSupplier(selector, matchType);
            ExpressionType sourceExprType = this.left.getOutputType(selector);
            sourceType = sourceExprType != null ? ExpressionType.toColumnType(sourceExprType) : null;
        } else if (this.left.isLiteral()) {
            matchExprType = this.left.getOutputType(InputBindings.nilBindings());
            matchType = matchExprType != null ? ExpressionType.toColumnType(matchExprType) : ColumnType.STRING;
            matchValue = this.left.getLiteralValue();
            indexSupplier = this.right.asColumnIndexSupplier(selector, matchType);
            ExpressionType sourceExprType = this.right.getOutputType(selector);
            sourceType = sourceExprType != null ? ExpressionType.toColumnType(sourceExprType) : null;
        } else {
            indexSupplier = null;
            matchValue = null;
            matchType = null;
            sourceType = null;
        }
        if (indexSupplier == null) {
            return null;
        }
        if (matchType.isNumeric() && (sourceType == null || sourceType.is(ValueType.STRING))) {
            return null;
        }
        ValueIndexes valueIndexes = indexSupplier.as(ValueIndexes.class);
        if (valueIndexes == null) {
            return null;
        }
        if (matchValue == null) {
            return new AllUnknownBitmapColumnIndex(selector);
        }
        return valueIndexes.forValue(matchValue, matchType);
    }
}

