/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.File;
import java.util.Comparator;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.LongDimensionIndexer;
import org.apache.druid.segment.LongDimensionMergerV9;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableLongColumnValueSelector;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class LongDimensionHandler
implements DimensionHandler<Long, Long, Long> {
    private static Comparator<ColumnValueSelector> LONG_COLUMN_COMPARATOR = (s1, s2) -> {
        if (s1.isNull()) {
            return s2.isNull() ? 0 : -1;
        }
        if (s2.isNull()) {
            return 1;
        }
        return Long.compare(s1.getLong(), s2.getLong());
    };
    private final String dimensionName;

    public LongDimensionHandler(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public DimensionSpec getDimensionSpec() {
        return new DefaultDimensionSpec(this.dimensionName, this.dimensionName, ColumnType.LONG);
    }

    @Override
    public DimensionSchema getDimensionSchema(ColumnCapabilities capabilities) {
        return new LongDimensionSchema(this.dimensionName);
    }

    @Override
    public DimensionIndexer<Long, Long, Long> makeIndexer() {
        return new LongDimensionIndexer(this.dimensionName);
    }

    @Override
    public DimensionMergerV9 makeMerger(String outputName, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress, File segmentBaseDir, Closer closer) {
        return new LongDimensionMergerV9(outputName, indexSpec, segmentWriteOutMedium);
    }

    @Override
    public int getLengthOfEncodedKeyComponent(Long dimVals) {
        return 1;
    }

    @Override
    public Comparator<ColumnValueSelector> getEncodedValueSelectorComparator() {
        return LONG_COLUMN_COMPARATOR;
    }

    @Override
    public SettableColumnValueSelector makeNewSettableEncodedValueSelector() {
        return new SettableLongColumnValueSelector();
    }
}

