/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.apache.druid.segment.data.ColumnarFloats;

public class EntireLayoutColumnarFloatsSupplier
implements Supplier<ColumnarFloats> {
    private final int totalSize;
    private FloatBuffer buffer;

    public EntireLayoutColumnarFloatsSupplier(int totalSize, ByteBuffer fromBuffer, ByteOrder order) {
        this.totalSize = totalSize;
        this.buffer = fromBuffer.asReadOnlyBuffer().order(order).asFloatBuffer();
    }

    public ColumnarFloats get() {
        return new EntireLayoutColumnarFloats();
    }

    private class EntireLayoutColumnarFloats
    implements ColumnarFloats {
        private EntireLayoutColumnarFloats() {
        }

        @Override
        public int size() {
            return EntireLayoutColumnarFloatsSupplier.this.totalSize;
        }

        @Override
        public float get(int index) {
            return EntireLayoutColumnarFloatsSupplier.this.buffer.get(EntireLayoutColumnarFloatsSupplier.this.buffer.position() + index);
        }

        public String toString() {
            return "EntireLayoutColumnarFloats{, totalSize=" + EntireLayoutColumnarFloatsSupplier.this.totalSize + "}";
        }

        @Override
        public void close() {
        }
    }
}

