/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorSizeInspector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class ConstantVectorSelectors {
    public static VectorValueSelector vectorValueSelector(final VectorSizeInspector inspector, @Nullable Number constant) {
        if (constant == null) {
            return NilVectorSelector.create(inspector);
        }
        final long[] longVector = new long[inspector.getMaxVectorSize()];
        final float[] floatVector = new float[inspector.getMaxVectorSize()];
        final double[] doubleVector = new double[inspector.getMaxVectorSize()];
        Arrays.fill(longVector, constant.longValue());
        Arrays.fill(floatVector, constant.floatValue());
        Arrays.fill(doubleVector, constant.doubleValue());
        return new VectorValueSelector(){

            @Override
            public long[] getLongVector() {
                return longVector;
            }

            @Override
            public float[] getFloatVector() {
                return floatVector;
            }

            @Override
            public double[] getDoubleVector() {
                return doubleVector;
            }

            @Override
            @Nullable
            public boolean[] getNullVector() {
                return null;
            }

            @Override
            public int getMaxVectorSize() {
                return inspector.getMaxVectorSize();
            }

            @Override
            public int getCurrentVectorSize() {
                return inspector.getCurrentVectorSize();
            }
        };
    }

    public static VectorObjectSelector vectorObjectSelector(final VectorSizeInspector inspector, @Nullable Object object) {
        if (object == null) {
            return NilVectorSelector.create(inspector);
        }
        final Object[] objects = new Object[inspector.getMaxVectorSize()];
        Arrays.fill(objects, object);
        return new VectorObjectSelector(){

            @Override
            public Object[] getObjectVector() {
                return objects;
            }

            @Override
            public int getMaxVectorSize() {
                return inspector.getMaxVectorSize();
            }

            @Override
            public int getCurrentVectorSize() {
                return inspector.getCurrentVectorSize();
            }
        };
    }

    public static SingleValueDimensionVectorSelector singleValueDimensionVectorSelector(final VectorSizeInspector inspector, final @Nullable String value) {
        if (value == null) {
            return NilVectorSelector.create(inspector);
        }
        final int[] row = new int[inspector.getMaxVectorSize()];
        return new SingleValueDimensionVectorSelector(){

            @Override
            public int[] getRowVector() {
                return row;
            }

            @Override
            public int getValueCardinality() {
                return 1;
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return value;
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            @Override
            public int getMaxVectorSize() {
                return inspector.getMaxVectorSize();
            }

            @Override
            public int getCurrentVectorSize() {
                return inspector.getCurrentVectorSize();
            }
        };
    }
}

