/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.gcp;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.inject.Binder;
import com.google.inject.Provides;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.initialization.DruidModule;

public class GcpModule
implements DruidModule {
    public void configure(Binder binder) {
    }

    @Provides
    @LazySingleton
    public HttpRequestInitializer getHttpRequestInitializer(HttpTransport transport, JsonFactory factory) throws IOException {
        GoogleCredential credential = GoogleCredential.getApplicationDefault((HttpTransport)transport, (JsonFactory)factory);
        if (credential.createScopedRequired()) {
            credential = credential.createScoped(Collections.singleton("https://www.googleapis.com/auth/cloud-platform"));
        }
        return credential;
    }

    @Provides
    @LazySingleton
    public HttpTransport getHttpTransport() throws GeneralSecurityException, IOException {
        return GoogleNetHttpTransport.newTrustedTransport();
    }

    @Provides
    @LazySingleton
    public JsonFactory getJsonFactory() {
        return JacksonFactory.getDefaultInstance();
    }
}

