/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.models.BlobRetentionPolicy;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobMetrics
implements XmlSerializable<BlobMetrics> {
    private String version;
    private boolean enabled;
    private Boolean includeApis;
    private BlobRetentionPolicy retentionPolicy;

    public String getVersion() {
        return this.version;
    }

    public BlobMetrics setVersion(String version) {
        this.version = version;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BlobMetrics setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean isIncludeApis() {
        return this.includeApis;
    }

    public BlobMetrics setIncludeApis(Boolean includeApis) {
        this.includeApis = includeApis;
        return this;
    }

    public BlobRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public BlobMetrics setRetentionPolicy(BlobRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "BlobMetrics" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeBooleanElement("Enabled", this.enabled);
        xmlWriter.writeBooleanElement("IncludeAPIs", this.includeApis);
        xmlWriter.writeXml((XmlSerializable)this.retentionPolicy, "RetentionPolicy");
        return xmlWriter.writeEndElement();
    }

    public static BlobMetrics fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobMetrics.fromXml(xmlReader, null);
    }

    public static BlobMetrics fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "BlobMetrics" : rootElementName;
        return (BlobMetrics)xmlReader.readObject(finalRootElementName, reader -> {
            BlobMetrics deserializedBlobMetrics = new BlobMetrics();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedBlobMetrics.version = reader.getStringElement();
                    continue;
                }
                if ("Enabled".equals(elementName.getLocalPart())) {
                    deserializedBlobMetrics.enabled = reader.getBooleanElement();
                    continue;
                }
                if ("IncludeAPIs".equals(elementName.getLocalPart())) {
                    deserializedBlobMetrics.includeApis = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("RetentionPolicy".equals(elementName.getLocalPart())) {
                    deserializedBlobMetrics.retentionPolicy = BlobRetentionPolicy.fromXml(reader, "RetentionPolicy");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobMetrics;
        });
    }
}

