/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.druid.cli.CliHadoopIndexer;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.indexer.HadoopDruidDetermineConfigurationJob;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.HadoopDruidIndexerJob;
import org.apache.druid.indexer.HadoopIngestionSpec;
import org.apache.druid.indexer.JobHelper;
import org.apache.druid.indexer.path.MetadataStoreBasedUsedSegmentsRetriever;
import org.apache.druid.indexer.path.SegmentMetadataPublisher;
import org.apache.druid.indexer.path.UsedSegmentsRetriever;
import org.apache.druid.indexer.updater.MetadataStorageUpdaterJobSpec;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;

@Command(name="hadoop-indexer", description="Runs the batch Hadoop Druid Indexer, see https://druid.apache.org/docs/latest/Batch-ingestion.html for a description.")
public class CliInternalHadoopIndexer
extends GuiceRunnable {
    private static final Logger log = new Logger(CliHadoopIndexer.class);
    @Arguments(description="A JSON object or the path to a file that contains a JSON object")
    @Required
    private String argumentSpec;
    private HadoopDruidIndexerConfig config;

    public CliInternalHadoopIndexer() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of(binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/internal-hadoop-indexer");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
            MetadataStorageUpdaterJobSpec metadataSpec = this.getHadoopDruidIndexerConfig().getSchema().getIOConfig().getMetadataUpdateSpec();
            binder.bind((TypeLiteral)new TypeLiteral<Supplier<MetadataStorageConnectorConfig>>(){}).toInstance((Object)metadataSpec);
            binder.bind(MetadataStorageTablesConfig.class).toInstance((Object)metadataSpec.getMetadataStorageTablesConfig());
            binder.bind(IndexerMetadataStorageCoordinator.class).to(IndexerSQLMetadataStorageCoordinator.class).in(LazySingleton.class);
        });
    }

    @Override
    public void run() {
        try {
            Injector injector = this.makeInjector();
            this.config = this.getHadoopDruidIndexerConfig();
            MetadataStorageUpdaterJobSpec metadataSpec = this.config.getSchema().getIOConfig().getMetadataUpdateSpec();
            Preconditions.checkNotNull((Object)metadataSpec.getType(), (Object)"type in metadataUpdateSpec must not be null");
            ((Properties)injector.getInstance(Properties.class)).setProperty("druid.metadata.storage.type", metadataSpec.getType());
            IndexerMetadataStorageCoordinator storageCoordinator = (IndexerMetadataStorageCoordinator)injector.getInstance(IndexerMetadataStorageCoordinator.class);
            HadoopIngestionSpec.updateSegmentListIfDatasourcePathSpecIsUsed((HadoopIngestionSpec)this.config.getSchema(), (ObjectMapper)HadoopDruidIndexerConfig.JSON_MAPPER, (UsedSegmentsRetriever)new MetadataStoreBasedUsedSegmentsRetriever(storageCoordinator));
            ArrayList<Object> jobs = new ArrayList<Object>();
            HadoopDruidIndexerJob indexerJob = new HadoopDruidIndexerJob(this.config, new SegmentMetadataPublisher(storageCoordinator));
            jobs.add(new HadoopDruidDetermineConfigurationJob(this.config));
            jobs.add(indexerJob);
            boolean jobsSucceeded = JobHelper.runJobs(jobs);
            JobHelper.renameIndexFilesForSegments((HadoopIngestionSpec)this.config.getSchema(), (List)indexerJob.getPublishedSegmentAndIndexZipFilePaths());
            JobHelper.maybeDeleteIntermediatePath((boolean)jobsSucceeded, (HadoopIngestionSpec)this.config.getSchema());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HadoopDruidIndexerConfig getHadoopDruidIndexerConfig() {
        block7: {
            if (this.config == null) {
                try {
                    if (this.argumentSpec.startsWith("{")) {
                        this.config = HadoopDruidIndexerConfig.fromString((String)this.argumentSpec);
                        break block7;
                    }
                    File localConfigFile = null;
                    try {
                        URI argumentSpecUri = new URI(this.argumentSpec);
                        String argumentSpecScheme = argumentSpecUri.getScheme();
                        if (argumentSpecScheme == null || "file".equals(argumentSpecScheme)) {
                            localConfigFile = new File(argumentSpecUri.getPath());
                        }
                    }
                    catch (URISyntaxException e) {
                        localConfigFile = new File(this.argumentSpec);
                    }
                    this.config = localConfigFile != null ? HadoopDruidIndexerConfig.fromFile((File)localConfigFile) : HadoopDruidIndexerConfig.fromDistributedFileSystem((String)this.argumentSpec);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.config;
    }
}

