/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.GetSubnetCidrReservationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetSubnetCidrReservationsRequestMarshaller
implements Marshaller<Request<GetSubnetCidrReservationsRequest>, GetSubnetCidrReservationsRequest> {
    public Request<GetSubnetCidrReservationsRequest> marshall(GetSubnetCidrReservationsRequest getSubnetCidrReservationsRequest) {
        if (getSubnetCidrReservationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSubnetCidrReservationsRequest, "AmazonEC2");
        request.addParameter("Action", "GetSubnetCidrReservations");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList getSubnetCidrReservationsRequestFiltersList = (SdkInternalList)getSubnetCidrReservationsRequest.getFilters();
        if (!getSubnetCidrReservationsRequestFiltersList.isEmpty() || !getSubnetCidrReservationsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter getSubnetCidrReservationsRequestFiltersListValue : getSubnetCidrReservationsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (getSubnetCidrReservationsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)getSubnetCidrReservationsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)getSubnetCidrReservationsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (getSubnetCidrReservationsRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)getSubnetCidrReservationsRequest.getSubnetId()));
        }
        if (getSubnetCidrReservationsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)getSubnetCidrReservationsRequest.getNextToken()));
        }
        if (getSubnetCidrReservationsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)getSubnetCidrReservationsRequest.getMaxResults()));
        }
        return request;
    }
}

