/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateFluent;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ContainerUser;
import io.fabric8.kubernetes.api.model.ContainerUserBuilder;
import io.fabric8.kubernetes.api.model.ContainerUserFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.ResourceStatus;
import io.fabric8.kubernetes.api.model.ResourceStatusBuilder;
import io.fabric8.kubernetes.api.model.ResourceStatusFluent;
import io.fabric8.kubernetes.api.model.VolumeMountStatus;
import io.fabric8.kubernetes.api.model.VolumeMountStatusBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ContainerStatusFluent<A extends ContainerStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Quantity> allocatedResources;
    private ArrayList<ResourceStatusBuilder> allocatedResourcesStatus = new ArrayList();
    private String containerID;
    private String image;
    private String imageID;
    private ContainerStateBuilder lastState;
    private String name;
    private Boolean ready;
    private ResourceRequirementsBuilder resources;
    private Integer restartCount;
    private Boolean started;
    private ContainerStateBuilder state;
    private String stopSignal;
    private ContainerUserBuilder user;
    private ArrayList<VolumeMountStatusBuilder> volumeMounts = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ContainerStatusFluent() {
    }

    public ContainerStatusFluent(ContainerStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ContainerStatus instance) {
        ContainerStatus containerStatus = instance = instance != null ? instance : new ContainerStatus();
        if (instance != null) {
            this.withAllocatedResources(instance.getAllocatedResources());
            this.withAllocatedResourcesStatus(instance.getAllocatedResourcesStatus());
            this.withContainerID(instance.getContainerID());
            this.withImage(instance.getImage());
            this.withImageID(instance.getImageID());
            this.withLastState(instance.getLastState());
            this.withName(instance.getName());
            this.withReady(instance.getReady());
            this.withResources(instance.getResources());
            this.withRestartCount(instance.getRestartCount());
            this.withStarted(instance.getStarted());
            this.withState(instance.getState());
            this.withStopSignal(instance.getStopSignal());
            this.withUser(instance.getUser());
            this.withVolumeMounts(instance.getVolumeMounts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAllocatedResources(String key, Quantity value) {
        if (this.allocatedResources == null && key != null && value != null) {
            this.allocatedResources = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.allocatedResources.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAllocatedResources(Map<String, Quantity> map) {
        if (this.allocatedResources == null && map != null) {
            this.allocatedResources = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.allocatedResources.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAllocatedResources(String key) {
        if (this.allocatedResources == null) {
            return (A)((Object)this);
        }
        if (key != null && this.allocatedResources != null) {
            this.allocatedResources.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAllocatedResources(Map<String, Quantity> map) {
        if (this.allocatedResources == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.allocatedResources == null) continue;
                this.allocatedResources.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Quantity> getAllocatedResources() {
        return this.allocatedResources;
    }

    public <K, V> A withAllocatedResources(Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources == null ? null : new LinkedHashMap<String, Quantity>(allocatedResources);
        return (A)((Object)this);
    }

    public boolean hasAllocatedResources() {
        return this.allocatedResources != null;
    }

    public A addToAllocatedResourcesStatus(int index, ResourceStatus item) {
        if (this.allocatedResourcesStatus == null) {
            this.allocatedResourcesStatus = new ArrayList();
        }
        ResourceStatusBuilder builder = new ResourceStatusBuilder(item);
        if (index < 0 || index >= this.allocatedResourcesStatus.size()) {
            this._visitables.get((Object)"allocatedResourcesStatus").add(builder);
            this.allocatedResourcesStatus.add(builder);
        } else {
            this._visitables.get((Object)"allocatedResourcesStatus").add(builder);
            this.allocatedResourcesStatus.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAllocatedResourcesStatus(int index, ResourceStatus item) {
        if (this.allocatedResourcesStatus == null) {
            this.allocatedResourcesStatus = new ArrayList();
        }
        ResourceStatusBuilder builder = new ResourceStatusBuilder(item);
        if (index < 0 || index >= this.allocatedResourcesStatus.size()) {
            this._visitables.get((Object)"allocatedResourcesStatus").add(builder);
            this.allocatedResourcesStatus.add(builder);
        } else {
            this._visitables.get((Object)"allocatedResourcesStatus").add(builder);
            this.allocatedResourcesStatus.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAllocatedResourcesStatus(ResourceStatus ... items) {
        if (this.allocatedResourcesStatus == null) {
            this.allocatedResourcesStatus = new ArrayList();
        }
        for (ResourceStatus item : items) {
            ResourceStatusBuilder builder = new ResourceStatusBuilder(item);
            this._visitables.get((Object)"allocatedResourcesStatus").add(builder);
            this.allocatedResourcesStatus.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAllocatedResourcesStatus(Collection<ResourceStatus> items) {
        if (this.allocatedResourcesStatus == null) {
            this.allocatedResourcesStatus = new ArrayList();
        }
        for (ResourceStatus item : items) {
            ResourceStatusBuilder builder = new ResourceStatusBuilder(item);
            this._visitables.get((Object)"allocatedResourcesStatus").add(builder);
            this.allocatedResourcesStatus.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAllocatedResourcesStatus(ResourceStatus ... items) {
        if (this.allocatedResourcesStatus == null) {
            return (A)((Object)this);
        }
        for (ResourceStatus item : items) {
            ResourceStatusBuilder builder = new ResourceStatusBuilder(item);
            this._visitables.get((Object)"allocatedResourcesStatus").remove((Object)builder);
            this.allocatedResourcesStatus.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAllocatedResourcesStatus(Collection<ResourceStatus> items) {
        if (this.allocatedResourcesStatus == null) {
            return (A)((Object)this);
        }
        for (ResourceStatus item : items) {
            ResourceStatusBuilder builder = new ResourceStatusBuilder(item);
            this._visitables.get((Object)"allocatedResourcesStatus").remove((Object)builder);
            this.allocatedResourcesStatus.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAllocatedResourcesStatus(Predicate<ResourceStatusBuilder> predicate) {
        if (this.allocatedResourcesStatus == null) {
            return (A)((Object)this);
        }
        Iterator<ResourceStatusBuilder> each = this.allocatedResourcesStatus.iterator();
        List visitables = this._visitables.get((Object)"allocatedResourcesStatus");
        while (each.hasNext()) {
            ResourceStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ResourceStatus> buildAllocatedResourcesStatus() {
        return this.allocatedResourcesStatus != null ? ContainerStatusFluent.build(this.allocatedResourcesStatus) : null;
    }

    public ResourceStatus buildAllocatedResourcesStatus(int index) {
        return this.allocatedResourcesStatus.get(index).build();
    }

    public ResourceStatus buildFirstAllocatedResourcesStatus() {
        return this.allocatedResourcesStatus.get(0).build();
    }

    public ResourceStatus buildLastAllocatedResourcesStatus() {
        return this.allocatedResourcesStatus.get(this.allocatedResourcesStatus.size() - 1).build();
    }

    public ResourceStatus buildMatchingAllocatedResourcesStatus(Predicate<ResourceStatusBuilder> predicate) {
        for (ResourceStatusBuilder item : this.allocatedResourcesStatus) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAllocatedResourcesStatus(Predicate<ResourceStatusBuilder> predicate) {
        for (ResourceStatusBuilder item : this.allocatedResourcesStatus) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllocatedResourcesStatus(List<ResourceStatus> allocatedResourcesStatus) {
        if (this.allocatedResourcesStatus != null) {
            this._visitables.get((Object)"allocatedResourcesStatus").clear();
        }
        if (allocatedResourcesStatus != null) {
            this.allocatedResourcesStatus = new ArrayList();
            for (ResourceStatus item : allocatedResourcesStatus) {
                this.addToAllocatedResourcesStatus(item);
            }
        } else {
            this.allocatedResourcesStatus = null;
        }
        return (A)((Object)this);
    }

    public A withAllocatedResourcesStatus(ResourceStatus ... allocatedResourcesStatus) {
        if (this.allocatedResourcesStatus != null) {
            this.allocatedResourcesStatus.clear();
            this._visitables.remove((Object)"allocatedResourcesStatus");
        }
        if (allocatedResourcesStatus != null) {
            for (ResourceStatus item : allocatedResourcesStatus) {
                this.addToAllocatedResourcesStatus(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAllocatedResourcesStatus() {
        return this.allocatedResourcesStatus != null && !this.allocatedResourcesStatus.isEmpty();
    }

    public AllocatedResourcesStatusNested<A> addNewAllocatedResourcesStatus() {
        return new AllocatedResourcesStatusNested(-1, null);
    }

    public AllocatedResourcesStatusNested<A> addNewAllocatedResourcesStatusLike(ResourceStatus item) {
        return new AllocatedResourcesStatusNested(-1, item);
    }

    public AllocatedResourcesStatusNested<A> setNewAllocatedResourcesStatusLike(int index, ResourceStatus item) {
        return new AllocatedResourcesStatusNested(index, item);
    }

    public AllocatedResourcesStatusNested<A> editAllocatedResourcesStatus(int index) {
        if (this.allocatedResourcesStatus.size() <= index) {
            throw new RuntimeException("Can't edit allocatedResourcesStatus. Index exceeds size.");
        }
        return this.setNewAllocatedResourcesStatusLike(index, this.buildAllocatedResourcesStatus(index));
    }

    public AllocatedResourcesStatusNested<A> editFirstAllocatedResourcesStatus() {
        if (this.allocatedResourcesStatus.size() == 0) {
            throw new RuntimeException("Can't edit first allocatedResourcesStatus. The list is empty.");
        }
        return this.setNewAllocatedResourcesStatusLike(0, this.buildAllocatedResourcesStatus(0));
    }

    public AllocatedResourcesStatusNested<A> editLastAllocatedResourcesStatus() {
        int index = this.allocatedResourcesStatus.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allocatedResourcesStatus. The list is empty.");
        }
        return this.setNewAllocatedResourcesStatusLike(index, this.buildAllocatedResourcesStatus(index));
    }

    public AllocatedResourcesStatusNested<A> editMatchingAllocatedResourcesStatus(Predicate<ResourceStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allocatedResourcesStatus.size(); ++i) {
            if (!predicate.test(this.allocatedResourcesStatus.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allocatedResourcesStatus. No match found.");
        }
        return this.setNewAllocatedResourcesStatusLike(index, this.buildAllocatedResourcesStatus(index));
    }

    public String getContainerID() {
        return this.containerID;
    }

    public A withContainerID(String containerID) {
        this.containerID = containerID;
        return (A)((Object)this);
    }

    public boolean hasContainerID() {
        return this.containerID != null;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getImageID() {
        return this.imageID;
    }

    public A withImageID(String imageID) {
        this.imageID = imageID;
        return (A)((Object)this);
    }

    public boolean hasImageID() {
        return this.imageID != null;
    }

    public ContainerState buildLastState() {
        return this.lastState != null ? this.lastState.build() : null;
    }

    public A withLastState(ContainerState lastState) {
        this._visitables.remove((Object)"lastState");
        if (lastState != null) {
            this.lastState = new ContainerStateBuilder(lastState);
            this._visitables.get((Object)"lastState").add(this.lastState);
        } else {
            this.lastState = null;
            this._visitables.get((Object)"lastState").remove((Object)this.lastState);
        }
        return (A)((Object)this);
    }

    public boolean hasLastState() {
        return this.lastState != null;
    }

    public LastStateNested<A> withNewLastState() {
        return new LastStateNested(null);
    }

    public LastStateNested<A> withNewLastStateLike(ContainerState item) {
        return new LastStateNested(item);
    }

    public LastStateNested<A> editLastState() {
        return this.withNewLastStateLike(Optional.ofNullable(this.buildLastState()).orElse(null));
    }

    public LastStateNested<A> editOrNewLastState() {
        return this.withNewLastStateLike(Optional.ofNullable(this.buildLastState()).orElse(new ContainerStateBuilder().build()));
    }

    public LastStateNested<A> editOrNewLastStateLike(ContainerState item) {
        return this.withNewLastStateLike(Optional.ofNullable(this.buildLastState()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Boolean getReady() {
        return this.ready;
    }

    public A withReady(Boolean ready) {
        this.ready = ready;
        return (A)((Object)this);
    }

    public boolean hasReady() {
        return this.ready != null;
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public Integer getRestartCount() {
        return this.restartCount;
    }

    public A withRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return (A)((Object)this);
    }

    public boolean hasRestartCount() {
        return this.restartCount != null;
    }

    public Boolean getStarted() {
        return this.started;
    }

    public A withStarted(Boolean started) {
        this.started = started;
        return (A)((Object)this);
    }

    public boolean hasStarted() {
        return this.started != null;
    }

    public ContainerState buildState() {
        return this.state != null ? this.state.build() : null;
    }

    public A withState(ContainerState state) {
        this._visitables.remove((Object)"state");
        if (state != null) {
            this.state = new ContainerStateBuilder(state);
            this._visitables.get((Object)"state").add(this.state);
        } else {
            this.state = null;
            this._visitables.get((Object)"state").remove((Object)this.state);
        }
        return (A)((Object)this);
    }

    public boolean hasState() {
        return this.state != null;
    }

    public StateNested<A> withNewState() {
        return new StateNested(null);
    }

    public StateNested<A> withNewStateLike(ContainerState item) {
        return new StateNested(item);
    }

    public StateNested<A> editState() {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(null));
    }

    public StateNested<A> editOrNewState() {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(new ContainerStateBuilder().build()));
    }

    public StateNested<A> editOrNewStateLike(ContainerState item) {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(item));
    }

    public String getStopSignal() {
        return this.stopSignal;
    }

    public A withStopSignal(String stopSignal) {
        this.stopSignal = stopSignal;
        return (A)((Object)this);
    }

    public boolean hasStopSignal() {
        return this.stopSignal != null;
    }

    public ContainerUser buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    public A withUser(ContainerUser user) {
        this._visitables.remove((Object)"user");
        if (user != null) {
            this.user = new ContainerUserBuilder(user);
            this._visitables.get((Object)"user").add(this.user);
        } else {
            this.user = null;
            this._visitables.get((Object)"user").remove((Object)this.user);
        }
        return (A)((Object)this);
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public UserNested<A> withNewUser() {
        return new UserNested(null);
    }

    public UserNested<A> withNewUserLike(ContainerUser item) {
        return new UserNested(item);
    }

    public UserNested<A> editUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(null));
    }

    public UserNested<A> editOrNewUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(new ContainerUserBuilder().build()));
    }

    public UserNested<A> editOrNewUserLike(ContainerUser item) {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(item));
    }

    public A addToVolumeMounts(int index, VolumeMountStatus item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        VolumeMountStatusBuilder builder = new VolumeMountStatusBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumeMounts(int index, VolumeMountStatus item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        VolumeMountStatusBuilder builder = new VolumeMountStatusBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumeMounts(VolumeMountStatus ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (VolumeMountStatus item : items) {
            VolumeMountStatusBuilder builder = new VolumeMountStatusBuilder(item);
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumeMounts(Collection<VolumeMountStatus> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (VolumeMountStatus item : items) {
            VolumeMountStatusBuilder builder = new VolumeMountStatusBuilder(item);
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeMounts(VolumeMountStatus ... items) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        for (VolumeMountStatus item : items) {
            VolumeMountStatusBuilder builder = new VolumeMountStatusBuilder(item);
            this._visitables.get((Object)"volumeMounts").remove((Object)builder);
            this.volumeMounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMountStatus> items) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        for (VolumeMountStatus item : items) {
            VolumeMountStatusBuilder builder = new VolumeMountStatusBuilder(item);
            this._visitables.get((Object)"volumeMounts").remove((Object)builder);
            this.volumeMounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumeMounts(Predicate<VolumeMountStatusBuilder> predicate) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        Iterator<VolumeMountStatusBuilder> each = this.volumeMounts.iterator();
        List visitables = this._visitables.get((Object)"volumeMounts");
        while (each.hasNext()) {
            VolumeMountStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<VolumeMountStatus> buildVolumeMounts() {
        return this.volumeMounts != null ? ContainerStatusFluent.build(this.volumeMounts) : null;
    }

    public VolumeMountStatus buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    public VolumeMountStatus buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    public VolumeMountStatus buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    public VolumeMountStatus buildMatchingVolumeMount(Predicate<VolumeMountStatusBuilder> predicate) {
        for (VolumeMountStatusBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolumeMount(Predicate<VolumeMountStatusBuilder> predicate) {
        for (VolumeMountStatusBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeMounts(List<VolumeMountStatus> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get((Object)"volumeMounts").clear();
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList();
            for (VolumeMountStatus item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)((Object)this);
    }

    public A withVolumeMounts(VolumeMountStatus ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
            this._visitables.remove((Object)"volumeMounts");
        }
        if (volumeMounts != null) {
            for (VolumeMountStatus item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    public A addNewVolumeMount(String mountPath, String name, Boolean readOnly, String recursiveReadOnly) {
        return this.addToVolumeMounts(new VolumeMountStatus(mountPath, name, readOnly, recursiveReadOnly));
    }

    public VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNested(-1, null);
    }

    public VolumeMountsNested<A> addNewVolumeMountLike(VolumeMountStatus item) {
        return new VolumeMountsNested(-1, item);
    }

    public VolumeMountsNested<A> setNewVolumeMountLike(int index, VolumeMountStatus item) {
        return new VolumeMountsNested(index, item);
    }

    public VolumeMountsNested<A> editVolumeMount(int index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    public VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.test(this.volumeMounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStatusFluent that = (ContainerStatusFluent)((Object)o);
        if (!Objects.equals(this.allocatedResources, that.allocatedResources)) {
            return false;
        }
        if (!Objects.equals(this.allocatedResourcesStatus, that.allocatedResourcesStatus)) {
            return false;
        }
        if (!Objects.equals(this.containerID, that.containerID)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.imageID, that.imageID)) {
            return false;
        }
        if (!Objects.equals((Object)this.lastState, (Object)that.lastState)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.ready, that.ready)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        if (!Objects.equals(this.restartCount, that.restartCount)) {
            return false;
        }
        if (!Objects.equals(this.started, that.started)) {
            return false;
        }
        if (!Objects.equals((Object)this.state, (Object)that.state)) {
            return false;
        }
        if (!Objects.equals(this.stopSignal, that.stopSignal)) {
            return false;
        }
        if (!Objects.equals((Object)this.user, (Object)that.user)) {
            return false;
        }
        if (!Objects.equals(this.volumeMounts, that.volumeMounts)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allocatedResources, this.allocatedResourcesStatus, this.containerID, this.image, this.imageID, this.lastState, this.name, this.ready, this.resources, this.restartCount, this.started, this.state, this.stopSignal, this.user, this.volumeMounts, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocatedResources != null && !this.allocatedResources.isEmpty()) {
            sb.append("allocatedResources:");
            sb.append(String.valueOf(this.allocatedResources) + ",");
        }
        if (this.allocatedResourcesStatus != null && !this.allocatedResourcesStatus.isEmpty()) {
            sb.append("allocatedResourcesStatus:");
            sb.append(String.valueOf(this.allocatedResourcesStatus) + ",");
        }
        if (this.containerID != null) {
            sb.append("containerID:");
            sb.append(this.containerID + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.imageID != null) {
            sb.append("imageID:");
            sb.append(this.imageID + ",");
        }
        if (this.lastState != null) {
            sb.append("lastState:");
            sb.append(String.valueOf((Object)this.lastState) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.ready != null) {
            sb.append("ready:");
            sb.append(this.ready + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(String.valueOf((Object)this.resources) + ",");
        }
        if (this.restartCount != null) {
            sb.append("restartCount:");
            sb.append(this.restartCount + ",");
        }
        if (this.started != null) {
            sb.append("started:");
            sb.append(this.started + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(String.valueOf((Object)this.state) + ",");
        }
        if (this.stopSignal != null) {
            sb.append("stopSignal:");
            sb.append(this.stopSignal + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(String.valueOf((Object)this.user) + ",");
        }
        if (this.volumeMounts != null && !this.volumeMounts.isEmpty()) {
            sb.append("volumeMounts:");
            sb.append(String.valueOf(this.volumeMounts) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReady() {
        return this.withReady(true);
    }

    public A withStarted() {
        return this.withStarted(true);
    }

    public class VolumeMountsNested<N>
    extends VolumeMountStatusFluent<VolumeMountsNested<N>>
    implements Nested<N> {
        VolumeMountStatusBuilder builder;
        int index;

        VolumeMountsNested(int index, VolumeMountStatus item) {
            this.index = index;
            this.builder = new VolumeMountStatusBuilder(this, item);
        }

        public N and() {
            return (N)ContainerStatusFluent.this.setToVolumeMounts(this.index, this.builder.build());
        }

        public N endVolumeMount() {
            return this.and();
        }
    }

    public class UserNested<N>
    extends ContainerUserFluent<UserNested<N>>
    implements Nested<N> {
        ContainerUserBuilder builder;

        UserNested(ContainerUser item) {
            this.builder = new ContainerUserBuilder(this, item);
        }

        public N and() {
            return (N)ContainerStatusFluent.this.withUser(this.builder.build());
        }

        public N endUser() {
            return this.and();
        }
    }

    public class StateNested<N>
    extends ContainerStateFluent<StateNested<N>>
    implements Nested<N> {
        ContainerStateBuilder builder;

        StateNested(ContainerState item) {
            this.builder = new ContainerStateBuilder(this, item);
        }

        public N and() {
            return (N)ContainerStatusFluent.this.withState(this.builder.build());
        }

        public N endState() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        public N and() {
            return (N)ContainerStatusFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class LastStateNested<N>
    extends ContainerStateFluent<LastStateNested<N>>
    implements Nested<N> {
        ContainerStateBuilder builder;

        LastStateNested(ContainerState item) {
            this.builder = new ContainerStateBuilder(this, item);
        }

        public N and() {
            return (N)ContainerStatusFluent.this.withLastState(this.builder.build());
        }

        public N endLastState() {
            return this.and();
        }
    }

    public class AllocatedResourcesStatusNested<N>
    extends ResourceStatusFluent<AllocatedResourcesStatusNested<N>>
    implements Nested<N> {
        ResourceStatusBuilder builder;
        int index;

        AllocatedResourcesStatusNested(int index, ResourceStatus item) {
            this.index = index;
            this.builder = new ResourceStatusBuilder(this, item);
        }

        public N and() {
            return (N)ContainerStatusFluent.this.setToAllocatedResourcesStatus(this.index, this.builder.build());
        }

        public N endAllocatedResourcesStatus() {
            return this.and();
        }
    }
}

