/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.rpc.indexing.SegmentUpdateResponse;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.CoordinatorSegmentMetadataCache;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.compaction.CompactionRunSimulator;
import org.apache.druid.server.compaction.CompactionSimulateResult;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.CloneStatusManager;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.MetadataManager;
import org.apache.druid.server.coordinator.balancer.BalancerStrategyFactory;
import org.apache.druid.server.coordinator.config.CoordinatorKillConfigs;
import org.apache.druid.server.coordinator.config.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.config.KillUnusedSegmentsConfig;
import org.apache.druid.server.coordinator.duty.BalanceSegments;
import org.apache.druid.server.coordinator.duty.CloneHistoricals;
import org.apache.druid.server.coordinator.duty.CompactSegments;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDutyGroup;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDutyGroups;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.duty.CoordinatorDutyGroup;
import org.apache.druid.server.coordinator.duty.DutyGroupStatus;
import org.apache.druid.server.coordinator.duty.KillAuditLog;
import org.apache.druid.server.coordinator.duty.KillCompactionConfig;
import org.apache.druid.server.coordinator.duty.KillDatasourceMetadata;
import org.apache.druid.server.coordinator.duty.KillRules;
import org.apache.druid.server.coordinator.duty.KillStalePendingSegments;
import org.apache.druid.server.coordinator.duty.KillSupervisors;
import org.apache.druid.server.coordinator.duty.KillUnreferencedSegmentSchema;
import org.apache.druid.server.coordinator.duty.KillUnusedSegments;
import org.apache.druid.server.coordinator.duty.MarkEternityTombstonesAsUnused;
import org.apache.druid.server.coordinator.duty.MarkOvershadowedSegmentsAsUnused;
import org.apache.druid.server.coordinator.duty.MetadataAction;
import org.apache.druid.server.coordinator.duty.PrepareBalancerAndLoadQueues;
import org.apache.druid.server.coordinator.duty.RunRules;
import org.apache.druid.server.coordinator.duty.UnloadUnusedSegments;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.LoadQueueTaskMaster;
import org.apache.druid.server.coordinator.loading.SegmentLoadQueueManager;
import org.apache.druid.server.coordinator.loading.SegmentReplicaCount;
import org.apache.druid.server.coordinator.loading.SegmentReplicationStatus;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.CoordinatorStat;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.server.http.CoordinatorDynamicConfigSyncer;
import org.apache.druid.server.http.SegmentsToUpdateFilter;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Duration;

@ManageLifecycle
public class DruidCoordinator {
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinator.class);
    private final Object lock = new Object();
    private final DruidCoordinatorConfig config;
    private final MetadataManager metadataManager;
    private final ServerInventoryView serverInventoryView;
    private final ServiceEmitter emitter;
    private final OverlordClient overlordClient;
    private final ScheduledExecutorFactory executorFactory;
    private final List<DutiesRunnable> dutiesRunnables = new ArrayList<DutiesRunnable>();
    private final LoadQueueTaskMaster taskMaster;
    private final SegmentLoadQueueManager loadQueueManager;
    private final ServiceAnnouncer serviceAnnouncer;
    private final DruidNode self;
    private final CoordinatorCustomDutyGroups customDutyGroups;
    private final BalancerStrategyFactory balancerStrategyFactory;
    private final LookupCoordinatorManager lookupCoordinatorManager;
    private final DruidLeaderSelector coordLeaderSelector;
    private final CompactionStatusTracker compactionStatusTracker;
    private final CompactSegments compactSegments;
    @Nullable
    private final CoordinatorSegmentMetadataCache coordinatorSegmentMetadataCache;
    private final CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig;
    private final CoordinatorDynamicConfigSyncer coordinatorDynamicConfigSyncer;
    private final CloneStatusManager cloneStatusManager;
    private volatile boolean started = false;
    private volatile SegmentReplicationStatus segmentReplicationStatus = null;
    private volatile Set<DataSegment> broadcastSegments = null;
    private static final String HISTORICAL_MANAGEMENT_DUTIES_DUTY_GROUP = "HistoricalManagementDuties";
    private static final String METADATA_STORE_MANAGEMENT_DUTIES_DUTY_GROUP = "MetadataStoreManagementDuties";
    private static final String INDEXING_SERVICE_DUTIES_DUTY_GROUP = "IndexingServiceDuties";
    private static final String COMPACT_SEGMENTS_DUTIES_DUTY_GROUP = "CompactSegmentsDuties";

    @Inject
    public DruidCoordinator(DruidCoordinatorConfig config, MetadataManager metadataManager, ServerInventoryView serverInventoryView, ServiceEmitter emitter, ScheduledExecutorFactory scheduledExecutorFactory, OverlordClient overlordClient, LoadQueueTaskMaster taskMaster, SegmentLoadQueueManager loadQueueManager, ServiceAnnouncer serviceAnnouncer, @Self DruidNode self, CoordinatorCustomDutyGroups customDutyGroups, LookupCoordinatorManager lookupCoordinatorManager, @Coordinator DruidLeaderSelector coordLeaderSelector, @Nullable CoordinatorSegmentMetadataCache coordinatorSegmentMetadataCache, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig, CompactionStatusTracker compactionStatusTracker, CoordinatorDynamicConfigSyncer coordinatorDynamicConfigSyncer, CloneStatusManager cloneStatusManager) {
        this.config = config;
        this.metadataManager = metadataManager;
        this.serverInventoryView = serverInventoryView;
        this.emitter = emitter;
        this.overlordClient = overlordClient;
        this.taskMaster = taskMaster;
        this.serviceAnnouncer = serviceAnnouncer;
        this.self = self;
        this.customDutyGroups = customDutyGroups;
        this.executorFactory = scheduledExecutorFactory;
        this.balancerStrategyFactory = config.getBalancerStrategyFactory();
        this.lookupCoordinatorManager = lookupCoordinatorManager;
        this.coordLeaderSelector = coordLeaderSelector;
        this.compactionStatusTracker = compactionStatusTracker;
        this.loadQueueManager = loadQueueManager;
        this.coordinatorSegmentMetadataCache = coordinatorSegmentMetadataCache;
        this.centralizedDatasourceSchemaConfig = centralizedDatasourceSchemaConfig;
        this.coordinatorDynamicConfigSyncer = coordinatorDynamicConfigSyncer;
        this.cloneStatusManager = cloneStatusManager;
        this.compactSegments = this.initializeCompactSegmentsDuty(this.compactionStatusTracker);
    }

    public boolean isLeader() {
        return this.coordLeaderSelector.isLeader();
    }

    public Map<String, LoadQueuePeon> getLoadManagementPeons() {
        return this.taskMaster.getAllPeons();
    }

    public Map<String, Object2LongMap<String>> getTierToDatasourceToUnderReplicatedCount(boolean useClusterView) {
        Iterable<DataSegment> dataSegments = this.metadataManager.iterateAllUsedSegments();
        return this.computeUnderReplicated(dataSegments, useClusterView);
    }

    public Map<String, Object2LongMap<String>> getTierToDatasourceToUnderReplicatedCount(Iterable<DataSegment> dataSegments, boolean useClusterView) {
        return this.computeUnderReplicated(dataSegments, useClusterView);
    }

    public Object2IntMap<String> getDatasourceToUnavailableSegmentCount() {
        if (this.segmentReplicationStatus == null) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap datasourceToUnavailableSegments = new Object2IntOpenHashMap();
        Iterable<DataSegment> dataSegments = this.metadataManager.iterateAllUsedSegments();
        for (DataSegment segment : dataSegments) {
            SegmentReplicaCount replicaCount = this.segmentReplicationStatus.getReplicaCountsInCluster(segment.getId());
            if (replicaCount != null && (replicaCount.totalLoaded() > 0 || replicaCount.required() == 0)) {
                datasourceToUnavailableSegments.addTo((Object)segment.getDataSource(), 0);
                continue;
            }
            datasourceToUnavailableSegments.addTo((Object)segment.getDataSource(), 1);
        }
        return datasourceToUnavailableSegments;
    }

    public Object2IntMap<String> getDatasourceToDeepStorageQueryOnlySegmentCount() {
        if (this.segmentReplicationStatus == null) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap datasourceToDeepStorageOnlySegments = new Object2IntOpenHashMap();
        Iterable<DataSegment> dataSegments = this.metadataManager.iterateAllUsedSegments();
        for (DataSegment segment : dataSegments) {
            SegmentReplicaCount replicaCount = this.segmentReplicationStatus.getReplicaCountsInCluster(segment.getId());
            if (replicaCount == null || replicaCount.totalLoaded() != 0 || replicaCount.required() != 0) continue;
            datasourceToDeepStorageOnlySegments.addTo((Object)segment.getDataSource(), 1);
        }
        return datasourceToDeepStorageOnlySegments;
    }

    public Map<String, Double> getDatasourceToLoadStatus() {
        HashMap<String, Double> loadStatus = new HashMap<String, Double>();
        DataSourcesSnapshot snapshot = this.metadataManager.segments().getRecentDataSourcesSnapshot();
        for (ImmutableDruidDataSource dataSource : snapshot.getDataSourcesWithAllUsedSegments()) {
            HashSet segments = Sets.newHashSet(dataSource.getSegments());
            int numPublishedSegments = segments.size();
            for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
                DruidDataSource loadedView = druidServer.getDataSource(dataSource.getName());
                if (loadedView == null) continue;
                for (DataSegment serverSegment : loadedView.getSegments()) {
                    segments.remove(serverSegment);
                }
            }
            int numUnavailableSegments = segments.size();
            loadStatus.put(dataSource.getName(), (double)(numPublishedSegments - numUnavailableSegments) * 100.0 / (double)numPublishedSegments);
        }
        return loadStatus;
    }

    @Nullable
    public Set<DataSegment> getBroadcastSegments() {
        return this.broadcastSegments;
    }

    @Nullable
    public Integer getReplicationFactor(SegmentId segmentId) {
        if (this.segmentReplicationStatus == null) {
            return null;
        }
        SegmentReplicaCount replicaCountsInCluster = this.segmentReplicationStatus.getReplicaCountsInCluster(segmentId);
        return replicaCountsInCluster == null ? null : Integer.valueOf(replicaCountsInCluster.required());
    }

    @Nullable
    public AutoCompactionSnapshot getAutoCompactionSnapshotForDataSource(String dataSource) {
        return this.compactSegments.getAutoCompactionSnapshot(dataSource);
    }

    public Map<String, AutoCompactionSnapshot> getAutoCompactionSnapshot() {
        return this.compactSegments.getAutoCompactionSnapshot();
    }

    public CompactionSimulateResult simulateRunWithConfigUpdate(ClusterCompactionConfig updateRequest) {
        return new CompactionRunSimulator(this.compactionStatusTracker, this.overlordClient).simulateRunWithConfig(this.metadataManager.configs().getCurrentCompactionConfig().withClusterConfig(updateRequest), this.metadataManager.segments().getRecentDataSourcesSnapshot(), CompactionEngine.NATIVE);
    }

    public String getCurrentLeader() {
        return this.coordLeaderSelector.getCurrentLeader();
    }

    public List<DutyGroupStatus> getStatusOfDuties() {
        return this.dutiesRunnables.stream().map(r -> r.dutyGroup.getStatus()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.metadataManager.startCache();
            this.coordLeaderSelector.registerListener(new DruidLeaderSelector.Listener(){

                @Override
                public void becomeLeader() {
                    DruidCoordinator.this.becomeLeader();
                }

                @Override
                public void stopBeingLeader() {
                    DruidCoordinator.this.stopBeingLeader();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.coordLeaderSelector.unregisterListener();
            this.metadataManager.stopCache();
            this.started = false;
            this.stopAllDutyGroups();
        }
    }

    public void runCompactSegmentsDuty() {
        int startingLeaderCounter = this.coordLeaderSelector.localTerm();
        DutiesRunnable compactSegmentsDuty = new DutiesRunnable((List<CoordinatorDuty>)ImmutableList.of((Object)this.compactSegments), startingLeaderCounter, COMPACT_SEGMENTS_DUTIES_DUTY_GROUP, null);
        compactSegmentsDuty.run();
    }

    private Map<String, Object2LongMap<String>> computeUnderReplicated(Iterable<DataSegment> dataSegments, boolean computeUsingClusterView) {
        if (this.segmentReplicationStatus == null) {
            return Collections.emptyMap();
        }
        return this.segmentReplicationStatus.getTierToDatasourceToUnderReplicated(dataSegments, !computeUsingClusterView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void becomeLeader() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("I am the leader of the coordinators, all must bow! Starting coordination in [%s].", new Object[]{this.config.getCoordinatorStartDelay()});
            this.metadataManager.onLeaderStart();
            this.taskMaster.onLeaderStart();
            this.lookupCoordinatorManager.start();
            this.serviceAnnouncer.announce(this.self);
            if (this.coordinatorSegmentMetadataCache != null) {
                this.coordinatorSegmentMetadataCache.onLeaderStart();
            }
            this.coordinatorDynamicConfigSyncer.onLeaderStart();
            int startingLeaderCounter = this.coordLeaderSelector.localTerm();
            this.dutiesRunnables.add(new DutiesRunnable(this.makeHistoricalManagementDuties(), startingLeaderCounter, HISTORICAL_MANAGEMENT_DUTIES_DUTY_GROUP, this.config.getCoordinatorPeriod()));
            this.dutiesRunnables.add(new DutiesRunnable(this.makeIndexingServiceDuties(), startingLeaderCounter, INDEXING_SERVICE_DUTIES_DUTY_GROUP, this.config.getCoordinatorIndexingPeriod()));
            this.dutiesRunnables.add(new DutiesRunnable(this.makeMetadataStoreManagementDuties(), startingLeaderCounter, METADATA_STORE_MANAGEMENT_DUTIES_DUTY_GROUP, this.config.getCoordinatorMetadataStoreManagementPeriod()));
            for (CoordinatorCustomDutyGroup customDutyGroup : this.customDutyGroups.getCoordinatorCustomDutyGroups()) {
                this.dutiesRunnables.add(new DutiesRunnable(new ArrayList<CoordinatorDuty>(customDutyGroup.getCustomDutyList()), startingLeaderCounter, customDutyGroup.getName(), customDutyGroup.getPeriod()));
            }
            log.warn("Created [%d] duty groups. DUTY RUNS WILL NOT BE LOGGED. Use API '/druid/coordinator/v1/duties' to get current status.", new Object[]{this.dutiesRunnables.size()});
            for (DutiesRunnable dutiesRunnable : this.dutiesRunnables) {
                ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)dutiesRunnable.executor, (Duration)this.config.getCoordinatorStartDelay(), (Duration)dutiesRunnable.dutyGroup.getPeriod(), () -> {
                    if (this.coordLeaderSelector.isLeader() && startingLeaderCounter == this.coordLeaderSelector.localTerm()) {
                        dutiesRunnable.run();
                    }
                    if (this.coordLeaderSelector.isLeader() && startingLeaderCounter == this.coordLeaderSelector.localTerm()) {
                        return ScheduledExecutors.Signal.REPEAT;
                    }
                    return ScheduledExecutors.Signal.STOP;
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBeingLeader() {
        Object object = this.lock;
        synchronized (object) {
            log.info("I am no longer the leader...", new Object[0]);
            if (this.coordinatorSegmentMetadataCache != null) {
                this.coordinatorSegmentMetadataCache.onLeaderStop();
            }
            this.compactionStatusTracker.stop();
            this.taskMaster.onLeaderStop();
            this.coordinatorDynamicConfigSyncer.onLeaderStop();
            this.serviceAnnouncer.unannounce(this.self);
            this.lookupCoordinatorManager.stop();
            this.metadataManager.onLeaderStop();
            this.stopAllDutyGroups();
        }
    }

    @GuardedBy(value="lock")
    private void stopAllDutyGroups() {
        this.balancerStrategyFactory.stopExecutor();
        this.dutiesRunnables.forEach(group -> group.executor.shutdownNow());
        this.dutiesRunnables.clear();
    }

    private List<CoordinatorDuty> makeHistoricalManagementDuties() {
        MetadataAction.DeleteSegments deleteSegments = this::markSegmentsAsUnused;
        MetadataAction.GetDatasourceRules getRules = dataSource -> this.metadataManager.rules().getRulesWithDefault(dataSource);
        return ImmutableList.of((Object)new PrepareBalancerAndLoadQueues(this.taskMaster, this.loadQueueManager, this.balancerStrategyFactory, this.serverInventoryView), (Object)new RunRules(deleteSegments, getRules), (Object)new UpdateReplicationStatus(), (Object)new CollectSegmentStats(), (Object)new UnloadUnusedSegments(this.loadQueueManager, getRules), (Object)new MarkOvershadowedSegmentsAsUnused(deleteSegments), (Object)new MarkEternityTombstonesAsUnused(deleteSegments), (Object)new BalanceSegments(this.config.getCoordinatorPeriod()), (Object)new CloneHistoricals(this.loadQueueManager, this.cloneStatusManager), (Object)new CollectLoadQueueStats());
    }

    private List<CoordinatorDuty> makeIndexingServiceDuties() {
        ArrayList<CoordinatorDuty> duties = new ArrayList<CoordinatorDuty>();
        KillUnusedSegmentsConfig killUnusedConfig = this.config.getKillConfigs().unusedSegments(this.config.getCoordinatorIndexingPeriod());
        if (killUnusedConfig.isCleanupEnabled()) {
            duties.add(new KillUnusedSegments(this.metadataManager.indexer(), this.overlordClient, killUnusedConfig));
        }
        if (this.config.getKillConfigs().pendingSegments().isCleanupEnabled()) {
            duties.add(new KillStalePendingSegments(this.overlordClient));
        }
        if (this.getCompactSegmentsDutyFromCustomGroups().isEmpty()) {
            duties.add(this.compactSegments);
        }
        return ImmutableList.copyOf(duties);
    }

    private List<CoordinatorDuty> makeMetadataStoreManagementDuties() {
        CoordinatorKillConfigs killConfigs = this.config.getKillConfigs();
        ArrayList<CoordinatorDuty> duties = new ArrayList<CoordinatorDuty>();
        duties.add(new KillSupervisors(killConfigs.supervisors(), this.metadataManager.supervisors()));
        duties.add(new KillAuditLog(killConfigs.auditLogs(), this.metadataManager.audit()));
        duties.add(new KillRules(killConfigs.rules(), this.metadataManager.rules()));
        duties.add(new KillDatasourceMetadata(killConfigs.datasources(), this.metadataManager.indexer(), this.metadataManager.supervisors()));
        duties.add(new KillCompactionConfig(killConfigs.compactionConfigs(), this.metadataManager.indexer(), this.metadataManager.configs()));
        if (this.centralizedDatasourceSchemaConfig.isEnabled()) {
            duties.add(new KillUnreferencedSegmentSchema(killConfigs.segmentSchemas(), this.metadataManager.schemas()));
        }
        return duties;
    }

    private CompactSegments initializeCompactSegmentsDuty(CompactionStatusTracker statusTracker) {
        List<CompactSegments> compactSegmentsDutyFromCustomGroups = this.getCompactSegmentsDutyFromCustomGroups();
        if (compactSegmentsDutyFromCustomGroups.isEmpty()) {
            return new CompactSegments(statusTracker, this.overlordClient);
        }
        if (compactSegmentsDutyFromCustomGroups.size() > 1) {
            log.warn("More than one compactSegments duty is configured in the Coordinator Custom Duty Group. The first duty will be picked up.", new Object[0]);
        }
        return compactSegmentsDutyFromCustomGroups.get(0);
    }

    private List<CompactSegments> getCompactSegmentsDutyFromCustomGroups() {
        return this.customDutyGroups.getCoordinatorCustomDutyGroups().stream().flatMap(coordinatorCustomDutyGroup -> coordinatorCustomDutyGroup.getCustomDutyList().stream()).filter(duty -> duty instanceof CompactSegments).map(duty -> (CompactSegments)duty).collect(Collectors.toList());
    }

    private int markSegmentsAsUnused(String datasource, Set<SegmentId> segmentIds) {
        try {
            Set<String> segmentIdsToUpdate = segmentIds.stream().map(SegmentId::toString).collect(Collectors.toSet());
            SegmentsToUpdateFilter filter = new SegmentsToUpdateFilter(null, segmentIdsToUpdate, null);
            SegmentUpdateResponse response = (SegmentUpdateResponse)FutureUtils.getUnchecked(this.overlordClient.markSegmentsAsUnused(datasource, filter), (boolean)true);
            return response.getNumChangedSegments();
        }
        catch (Exception e) {
            HttpResponseStatus status;
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            if (rootCause instanceof HttpResponseException && (status = ((HttpResponseException)rootCause).getResponse().getStatus()).getCode() == 404) {
                log.warn("Could not mark segments as unused since Overlord is on an older version. Upgrade the Overlord to a newer version to allow updating segments.", new Object[0]);
                return 0;
            }
            log.error((Throwable)e, "Could not mark segments as unused for datasource[%s].", new Object[]{datasource});
            return 0;
        }
    }

    private class DutiesRunnable
    implements Runnable,
    DutyGroupHelper {
        private final int startingLeaderCounter;
        private final ScheduledExecutorService executor;
        private final CoordinatorDutyGroup dutyGroup;

        DutiesRunnable(List<CoordinatorDuty> duties, int startingLeaderCounter, String alias, Duration period) {
            this.startingLeaderCounter = startingLeaderCounter;
            this.dutyGroup = new CoordinatorDutyGroup(alias, duties, period, this);
            this.executor = DruidCoordinator.this.executorFactory.create(1, "Coordinator-Exec-" + alias + "-%d");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = DruidCoordinator.this.lock;
                synchronized (object) {
                    if (!DruidCoordinator.this.coordLeaderSelector.isLeader()) {
                        DruidCoordinator.this.stopBeingLeader();
                        return;
                    }
                }
                if (DruidCoordinator.this.metadataManager.isStarted() && DruidCoordinator.this.serverInventoryView.isStarted()) {
                    DataSourcesSnapshot dataSourcesSnapshot = this.dutyGroup.getName().equals(DruidCoordinator.COMPACT_SEGMENTS_DUTIES_DUTY_GROUP) ? DataSourcesSnapshot.fromUsedSegments(DruidCoordinator.this.metadataManager.segments().getRecentDataSourcesSnapshot().iterateAllUsedSegmentsInSnapshot(), DateTimes.nowUtc().plusMinutes(60)) : DruidCoordinator.this.metadataManager.segments().getRecentDataSourcesSnapshot();
                    DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.builder().withDataSourcesSnapshot(dataSourcesSnapshot).withDynamicConfigs(DruidCoordinator.this.metadataManager.configs().getCurrentDynamicConfig()).withCompactionConfig(DruidCoordinator.this.metadataManager.configs().getCurrentCompactionConfig()).build();
                    this.dutyGroup.run(params);
                } else {
                    log.error("Inventory view not initialized yet. Skipping run of duty group[%s].", new Object[]{this.dutyGroup.getName()});
                    DruidCoordinator.this.stopBeingLeader();
                }
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Caught exception, ignoring so that schedule keeps going.", new Object[0]).emit();
            }
        }

        @Override
        public void emitStat(CoordinatorStat stat, RowKey rowKey, long value) {
            ServiceMetricEvent.Builder eventBuilder = new ServiceMetricEvent.Builder().setDimension(Dimension.DUTY_GROUP.reportedName(), (Object)this.dutyGroup.getName());
            rowKey.getValues().forEach((dim, dimValue) -> eventBuilder.setDimension(dim.reportedName(), dimValue));
            DruidCoordinator.this.emitter.emit((ServiceEventBuilder)eventBuilder.setMetric(stat.getMetricName(), (Number)value));
        }

        @Override
        public boolean isLeader() {
            return DruidCoordinator.this.coordLeaderSelector.isLeader() && this.startingLeaderCounter == DruidCoordinator.this.coordLeaderSelector.localTerm();
        }
    }

    private class UpdateReplicationStatus
    implements CoordinatorDuty {
        private UpdateReplicationStatus() {
        }

        @Override
        public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
            DruidCoordinator.this.broadcastSegments = params.getBroadcastSegments();
            DruidCoordinator.this.segmentReplicationStatus = params.getSegmentReplicationStatus();
            if (DruidCoordinator.this.coordinatorSegmentMetadataCache != null) {
                DruidCoordinator.this.coordinatorSegmentMetadataCache.updateSegmentReplicationStatus(DruidCoordinator.this.segmentReplicationStatus);
            }
            return params;
        }
    }

    private class CollectSegmentStats
    implements CoordinatorDuty {
        private CollectSegmentStats() {
        }

        @Override
        public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
            CoordinatorRunStats stats = params.getCoordinatorStats();
            DruidCoordinator.this.getDatasourceToUnavailableSegmentCount().forEach((dataSource, numUnavailable) -> stats.add(Stats.Segments.UNAVAILABLE, RowKey.of(Dimension.DATASOURCE, dataSource), numUnavailable.intValue()));
            DruidCoordinator.this.getTierToDatasourceToUnderReplicatedCount(false).forEach((tier, countsPerDatasource) -> countsPerDatasource.forEach((dataSource, underReplicatedCount) -> stats.addToSegmentStat(Stats.Segments.UNDER_REPLICATED, (String)tier, (String)dataSource, (long)underReplicatedCount)));
            DruidCoordinator.this.getDatasourceToDeepStorageQueryOnlySegmentCount().forEach((dataSource, numDeepStorageOnly) -> stats.add(Stats.Segments.DEEP_STORAGE_ONLY, RowKey.of(Dimension.DATASOURCE, dataSource), numDeepStorageOnly.intValue()));
            return params;
        }
    }

    private class CollectLoadQueueStats
    implements CoordinatorDuty {
        private CollectLoadQueueStats() {
        }

        @Override
        public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
            CoordinatorRunStats stats = params.getCoordinatorStats();
            DruidCoordinator.this.taskMaster.getAllPeons().forEach((serverName, queuePeon) -> {
                RowKey rowKey = RowKey.of(Dimension.SERVER, serverName);
                stats.add(Stats.SegmentQueue.BYTES_TO_LOAD, rowKey, queuePeon.getSizeOfSegmentsToLoad());
                stats.add(Stats.SegmentQueue.NUM_TO_LOAD, rowKey, queuePeon.getSegmentsToLoad().size());
                stats.add(Stats.SegmentQueue.NUM_TO_DROP, rowKey, queuePeon.getSegmentsToDrop().size());
                stats.updateMax(Stats.SegmentQueue.LOAD_RATE_KBPS, rowKey, queuePeon.getLoadRateKbps());
                queuePeon.getAndResetStats().forEachStat((stat, key, statValue) -> stats.add(stat, this.createRowKeyForServer((String)serverName, key.getValues()), statValue));
            });
            return params;
        }

        private RowKey createRowKeyForServer(String serverName, Map<Dimension, String> dimensionValues) {
            RowKey.Builder builder = RowKey.with(Dimension.SERVER, serverName);
            dimensionValues.forEach(builder::with);
            return builder.build();
        }
    }

    public static interface DutyGroupHelper {
        public boolean isLeader();

        public void emitStat(CoordinatorStat var1, RowKey var2, long var3);
    }
}

