/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll.sql;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchHolder;

public class HllPostAggExprMacros {
    public static final String HLL_SKETCH_ESTIMATE = "hll_sketch_estimate";
    public static final String HLL_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS = "hll_sketch_estimate_with_error_bounds";

    public static class HllSketchEstimateWithErrorBoundsExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private Expr estimateExpr;
        private Expr numStdDev;

        public HllSketchEstimateWithErrorBoundsExpr(HllSketchEstimateWithErrorBoundsExprMacro macro, List<Expr> args) {
            super((ExprMacroTable.ExprMacro)macro, args);
            this.estimateExpr = args.get(0);
            if (args.size() == 2) {
                this.numStdDev = args.get(1);
            }
        }

        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.DOUBLE_ARRAY;
        }

        public ExprEval eval(Expr.ObjectBinding bindings) {
            Object valObj;
            int numStdDevs = 1;
            ExprEval eval = this.estimateExpr.eval(bindings);
            if (this.numStdDev != null) {
                numStdDevs = this.numStdDev.eval(bindings).asInt();
            }
            if ((valObj = eval.value()) == null) {
                return ExprEval.ofDoubleArray((Object[])new Double[]{0.0, 0.0, 0.0});
            }
            HllSketchHolder sketch = HllSketchHolder.fromObj(valObj);
            return ExprEval.ofDoubleArray((Object[])new Double[]{sketch.getEstimate(), sketch.getLowerBound(numStdDevs), sketch.getUpperBound(numStdDevs)});
        }
    }

    public static class HllSketchEstimateExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private Expr estimateExpr;
        private Expr isRound;

        public HllSketchEstimateExpr(HLLSketchEstimateExprMacro macro, List<Expr> args) {
            super((ExprMacroTable.ExprMacro)macro, args);
            this.estimateExpr = args.get(0);
            if (args.size() == 2) {
                this.isRound = args.get(1);
            }
        }

        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.DOUBLE;
        }

        public ExprEval eval(Expr.ObjectBinding bindings) {
            Object valObj;
            boolean round = false;
            ExprEval eval = this.estimateExpr.eval(bindings);
            if (this.isRound != null) {
                round = this.isRound.eval(bindings).asBoolean();
            }
            if ((valObj = eval.value()) == null) {
                return ExprEval.of((double)0.0);
            }
            HllSketchHolder h = HllSketchHolder.fromObj(valObj);
            double estimate = h.getEstimate();
            return round ? ExprEval.of((long)Math.round(estimate)) : ExprEval.of((double)estimate);
        }
    }

    public static class HllSketchEstimateWithErrorBoundsExprMacro
    implements ExprMacroTable.ExprMacro {
        public Expr apply(List<Expr> args) {
            this.validationHelperCheckAnyOfArgumentCount(args, new int[]{1, 2});
            return new HllSketchEstimateWithErrorBoundsExpr(this, args);
        }

        public String name() {
            return HllPostAggExprMacros.HLL_SKETCH_ESTIMATE_WITH_ERROR_BOUNDS;
        }
    }

    public static class HLLSketchEstimateExprMacro
    implements ExprMacroTable.ExprMacro {
        public Expr apply(List<Expr> args) {
            this.validationHelperCheckAnyOfArgumentCount(args, new int[]{1, 2});
            return new HllSketchEstimateExpr(this, args);
        }

        public String name() {
            return HllPostAggExprMacros.HLL_SKETCH_ESTIMATE;
        }
    }
}

