/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.avro.AvroBytesDecoder;
import org.apache.druid.data.input.avro.AvroStreamReader;
import org.apache.druid.data.input.impl.NestedInputFormat;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;

public class AvroStreamInputFormat
extends NestedInputFormat {
    private final boolean binaryAsString;
    private final boolean extractUnionsByType;
    private final AvroBytesDecoder avroBytesDecoder;

    @JsonCreator
    public AvroStreamInputFormat(@JsonProperty(value="flattenSpec") @Nullable JSONPathSpec flattenSpec, @JsonProperty(value="avroBytesDecoder") AvroBytesDecoder avroBytesDecoder, @JsonProperty(value="binaryAsString") @Nullable Boolean binaryAsString, @JsonProperty(value="extractUnionsByType") @Nullable Boolean extractUnionsByType) {
        super(flattenSpec);
        if (avroBytesDecoder == null) {
            throw new IAE("avroBytesDecoder is required to decode Avro records", new Object[0]);
        }
        this.avroBytesDecoder = avroBytesDecoder;
        this.binaryAsString = binaryAsString != null && binaryAsString != false;
        this.extractUnionsByType = extractUnionsByType != null && extractUnionsByType != false;
    }

    public boolean isSplittable() {
        return false;
    }

    @JsonProperty
    public AvroBytesDecoder getAvroBytesDecoder() {
        return this.avroBytesDecoder;
    }

    @JsonProperty
    public Boolean getBinaryAsString() {
        return this.binaryAsString;
    }

    @JsonProperty
    public Boolean isExtractUnionsByType() {
        return this.extractUnionsByType;
    }

    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        return new AvroStreamReader(inputRowSchema, source, this.avroBytesDecoder, this.getFlattenSpec(), this.binaryAsString, this.extractUnionsByType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AvroStreamInputFormat that = (AvroStreamInputFormat)((Object)o);
        return Objects.equals(this.getFlattenSpec(), that.getFlattenSpec()) && Objects.equals(this.avroBytesDecoder, that.avroBytesDecoder) && Objects.equals(this.binaryAsString, that.binaryAsString) && Objects.equals(this.extractUnionsByType, that.extractUnionsByType);
    }

    public int hashCode() {
        return Objects.hash(this.getFlattenSpec(), this.avroBytesDecoder, this.binaryAsString, this.extractUnionsByType);
    }
}

