/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hive;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.gravitino.catalog.hive.HiveTableHandle;
import org.apache.gravitino.connector.TableOperations;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.exceptions.PartitionAlreadyExistsException;
import org.apache.gravitino.hive.HivePartition;
import org.apache.gravitino.hive.HiveTable;
import org.apache.gravitino.rel.SupportsPartitions;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.partitions.IdentityPartition;
import org.apache.gravitino.rel.partitions.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableOperations
implements TableOperations,
SupportsPartitions {
    public static final Logger LOG = LoggerFactory.getLogger(HiveTableOperations.class);
    private final HiveTableHandle tableHandle;

    public HiveTableOperations(HiveTableHandle tableHandle) {
        Preconditions.checkArgument((tableHandle != null ? 1 : 0) != 0, (Object)"table must not be null");
        this.tableHandle = tableHandle;
    }

    public String[] listPartitionNames() {
        try {
            return (String[])this.tableHandle.clientPool().run(c -> c.listPartitionNames(this.tableHandle.table(), (short)-1).toArray(new String[0]));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to list partition names of table " + this.tableHandle.name() + "from Hive Metastore", e);
        }
    }

    public Partition[] listPartitions() {
        try {
            return ((List)this.tableHandle.clientPool().run(c -> c.listPartitions(this.tableHandle.table(), (short)-1))).toArray(new Partition[0]);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to list partitions of table " + this.tableHandle.name() + "from Hive Metastore", e);
        }
    }

    public Partition getPartition(String partitionName) throws NoSuchPartitionException {
        try {
            return (Partition)this.tableHandle.clientPool().run(c -> c.getPartition(this.tableHandle.table(), partitionName));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to get partition " + partitionName + " of table " + this.tableHandle.name() + "from Hive Metastore", e);
        }
    }

    public Partition addPartition(Partition partition) throws PartitionAlreadyExistsException {
        if ("*".equals(partition.name())) {
            throw new IllegalArgumentException("Can't create a catalog with with reserved partition `*`");
        }
        Preconditions.checkArgument((boolean)(partition instanceof IdentityPartition), (Object)"Hive only supports identity partition");
        IdentityPartition identityPartition = (IdentityPartition)partition;
        HivePartition hivePartition = HivePartition.identity((String[][])identityPartition.fieldNames(), (Literal[])identityPartition.values(), (Map)identityPartition.properties());
        HashSet partitionFieldNames = new HashSet(this.tableHandle.table().partitionFieldNames());
        Preconditions.checkArgument((partitionFieldNames.size() == identityPartition.fieldNames().length ? 1 : 0) != 0, (String)"Hive partition field names must be the same as table partitioning field names: %s, but got %s", (Object)String.join((CharSequence)",", partitionFieldNames), (Object)String.join((CharSequence)",", Arrays.stream(identityPartition.fieldNames()).map(f -> String.join((CharSequence)".", f)).collect(Collectors.toList())));
        Arrays.stream(identityPartition.fieldNames()).forEach(f -> Preconditions.checkArgument((boolean)partitionFieldNames.contains(f[0]), (String)"Hive partition field name must be in table partitioning field names: %s, but got %s", (Object)String.join((CharSequence)",", partitionFieldNames), (Object)f[0]));
        try {
            return (Partition)this.tableHandle.clientPool().run(c -> c.addPartition(this.tableHandle.table(), hivePartition));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean dropPartition(String partitionName) {
        try {
            HiveTable hiveTable = this.tableHandle.table();
            List partitions = (List)this.tableHandle.clientPool().run(c -> c.listPartitions(hiveTable, HivePartition.extractPartitionValues((List)hiveTable.partitionFieldNames(), (String)partitionName), (short)-1));
            if (partitions.isEmpty()) {
                throw new NoSuchPartitionException("Hive partition %s does not exist in Hive Metastore", new Object[]{partitionName});
            }
            for (HivePartition partition : partitions) {
                this.tableHandle.clientPool().run(cc -> {
                    cc.dropPartition(hiveTable.catalogName(), hiveTable.databaseName(), this.tableHandle.name(), partition.name(), true);
                    return null;
                });
            }
        }
        catch (NoSuchPartitionException e) {
            return false;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to get partition " + partitionName + " of table " + this.tableHandle.name() + "from Hive Metastore", e);
        }
        return true;
    }

    public void close() throws IOException {
        this.tableHandle.close();
    }
}

