/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.reader;

import java.io.IOException;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.IOUtils;

public class RecordReaderIterator<T>
implements CloseableIterator<T> {
    private final RecordReader<T> reader;
    private RecordReader.RecordIterator<T> currentIterator;
    private boolean advanced;
    private T currentResult;

    public RecordReaderIterator(RecordReader<T> reader) {
        this.reader = reader;
        try {
            this.currentIterator = reader.readBatch();
        }
        catch (Exception e) {
            IOUtils.closeQuietly(reader);
            throw new RuntimeException(e);
        }
        this.advanced = false;
        this.currentResult = null;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null) {
            return false;
        }
        this.advanceIfNeeded();
        return this.currentResult != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            return null;
        }
        this.advanced = false;
        return this.currentResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void advanceIfNeeded() {
        if (this.advanced) {
            return;
        }
        this.advanced = true;
        try {
            do {
                this.currentResult = this.currentIterator.next();
                if (this.currentResult != null) return;
                this.currentIterator.releaseBatch();
                this.currentIterator = null;
                this.currentIterator = this.reader.readBatch();
            } while (this.currentIterator != null);
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.currentIterator != null) {
                this.currentIterator.releaseBatch();
            }
        }
        finally {
            this.reader.close();
        }
    }
}

