/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.gravitino.exceptions.ForbiddenException;
import org.apache.gravitino.listener.AsyncQueueListener;
import org.apache.gravitino.listener.EventListenerPluginWrapper;
import org.apache.gravitino.listener.api.EventListenerPlugin;
import org.apache.gravitino.listener.api.event.BaseEvent;
import org.apache.gravitino.listener.api.event.Event;
import org.apache.gravitino.listener.api.event.PreEvent;
import org.apache.gravitino.listener.api.event.SupportsChangingPreEvent;

public class EventBus {
    private final List<EventListenerPlugin> eventListeners;
    private final List<AsyncQueueListener> asyncQueueListeners;

    public EventBus(List<EventListenerPlugin> eventListeners) {
        this.eventListeners = eventListeners;
        this.asyncQueueListeners = eventListeners.stream().filter(AsyncQueueListener.class::isInstance).map(AsyncQueueListener.class::cast).collect(Collectors.toList());
    }

    public Optional<BaseEvent> dispatchEvent(BaseEvent baseEvent) {
        if (baseEvent instanceof PreEvent) {
            return this.dispatchAndTransformPreEvent((PreEvent)baseEvent);
        }
        if (baseEvent instanceof Event) {
            this.dispatchPostEvent((Event)baseEvent);
            return Optional.empty();
        }
        throw new RuntimeException("Unknown event type:" + baseEvent.getClass().getSimpleName());
    }

    public boolean isHighWatermark() {
        return this.asyncQueueListeners.stream().anyMatch(AsyncQueueListener::isHighWatermark);
    }

    @VisibleForTesting
    public List<EventListenerPlugin> getEventListeners() {
        return this.eventListeners;
    }

    private void dispatchPostEvent(Event postEvent) {
        this.eventListeners.forEach(eventListener -> eventListener.onPostEvent(postEvent));
    }

    private Optional<BaseEvent> dispatchAndTransformPreEvent(PreEvent originalEvent) throws ForbiddenException {
        boolean supportsChangePreEvent = originalEvent instanceof SupportsChangingPreEvent;
        PreEvent preEvent = supportsChangePreEvent ? (PreEvent)((Object)this.transformPreEvent((SupportsChangingPreEvent)((Object)originalEvent))) : originalEvent;
        this.eventListeners.forEach(eventListener -> eventListener.onPreEvent(preEvent));
        return supportsChangePreEvent ? Optional.of(preEvent) : Optional.empty();
    }

    private SupportsChangingPreEvent transformPreEvent(SupportsChangingPreEvent preEvent) {
        SupportsChangingPreEvent tmpPreEvent = preEvent;
        for (EventListenerPlugin eventListener : this.eventListeners) {
            tmpPreEvent = eventListener.transformPreEvent(tmpPreEvent);
            Preconditions.checkArgument((tmpPreEvent != null ? 1 : 0) != 0, (Object)String.format("%s transformPreEvent return null", this.getListenerName(eventListener)));
        }
        return tmpPreEvent;
    }

    private String getListenerName(EventListenerPlugin eventListener) {
        if (eventListener instanceof EventListenerPluginWrapper) {
            return ((EventListenerPluginWrapper)eventListener).listenerName();
        }
        return eventListener.getClass().getSimpleName();
    }
}

