/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DrainBarrier {
    private final AtomicLong valueAndFlags = new AtomicLong(DrainBarrier.inc(0L));
    private static final long DRAINING_FLAG = 1L;
    private static final int FLAG_BIT_COUNT = 1;

    public boolean beginOp() {
        long oldValAndFlags;
        do {
            if (!DrainBarrier.isDraining(oldValAndFlags = this.valueAndFlags.get())) continue;
            return false;
        } while (!this.valueAndFlags.compareAndSet(oldValAndFlags, DrainBarrier.inc(oldValAndFlags)));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"NN_NAKED_NOTIFY"}, justification="First, we do change the state before notify, 2nd, it doesn't even matter")
    public void endOp() {
        long oldValAndFlags;
        do {
            long unacceptableCount;
            long l = unacceptableCount = DrainBarrier.isDraining(oldValAndFlags = this.valueAndFlags.get()) ? 0L : 1L;
            if (DrainBarrier.getValue(oldValAndFlags) == unacceptableCount) {
                throw new AssertionError((Object)("endOp called without corresponding beginOp call (the current count is " + unacceptableCount + ")"));
            }
        } while (!this.valueAndFlags.compareAndSet(oldValAndFlags, DrainBarrier.dec(oldValAndFlags)));
        if (DrainBarrier.getValue(oldValAndFlags) == 1L) {
            DrainBarrier drainBarrier = this;
            synchronized (drainBarrier) {
                this.notifyAll();
            }
        }
    }

    public void stopAndDrainOps() throws InterruptedException {
        this.stopAndDrainOps(true);
    }

    public void stopAndDrainOpsOnce() throws InterruptedException {
        this.stopAndDrainOps(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"UW_UNCOND_WAIT", "WA_NOT_IN_LOOP"})
    private void stopAndDrainOps(boolean ignoreRepeatedCalls) throws InterruptedException {
        long oldValAndFlags;
        do {
            if (!DrainBarrier.isDraining(oldValAndFlags = this.valueAndFlags.get())) continue;
            if (ignoreRepeatedCalls) {
                return;
            }
            throw new AssertionError((Object)"stopAndWaitForOpsOnce called more than once");
        } while (!this.valueAndFlags.compareAndSet(oldValAndFlags, DrainBarrier.dec(oldValAndFlags) | 1L));
        if (DrainBarrier.getValue(oldValAndFlags) == 1L) {
            return;
        }
        DrainBarrier drainBarrier = this;
        synchronized (drainBarrier) {
            this.wait();
        }
    }

    private static final boolean isDraining(long valueAndFlags) {
        return (valueAndFlags & 1L) == 1L;
    }

    private static final long getValue(long valueAndFlags) {
        return valueAndFlags >> 1;
    }

    private static final long inc(long valueAndFlags) {
        return valueAndFlags + 2L;
    }

    private static final long dec(long valueAndFlags) {
        return valueAndFlags - 2L;
    }
}

