/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.util.RangerPerfTracerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPerfTracer {
    protected final Logger logger;
    protected final String tag;
    protected final String data;
    private final long startTimeMs;
    private static long reportingThresholdMs;
    private static final String tagEndMarker = "(";

    public static Logger getPerfLogger(String name) {
        return LoggerFactory.getLogger((String)("org.apache.ranger.perf." + name));
    }

    public static Logger getPerfLogger(Class<?> cls) {
        return RangerPerfTracer.getPerfLogger(cls.getName());
    }

    public static boolean isPerfTraceEnabled(Logger logger) {
        return logger.isDebugEnabled();
    }

    public static RangerPerfTracer getPerfTracer(Logger logger, String tag) {
        String data = "";
        String realTag = "";
        if (tag != null) {
            int indexOfTagEndMarker = StringUtils.indexOf((String)tag, (String)tagEndMarker);
            if (indexOfTagEndMarker != -1) {
                realTag = StringUtils.substring((String)tag, (int)0, (int)indexOfTagEndMarker);
                data = StringUtils.substring((String)tag, (int)indexOfTagEndMarker);
            } else {
                realTag = tag;
            }
        }
        return RangerPerfTracerFactory.getPerfTracer(logger, realTag, data);
    }

    public static RangerPerfTracer getPerfTracer(Logger logger, String tag, String data) {
        return RangerPerfTracerFactory.getPerfTracer(logger, tag, data);
    }

    public static void log(RangerPerfTracer tracer) {
        if (tracer != null) {
            tracer.log();
        }
    }

    public static void logAlways(RangerPerfTracer tracer) {
        if (tracer != null) {
            tracer.logAlways();
        }
    }

    public RangerPerfTracer(Logger logger, String tag, String data) {
        this.logger = logger;
        this.tag = tag;
        this.data = data;
        this.startTimeMs = System.currentTimeMillis();
    }

    public final String getTag() {
        return this.tag;
    }

    public final long getStartTime() {
        return this.startTimeMs;
    }

    public final long getElapsedTime() {
        return System.currentTimeMillis() - this.startTimeMs;
    }

    public void log() {
        long elapsedTime = this.getElapsedTime();
        if (elapsedTime > reportingThresholdMs) {
            this.logger.debug("[PERF] " + this.tag + this.data + ": " + elapsedTime);
        }
    }

    public void logAlways() {
        long elapsedTime = this.getElapsedTime();
        this.logger.debug("[PERF] " + this.tag + this.data + ": " + elapsedTime);
    }
}

