/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileIOLoader;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.rest.RESTCatalog;
import org.apache.paimon.rest.RESTCatalogLoader;
import org.apache.paimon.rest.RESTToken;
import org.apache.paimon.rest.RESTUtil;
import org.apache.paimon.rest.responses.GetTableTokenResponse;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Scheduler;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTTokenFileIO
implements FileIO {
    private static final long serialVersionUID = 1L;
    public static final ConfigOption<Boolean> DATA_TOKEN_ENABLED = ConfigOptions.key((String)"data-token.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to support data token provided by the REST server.");
    private static final Cache<RESTToken, FileIO> FILE_IO_CACHE = Caffeine.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maximumSize(100L).removalListener((ignored, value, cause) -> IOUtils.closeQuietly((AutoCloseable)((FileIO)value))).scheduler(Scheduler.forScheduledExecutorService((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor(ThreadUtils.newDaemonThreadFactory((String)"rest-token-file-io-scheduler")))).build();
    private static final Logger LOG = LoggerFactory.getLogger(RESTTokenFileIO.class);
    private final RESTCatalogLoader catalogLoader;
    private final Identifier identifier;
    private final Path path;
    private final transient RESTCatalog catalogInstance;
    private volatile RESTToken token;

    public RESTTokenFileIO(RESTCatalogLoader catalogLoader, RESTCatalog catalogInstance, Identifier identifier, Path path) {
        this.catalogLoader = catalogLoader;
        this.catalogInstance = catalogInstance;
        this.identifier = identifier;
        this.path = path;
    }

    public void configure(CatalogContext context) {
        throw new UnsupportedOperationException("RESTTokenFileIO does not support configuration.");
    }

    public SeekableInputStream newInputStream(Path path) throws IOException {
        return this.fileIO().newInputStream(path);
    }

    public PositionOutputStream newOutputStream(Path path, boolean overwrite) throws IOException {
        return this.fileIO().newOutputStream(path, overwrite);
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        return this.fileIO().getFileStatus(path);
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        return this.fileIO().listStatus(path);
    }

    public boolean exists(Path path) throws IOException {
        return this.fileIO().exists(path);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        return this.fileIO().delete(path, recursive);
    }

    public boolean mkdirs(Path path) throws IOException {
        return this.fileIO().mkdirs(path);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.fileIO().rename(src, dst);
    }

    public boolean isObjectStore() {
        try {
            return this.fileIO().isObjectStore();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileIO fileIO() throws IOException {
        this.tryToRefreshToken();
        FileIO fileIO = (FileIO)FILE_IO_CACHE.getIfPresent((Object)this.token);
        if (fileIO != null) {
            return fileIO;
        }
        Cache<RESTToken, FileIO> cache = FILE_IO_CACHE;
        synchronized (cache) {
            fileIO = (FileIO)FILE_IO_CACHE.getIfPresent((Object)this.token);
            if (fileIO != null) {
                return fileIO;
            }
            CatalogContext context = this.catalogLoader.context();
            Options options = context.options();
            options = new Options(RESTUtil.merge(this.token.token(), (Map)options.toMap()));
            options.set(CatalogOptions.FILE_IO_ALLOW_CACHE, (Object)false);
            context = CatalogContext.create((Options)options, (FileIOLoader)context.preferIO(), (FileIOLoader)context.fallbackIO());
            try {
                fileIO = FileIO.get((Path)this.path, (CatalogContext)context);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            FILE_IO_CACHE.put((Object)this.token, (Object)fileIO);
            return fileIO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToRefreshToken() {
        if (this.shouldRefresh()) {
            RESTTokenFileIO rESTTokenFileIO = this;
            synchronized (rESTTokenFileIO) {
                if (this.shouldRefresh()) {
                    this.refreshToken();
                }
            }
        }
    }

    private boolean shouldRefresh() {
        return this.token == null || this.token.expireAtMillis() - System.currentTimeMillis() < 3600000L;
    }

    private void refreshToken() {
        GetTableTokenResponse response;
        LOG.info("begin refresh data token for identifier [{}]", (Object)this.identifier);
        if (this.catalogInstance != null) {
            try {
                response = this.catalogInstance.loadTableToken(this.identifier);
            }
            catch (Catalog.TableNotExistException e) {
                throw new RuntimeException(e);
            }
        }
        try (RESTCatalog catalog = this.catalogLoader.load();){
            response = catalog.loadTableToken(this.identifier);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.info("end refresh data token for identifier [{}] expiresAtMillis [{}]", (Object)this.identifier, (Object)response.getExpiresAtMillis());
        this.token = new RESTToken(response.getToken(), response.getExpiresAtMillis());
    }

    public RESTToken validToken() {
        this.tryToRefreshToken();
        return this.token;
    }
}

