/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.system.AggregationFieldsTable;
import org.apache.paimon.table.system.AuditLogTable;
import org.apache.paimon.table.system.BinlogTable;
import org.apache.paimon.table.system.BranchesTable;
import org.apache.paimon.table.system.BucketsTable;
import org.apache.paimon.table.system.ConsumersTable;
import org.apache.paimon.table.system.FilesTable;
import org.apache.paimon.table.system.ManifestsTable;
import org.apache.paimon.table.system.OptionsTable;
import org.apache.paimon.table.system.PartitionsTable;
import org.apache.paimon.table.system.ReadOptimizedTable;
import org.apache.paimon.table.system.SchemasTable;
import org.apache.paimon.table.system.SnapshotsTable;
import org.apache.paimon.table.system.StatisticTable;
import org.apache.paimon.table.system.TableIndexesTable;
import org.apache.paimon.table.system.TagsTable;

public class SystemTableLoader {
    public static final Map<String, Function<FileStoreTable, Table>> SYSTEM_TABLE_LOADERS = new ImmutableMap.Builder().put((Object)"manifests", ManifestsTable::new).put((Object)"snapshots", SnapshotsTable::new).put((Object)"options", OptionsTable::new).put((Object)"schemas", SchemasTable::new).put((Object)"partitions", PartitionsTable::new).put((Object)"buckets", BucketsTable::new).put((Object)"audit_log", AuditLogTable::new).put((Object)"files", FilesTable::new).put((Object)"tags", TagsTable::new).put((Object)"branches", BranchesTable::new).put((Object)"consumers", ConsumersTable::new).put((Object)"ro", ReadOptimizedTable::new).put((Object)"aggregation_fields", AggregationFieldsTable::new).put((Object)"statistics", StatisticTable::new).put((Object)"binlog", BinlogTable::new).put((Object)"table_indexes", TableIndexesTable::new).build();
    public static final List<String> SYSTEM_TABLES = new ArrayList<String>(SYSTEM_TABLE_LOADERS.keySet());

    @Nullable
    public static Table load(String type, FileStoreTable dataTable) {
        return Optional.ofNullable(SYSTEM_TABLE_LOADERS.get(type.toLowerCase())).map(f -> (Table)f.apply(dataTable)).orElse(null);
    }

    public static List<String> loadGlobalTableNames() {
        return Arrays.asList("all_table_options", "catalog_options");
    }
}

