/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.audit.v2;

import com.google.common.collect.ImmutableMap;
import org.apache.gravitino.audit.AuditLog;
import org.apache.gravitino.listener.api.event.OperationStatus;
import org.apache.gravitino.listener.api.event.OperationType;

public class CompatibilityUtils {
    private static ImmutableMap<OperationType, AuditLog.Operation> operationTypeMap = ImmutableMap.builder().put((Object)OperationType.CREATE_METALAKE, (Object)AuditLog.Operation.CREATE_METALAKE).put((Object)OperationType.ALTER_METALAKE, (Object)AuditLog.Operation.ALTER_METALAKE).put((Object)OperationType.DROP_METALAKE, (Object)AuditLog.Operation.DROP_METALAKE).put((Object)OperationType.LOAD_METALAKE, (Object)AuditLog.Operation.LOAD_METALAKE).put((Object)OperationType.LIST_METALAKE, (Object)AuditLog.Operation.LIST_METALAKE).put((Object)OperationType.CREATE_CATALOG, (Object)AuditLog.Operation.CREATE_CATALOG).put((Object)OperationType.ALTER_CATALOG, (Object)AuditLog.Operation.ALTER_CATALOG).put((Object)OperationType.DROP_CATALOG, (Object)AuditLog.Operation.DROP_CATALOG).put((Object)OperationType.LOAD_CATALOG, (Object)AuditLog.Operation.LOAD_CATALOG).put((Object)OperationType.LIST_CATALOG, (Object)AuditLog.Operation.LIST_CATALOG).put((Object)OperationType.CREATE_SCHEMA, (Object)AuditLog.Operation.CREATE_SCHEMA).put((Object)OperationType.ALTER_SCHEMA, (Object)AuditLog.Operation.ALTER_SCHEMA).put((Object)OperationType.DROP_SCHEMA, (Object)AuditLog.Operation.DROP_SCHEMA).put((Object)OperationType.LOAD_SCHEMA, (Object)AuditLog.Operation.LOAD_SCHEMA).put((Object)OperationType.LIST_SCHEMA, (Object)AuditLog.Operation.LIST_SCHEMA).put((Object)OperationType.SCHEMA_EXISTS, (Object)AuditLog.Operation.UNKNOWN_OPERATION).put((Object)OperationType.CREATE_TABLE, (Object)AuditLog.Operation.CREATE_TABLE).put((Object)OperationType.ALTER_TABLE, (Object)AuditLog.Operation.ALTER_TABLE).put((Object)OperationType.DROP_TABLE, (Object)AuditLog.Operation.DROP_TABLE).put((Object)OperationType.PURGE_TABLE, (Object)AuditLog.Operation.PURGE_TABLE).put((Object)OperationType.LOAD_TABLE, (Object)AuditLog.Operation.LOAD_TABLE).put((Object)OperationType.TABLE_EXISTS, (Object)AuditLog.Operation.UNKNOWN_OPERATION).put((Object)OperationType.LIST_TABLE, (Object)AuditLog.Operation.LIST_TABLE).put((Object)OperationType.RENAME_TABLE, (Object)AuditLog.Operation.UNKNOWN_OPERATION).put((Object)OperationType.REGISTER_TABLE, (Object)AuditLog.Operation.UNKNOWN_OPERATION).put((Object)OperationType.ADD_PARTITION, (Object)AuditLog.Operation.UNKNOWN_OPERATION).put((Object)OperationType.DROP_PARTITION, (Object)AuditLog.Operation.UNKNOWN_OPERATION).put((Object)OperationType.PURGE_PARTITION, (Object)AuditLog.Operation.PURGE_PARTITION).put((Object)OperationType.LOAD_PARTITION, (Object)AuditLog.Operation.GET_PARTITION).put((Object)OperationType.PARTITION_EXISTS, (Object)AuditLog.Operation.PARTITION_EXIST).put((Object)OperationType.LIST_PARTITION, (Object)AuditLog.Operation.LIST_PARTITION).put((Object)OperationType.LIST_PARTITION_NAMES, (Object)AuditLog.Operation.LIST_PARTITION).put((Object)OperationType.CREATE_FILESET, (Object)AuditLog.Operation.CREATE_FILESET).put((Object)OperationType.ALTER_FILESET, (Object)AuditLog.Operation.ALTER_FILESET).put((Object)OperationType.DROP_FILESET, (Object)AuditLog.Operation.DROP_FILESET).put((Object)OperationType.LOAD_FILESET, (Object)AuditLog.Operation.LOAD_FILESET).put((Object)OperationType.LIST_FILESET, (Object)AuditLog.Operation.LIST_FILESET).put((Object)OperationType.GET_FILESET_LOCATION, (Object)AuditLog.Operation.GET_FILE_LOCATION).put((Object)OperationType.CREATE_TOPIC, (Object)AuditLog.Operation.CREATE_TOPIC).put((Object)OperationType.ALTER_TOPIC, (Object)AuditLog.Operation.ALTER_TOPIC).put((Object)OperationType.DROP_TOPIC, (Object)AuditLog.Operation.DROP_TOPIC).put((Object)OperationType.LOAD_TOPIC, (Object)AuditLog.Operation.LOAD_TOPIC).put((Object)OperationType.LIST_TOPIC, (Object)AuditLog.Operation.LIST_TOPIC).put((Object)OperationType.CREATE_VIEW, (Object)AuditLog.Operation.UNKNOWN_OPERATION).put((Object)OperationType.ALTER_VIEW, (Object)AuditLog.Operation.UNKNOWN_OPERATION).put((Object)OperationType.DROP_VIEW, (Object)AuditLog.Operation.UNKNOWN_OPERATION).put((Object)OperationType.LOAD_VIEW, (Object)AuditLog.Operation.UNKNOWN_OPERATION).put((Object)OperationType.VIEW_EXISTS, (Object)AuditLog.Operation.UNKNOWN_OPERATION).put((Object)OperationType.RENAME_VIEW, (Object)AuditLog.Operation.UNKNOWN_OPERATION).put((Object)OperationType.LIST_VIEW, (Object)AuditLog.Operation.UNKNOWN_OPERATION).build();

    static AuditLog.Operation toAuditLogOperation(OperationType operationType) {
        return (AuditLog.Operation)((Object)operationTypeMap.getOrDefault((Object)operationType, (Object)AuditLog.Operation.UNKNOWN_OPERATION));
    }

    static AuditLog.Status toAuditLogStatus(OperationStatus operationStatus) {
        if (operationStatus == OperationStatus.SUCCESS) {
            return AuditLog.Status.SUCCESS;
        }
        if (operationStatus == OperationStatus.FAILURE) {
            return AuditLog.Status.FAILURE;
        }
        return AuditLog.Status.UNKNOWN;
    }
}

