/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import io.openlineage.client.transports.ApiKeyTokenProvider;
import java.util.Objects;

public class TokenProviderTypeIdResolver
extends TypeIdResolverBase {
    private JavaType superType;

    public void init(JavaType baseType) {
        this.superType = baseType;
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    public String idFromValue(Object obj) {
        return this.idFromValueAndType(obj, obj.getClass());
    }

    public String idFromValueAndType(Object obj, Class<?> subType) {
        return subType.getCanonicalName();
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        if (Objects.equals(id, "api_key")) {
            return context.constructSpecializedType(this.superType, ApiKeyTokenProvider.class);
        }
        try {
            return context.constructSpecializedType(this.superType, Class.forName(id));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("No class matches %s from spark.openlineage.transport.auth.type", id), e);
        }
    }
}

