/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.components;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.AbstractAsn1Object;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.types.PaDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaData
extends AbstractAsn1Object {
    private static final Logger log = LoggerFactory.getLogger(PaData.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private PaDataType paDataType;
    private byte[] paDataValue;
    private int paDataTypeTagLength;
    private int paDataValueTagLength;
    private int preAuthenticationDataSeqLength;

    public PaData() {
    }

    public PaData(PaDataType paDataType, byte[] paDataValue) {
        this.paDataType = paDataType;
        this.paDataValue = paDataValue;
    }

    public PaDataType getPaDataType() {
        return this.paDataType;
    }

    public void setPaDataType(int paDataType) {
        this.paDataType = PaDataType.getTypeByValue(paDataType);
    }

    public void setPaDataType(PaDataType paDataType) {
        this.paDataType = paDataType;
    }

    public byte[] getPaDataValue() {
        return this.paDataValue;
    }

    public void setPaDataValue(byte[] paDataValue) {
        this.paDataValue = paDataValue;
    }

    public int computeLength() {
        int paDataTypeLength = BerValue.getNbBytes((int)this.paDataType.getValue());
        this.paDataTypeTagLength = 1 + TLV.getNbBytes((int)paDataTypeLength) + paDataTypeLength;
        this.preAuthenticationDataSeqLength = 1 + TLV.getNbBytes((int)this.paDataTypeTagLength) + this.paDataTypeTagLength;
        this.paDataValueTagLength = this.paDataValue == null ? 2 : 1 + TLV.getNbBytes((int)this.paDataValue.length) + this.paDataValue.length;
        this.preAuthenticationDataSeqLength += 1 + TLV.getNbBytes((int)this.paDataValueTagLength) + this.paDataValueTagLength;
        return 1 + TLV.getNbBytes((int)this.preAuthenticationDataSeqLength) + this.preAuthenticationDataSeqLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_148, (Object[])new Object[0]));
        }
        try {
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.preAuthenticationDataSeqLength));
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes((int)this.paDataTypeTagLength));
            BerValue.encode((ByteBuffer)buffer, (int)this.paDataType.getValue());
            buffer.put((byte)-94);
            buffer.put(TLV.getBytes((int)this.paDataValueTagLength));
            BerValue.encode((ByteBuffer)buffer, (byte[])this.paDataValue);
        }
        catch (BufferOverflowException boe) {
            log.error(I18n.err((I18n)I18n.ERR_145, (Object[])new Object[]{1 + TLV.getNbBytes((int)this.preAuthenticationDataSeqLength) + this.preAuthenticationDataSeqLength, buffer.capacity()}));
            throw new EncoderException(I18n.err((I18n)I18n.ERR_138, (Object[])new Object[0]));
        }
        if (IS_DEBUG) {
            log.debug("PreAuthenticationData encoding : {}", (Object)Strings.dumpBytes((byte[])buffer.array()));
            log.debug("PreAuthenticationData initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("PreAuthenticationData : \n");
        sb.append(tabs).append("    padata-type: ").append((Object)this.paDataType).append('\n');
        if (this.paDataValue != null) {
            sb.append(tabs + "    padata-value:").append(Strings.dumpBytes((byte[])this.paDataValue)).append('\n');
        }
        return sb.toString();
    }
}

