/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.curator.ZKCuratorManager;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.federation.proto.YarnServerFederationProtos;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterIdPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterInfoPBImpl;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterPolicyConfigurationPBImpl;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationApplicationHomeSubClusterStoreInputValidator;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationMembershipStateStoreInputValidator;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationPolicyStoreInputValidator;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationStateStoreUtils;
import org.apache.hadoop.yarn.server.records.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperFederationStateStore
implements FederationStateStore {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperFederationStateStore.class);
    private static final String ROOT_ZNODE_NAME_MEMBERSHIP = "memberships";
    private static final String ROOT_ZNODE_NAME_APPLICATION = "applications";
    private static final String ROOT_ZNODE_NAME_POLICY = "policies";
    private ZKCuratorManager zkManager;
    private String baseZNode;
    private String appsZNode;
    private String membershipZNode;
    private String policiesZNode;

    @Override
    public void init(Configuration conf) throws YarnException {
        LOG.info("Initializing ZooKeeper connection");
        this.baseZNode = conf.get("yarn.federation.zk-state-store.parent-path", "/federationstore");
        try {
            this.zkManager = new ZKCuratorManager(conf);
            this.zkManager.start();
        }
        catch (IOException e) {
            LOG.error("Cannot initialize the ZK connection", (Throwable)e);
        }
        this.membershipZNode = ZKCuratorManager.getNodePath((String)this.baseZNode, (String)ROOT_ZNODE_NAME_MEMBERSHIP);
        this.appsZNode = ZKCuratorManager.getNodePath((String)this.baseZNode, (String)ROOT_ZNODE_NAME_APPLICATION);
        this.policiesZNode = ZKCuratorManager.getNodePath((String)this.baseZNode, (String)ROOT_ZNODE_NAME_POLICY);
        try {
            this.zkManager.createRootDirRecursively(this.membershipZNode);
            this.zkManager.createRootDirRecursively(this.appsZNode);
            this.zkManager.createRootDirRecursively(this.policiesZNode);
        }
        catch (Exception e) {
            String errMsg = "Cannot create base directories: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.zkManager != null) {
            this.zkManager.close();
        }
    }

    @Override
    public AddApplicationHomeSubClusterResponse addApplicationHomeSubCluster(AddApplicationHomeSubClusterRequest request) throws YarnException {
        String errMsg;
        FederationApplicationHomeSubClusterStoreInputValidator.validate(request);
        ApplicationHomeSubCluster app = request.getApplicationHomeSubCluster();
        ApplicationId appId = app.getApplicationId();
        SubClusterId homeSubCluster = app.getHomeSubCluster();
        try {
            this.putApp(appId, homeSubCluster, false);
        }
        catch (Exception e) {
            errMsg = "Cannot add application home subcluster for " + appId;
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        try {
            homeSubCluster = this.getApp(appId);
        }
        catch (Exception e) {
            errMsg = "Cannot check app home subcluster for " + appId;
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        return AddApplicationHomeSubClusterResponse.newInstance(homeSubCluster);
    }

    @Override
    public UpdateApplicationHomeSubClusterResponse updateApplicationHomeSubCluster(UpdateApplicationHomeSubClusterRequest request) throws YarnException {
        FederationApplicationHomeSubClusterStoreInputValidator.validate(request);
        ApplicationHomeSubCluster app = request.getApplicationHomeSubCluster();
        ApplicationId appId = app.getApplicationId();
        SubClusterId homeSubCluster = this.getApp(appId);
        if (homeSubCluster == null) {
            String errMsg = "Application " + appId + " does not exist";
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        SubClusterId newSubClusterId = request.getApplicationHomeSubCluster().getHomeSubCluster();
        this.putApp(appId, newSubClusterId, true);
        return UpdateApplicationHomeSubClusterResponse.newInstance();
    }

    @Override
    public GetApplicationHomeSubClusterResponse getApplicationHomeSubCluster(GetApplicationHomeSubClusterRequest request) throws YarnException {
        FederationApplicationHomeSubClusterStoreInputValidator.validate(request);
        ApplicationId appId = request.getApplicationId();
        SubClusterId homeSubCluster = this.getApp(appId);
        if (homeSubCluster == null) {
            String errMsg = "Application " + appId + " does not exist";
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        return GetApplicationHomeSubClusterResponse.newInstance(ApplicationHomeSubCluster.newInstance(appId, homeSubCluster));
    }

    @Override
    public GetApplicationsHomeSubClusterResponse getApplicationsHomeSubCluster(GetApplicationsHomeSubClusterRequest request) throws YarnException {
        ArrayList<ApplicationHomeSubCluster> result = new ArrayList<ApplicationHomeSubCluster>();
        try {
            for (String child : this.zkManager.getChildren(this.appsZNode)) {
                ApplicationId appId = ApplicationId.fromString((String)child);
                SubClusterId homeSubCluster = this.getApp(appId);
                ApplicationHomeSubCluster app = ApplicationHomeSubCluster.newInstance(appId, homeSubCluster);
                result.add(app);
            }
        }
        catch (Exception e) {
            String errMsg = "Cannot get apps: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        return GetApplicationsHomeSubClusterResponse.newInstance(result);
    }

    @Override
    public DeleteApplicationHomeSubClusterResponse deleteApplicationHomeSubCluster(DeleteApplicationHomeSubClusterRequest request) throws YarnException {
        String errMsg;
        FederationApplicationHomeSubClusterStoreInputValidator.validate(request);
        ApplicationId appId = request.getApplicationId();
        String appZNode = ZKCuratorManager.getNodePath((String)this.appsZNode, (String)appId.toString());
        boolean exists = false;
        try {
            exists = this.zkManager.exists(appZNode);
        }
        catch (Exception e) {
            errMsg = "Cannot check app: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        if (!exists) {
            String errMsg2 = "Application " + appId + " does not exist";
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg2);
        }
        try {
            this.zkManager.delete(appZNode);
        }
        catch (Exception e) {
            errMsg = "Cannot delete app: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        return DeleteApplicationHomeSubClusterResponse.newInstance();
    }

    @Override
    public SubClusterRegisterResponse registerSubCluster(SubClusterRegisterRequest request) throws YarnException {
        FederationMembershipStateStoreInputValidator.validate(request);
        SubClusterInfo subClusterInfo = request.getSubClusterInfo();
        SubClusterId subclusterId = subClusterInfo.getSubClusterId();
        long currentTime = ZookeeperFederationStateStore.getCurrentTime();
        subClusterInfo.setLastHeartBeat(currentTime);
        try {
            this.putSubclusterInfo(subclusterId, subClusterInfo, true);
        }
        catch (Exception e) {
            String errMsg = "Cannot register subcluster: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        return SubClusterRegisterResponse.newInstance();
    }

    @Override
    public SubClusterDeregisterResponse deregisterSubCluster(SubClusterDeregisterRequest request) throws YarnException {
        FederationMembershipStateStoreInputValidator.validate(request);
        SubClusterId subClusterId = request.getSubClusterId();
        SubClusterState state = request.getState();
        SubClusterInfo subClusterInfo = this.getSubclusterInfo(subClusterId);
        if (subClusterInfo == null) {
            String errMsg = "SubCluster " + subClusterId + " not found";
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        } else {
            subClusterInfo.setState(state);
            this.putSubclusterInfo(subClusterId, subClusterInfo, true);
        }
        return SubClusterDeregisterResponse.newInstance();
    }

    @Override
    public SubClusterHeartbeatResponse subClusterHeartbeat(SubClusterHeartbeatRequest request) throws YarnException {
        FederationMembershipStateStoreInputValidator.validate(request);
        SubClusterId subClusterId = request.getSubClusterId();
        SubClusterInfo subClusterInfo = this.getSubclusterInfo(subClusterId);
        if (subClusterInfo == null) {
            String errMsg = "SubCluster " + subClusterId + " does not exist; cannot heartbeat";
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        long currentTime = ZookeeperFederationStateStore.getCurrentTime();
        subClusterInfo.setLastHeartBeat(currentTime);
        subClusterInfo.setState(request.getState());
        subClusterInfo.setCapability(request.getCapability());
        this.putSubclusterInfo(subClusterId, subClusterInfo, true);
        return SubClusterHeartbeatResponse.newInstance();
    }

    @Override
    public GetSubClusterInfoResponse getSubCluster(GetSubClusterInfoRequest request) throws YarnException {
        FederationMembershipStateStoreInputValidator.validate(request);
        SubClusterId subClusterId = request.getSubClusterId();
        SubClusterInfo subClusterInfo = null;
        try {
            subClusterInfo = this.getSubclusterInfo(subClusterId);
            if (subClusterInfo == null) {
                LOG.warn("The queried SubCluster: {} does not exist.", (Object)subClusterId);
                return null;
            }
        }
        catch (Exception e) {
            String errMsg = "Cannot get subcluster: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        return GetSubClusterInfoResponse.newInstance(subClusterInfo);
    }

    @Override
    public GetSubClustersInfoResponse getSubClusters(GetSubClustersInfoRequest request) throws YarnException {
        ArrayList<SubClusterInfo> result = new ArrayList<SubClusterInfo>();
        try {
            for (String child : this.zkManager.getChildren(this.membershipZNode)) {
                SubClusterId subClusterId = SubClusterId.newInstance(child);
                SubClusterInfo info = this.getSubclusterInfo(subClusterId);
                if (request.getFilterInactiveSubClusters() && !info.getState().isActive()) continue;
                result.add(info);
            }
        }
        catch (Exception e) {
            String errMsg = "Cannot get subclusters: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        return GetSubClustersInfoResponse.newInstance(result);
    }

    @Override
    public GetSubClusterPolicyConfigurationResponse getPolicyConfiguration(GetSubClusterPolicyConfigurationRequest request) throws YarnException {
        FederationPolicyStoreInputValidator.validate(request);
        String queue = request.getQueue();
        SubClusterPolicyConfiguration policy = null;
        try {
            policy = this.getPolicy(queue);
        }
        catch (Exception e) {
            String errMsg = "Cannot get policy: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        if (policy == null) {
            LOG.warn("Policy for queue: {} does not exist.", (Object)queue);
            return null;
        }
        return GetSubClusterPolicyConfigurationResponse.newInstance(policy);
    }

    @Override
    public SetSubClusterPolicyConfigurationResponse setPolicyConfiguration(SetSubClusterPolicyConfigurationRequest request) throws YarnException {
        FederationPolicyStoreInputValidator.validate(request);
        SubClusterPolicyConfiguration policy = request.getPolicyConfiguration();
        try {
            String queue = policy.getQueue();
            this.putPolicy(queue, policy, true);
        }
        catch (Exception e) {
            String errMsg = "Cannot set policy: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        return SetSubClusterPolicyConfigurationResponse.newInstance();
    }

    @Override
    public GetSubClusterPoliciesConfigurationsResponse getPoliciesConfigurations(GetSubClusterPoliciesConfigurationsRequest request) throws YarnException {
        ArrayList<SubClusterPolicyConfiguration> result = new ArrayList<SubClusterPolicyConfiguration>();
        try {
            for (String child : this.zkManager.getChildren(this.policiesZNode)) {
                SubClusterPolicyConfiguration policy = this.getPolicy(child);
                result.add(policy);
            }
        }
        catch (Exception e) {
            String errMsg = "Cannot get policies: " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        return GetSubClusterPoliciesConfigurationsResponse.newInstance(result);
    }

    @Override
    public Version getCurrentVersion() {
        return null;
    }

    @Override
    public Version loadVersion() {
        return null;
    }

    private SubClusterId getApp(ApplicationId appId) throws YarnException {
        String appZNode = ZKCuratorManager.getNodePath((String)this.appsZNode, (String)appId.toString());
        SubClusterIdPBImpl subClusterId = null;
        byte[] data = this.get(appZNode);
        if (data != null) {
            try {
                subClusterId = new SubClusterIdPBImpl(YarnServerFederationProtos.SubClusterIdProto.parseFrom(data));
            }
            catch (InvalidProtocolBufferException e) {
                String errMsg = "Cannot parse application at " + appZNode;
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
        }
        return subClusterId;
    }

    private void putApp(ApplicationId appId, SubClusterId subClusterId, boolean update) throws YarnException {
        String appZNode = ZKCuratorManager.getNodePath((String)this.appsZNode, (String)appId.toString());
        YarnServerFederationProtos.SubClusterIdProto proto = ((SubClusterIdPBImpl)subClusterId).getProto();
        byte[] data = proto.toByteArray();
        this.put(appZNode, data, update);
    }

    private SubClusterInfo getSubclusterInfo(SubClusterId subclusterId) throws YarnException {
        String memberZNode = ZKCuratorManager.getNodePath((String)this.membershipZNode, (String)subclusterId.toString());
        SubClusterInfoPBImpl policy = null;
        byte[] data = this.get(memberZNode);
        if (data != null) {
            try {
                policy = new SubClusterInfoPBImpl(YarnServerFederationProtos.SubClusterInfoProto.parseFrom(data));
            }
            catch (InvalidProtocolBufferException e) {
                String errMsg = "Cannot parse subcluster info at " + memberZNode;
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
        }
        return policy;
    }

    private void putSubclusterInfo(SubClusterId subclusterId, SubClusterInfo subClusterInfo, boolean update) throws YarnException {
        String memberZNode = ZKCuratorManager.getNodePath((String)this.membershipZNode, (String)subclusterId.toString());
        YarnServerFederationProtos.SubClusterInfoProto proto = ((SubClusterInfoPBImpl)subClusterInfo).getProto();
        byte[] data = proto.toByteArray();
        this.put(memberZNode, data, update);
    }

    private SubClusterPolicyConfiguration getPolicy(String queue) throws YarnException {
        String policyZNode = ZKCuratorManager.getNodePath((String)this.policiesZNode, (String)queue);
        SubClusterPolicyConfigurationPBImpl policy = null;
        byte[] data = this.get(policyZNode);
        if (data != null) {
            try {
                policy = new SubClusterPolicyConfigurationPBImpl(YarnServerFederationProtos.SubClusterPolicyConfigurationProto.parseFrom(data));
            }
            catch (InvalidProtocolBufferException e) {
                String errMsg = "Cannot parse policy at " + policyZNode;
                FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
            }
        }
        return policy;
    }

    private void putPolicy(String queue, SubClusterPolicyConfiguration policy, boolean update) throws YarnException {
        String policyZNode = ZKCuratorManager.getNodePath((String)this.policiesZNode, (String)queue);
        YarnServerFederationProtos.SubClusterPolicyConfigurationProto proto = ((SubClusterPolicyConfigurationPBImpl)policy).getProto();
        byte[] data = proto.toByteArray();
        this.put(policyZNode, data, update);
    }

    private byte[] get(String znode) throws YarnException {
        boolean exists = false;
        try {
            exists = this.zkManager.exists(znode);
        }
        catch (Exception e) {
            String errMsg = "Cannot find znode " + znode;
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        if (!exists) {
            LOG.error("{} does not exist", (Object)znode);
            return null;
        }
        byte[] data = null;
        try {
            data = this.zkManager.getData(znode);
        }
        catch (Exception e) {
            String errMsg = "Cannot get data from znode " + znode + ": " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        return data;
    }

    private void put(String znode, byte[] data, boolean update) throws YarnException {
        String errMsg;
        boolean created = false;
        try {
            created = this.zkManager.create(znode);
        }
        catch (Exception e) {
            errMsg = "Cannot create znode " + znode + ": " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
        if (!created) {
            LOG.debug("{} not created", (Object)znode);
            if (!update) {
                LOG.info("{} already existed and we are not updating", (Object)znode);
                return;
            }
        }
        try {
            this.zkManager.setData(znode, data, -1);
        }
        catch (Exception e) {
            errMsg = "Cannot write data into znode " + znode + ": " + e.getMessage();
            FederationStateStoreUtils.logAndThrowStoreException(LOG, errMsg);
        }
    }

    private static long getCurrentTime() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        return cal.getTimeInMillis();
    }
}

