/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityNode;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ActivityNodeInfo {
    protected String name;
    protected String appPriority;
    protected String requestPriority;
    protected String allocationState;
    protected String diagnostic;
    protected List<ActivityNodeInfo> children;

    ActivityNodeInfo() {
    }

    ActivityNodeInfo(ActivityNode node) {
        this.name = node.getName();
        this.getPriority(node);
        this.allocationState = node.getState().name();
        this.diagnostic = node.getDiagnostic();
        this.children = new ArrayList<ActivityNodeInfo>();
        for (ActivityNode child : node.getChildren()) {
            ActivityNodeInfo containerInfo = new ActivityNodeInfo(child);
            this.children.add(containerInfo);
        }
    }

    private void getPriority(ActivityNode node) {
        if (node.getType()) {
            this.appPriority = node.getAppPriority();
        } else {
            this.requestPriority = node.getRequestPriority();
        }
    }
}

