/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.nio.ByteBuffer;
import org.apache.iceberg.encryption.EncryptionAlgorithm;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class NativeFileCryptoParameters {
    private final ByteBuffer fileKey;
    private final EncryptionAlgorithm fileEncryptionAlgorithm;

    private NativeFileCryptoParameters(ByteBuffer fileKey, EncryptionAlgorithm fileEncryptionAlgorithm) {
        Preconditions.checkState((fileKey != null ? 1 : 0) != 0, (Object)"File encryption key is not supplied");
        this.fileKey = fileKey;
        this.fileEncryptionAlgorithm = fileEncryptionAlgorithm;
    }

    public static Builder create(ByteBuffer fileKey) {
        return new Builder(fileKey);
    }

    public ByteBuffer fileKey() {
        return this.fileKey;
    }

    public EncryptionAlgorithm encryptionAlgorithm() {
        return this.fileEncryptionAlgorithm;
    }

    public static class Builder {
        private final ByteBuffer fileKey;
        private EncryptionAlgorithm fileEncryptionAlgorithm;

        private Builder(ByteBuffer fileKey) {
            this.fileKey = fileKey;
        }

        public Builder encryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
            this.fileEncryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        public NativeFileCryptoParameters build() {
            return new NativeFileCryptoParameters(this.fileKey, this.fileEncryptionAlgorithm);
        }
    }
}

