/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.compaction;

import com.lancedb.lance.compaction.CompactionOptions;
import com.lancedb.lance.compaction.CompactionTask;
import com.lancedb.lance.compaction.TaskData;
import java.util.List;
import java.util.stream.Collectors;

public class CompactionPlan {
    private final List<TaskData> tasks;
    private final long readVersion;
    private final CompactionOptions compactionOptions;

    public CompactionPlan(List<TaskData> tasks, long readVersion, CompactionOptions compactionOptions) {
        this.tasks = tasks;
        this.readVersion = readVersion;
        this.compactionOptions = compactionOptions;
    }

    public long getReadVersion() {
        return this.readVersion;
    }

    public CompactionOptions getCompactionOptions() {
        return this.compactionOptions;
    }

    public List<CompactionTask> getCompactionTasks() {
        return this.tasks.stream().map(task -> new CompactionTask((TaskData)task, this.readVersion, this.compactionOptions)).collect(Collectors.toList());
    }
}

