/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.datanucleus.Configuration;
import org.datanucleus.ExecutionContext;
import org.datanucleus.TransactionImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.properties.PropertyStore;
import org.datanucleus.store.connection.ConnectionResourceType;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.jta.JTASyncRegistry;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JTATransactionImpl
extends TransactionImpl
implements Synchronization {
    private static boolean JBOSS_SERVER = System.getProperty("jboss.server.name") != null;
    private TransactionManager jtaTM;
    private Transaction jtaTx;
    private JTASyncRegistry jtaSyncRegistry;
    protected JoinStatus joinStatus = JoinStatus.NO_TXN;
    private UserTransaction userTransaction;
    protected boolean autoJoin = true;

    JTATransactionImpl(ExecutionContext ec, boolean autoJoin, PropertyStore properties) {
        super(ec, properties);
        this.autoJoin = autoJoin;
        Configuration conf = ec.getNucleusContext().getConfiguration();
        if (!ConnectionResourceType.JTA.toString().equalsIgnoreCase(conf.getStringProperty("datanucleus.connection.resourceType")) || !ConnectionResourceType.JTA.toString().equalsIgnoreCase(conf.getStringProperty("datanucleus.connection2.resourceType"))) {
            throw new NucleusException("Internal error: either datanucleus.connection.resourceType or datanucleus.connection2.resourceType have not been set to JTA; this should have happened automatically.");
        }
        this.txnMgr.setContainerManagedConnections(true);
        this.jtaTM = ec.getNucleusContext().getJtaTransactionManager();
        if (this.jtaTM == null) {
            throw new NucleusTransactionException(Localiser.msg("015030"));
        }
        this.jtaSyncRegistry = ec.getNucleusContext().getJtaSyncRegistry();
        if (autoJoin) {
            this.joinTransaction();
        }
    }

    public boolean isJoined() {
        return this.joinStatus == JoinStatus.JOINED;
    }

    private int getTransactionStatus() {
        try {
            return this.jtaTM.getStatus();
        }
        catch (SystemException se) {
            throw new NucleusTransactionException(Localiser.msg("015026"), se);
        }
    }

    public void joinTransaction() {
        block12: {
            if (this.joinStatus != JoinStatus.JOINED) {
                try {
                    boolean allow_join;
                    Transaction txn = this.jtaTM.getTransaction();
                    int txnstat = this.jtaTM.getStatus();
                    if (this.jtaTx != null && !this.jtaTx.equals(txn)) {
                        if (this.joinStatus != JoinStatus.IMPOSSIBLE) {
                            throw new InternalError("JTA Transaction changed without being notified");
                        }
                        this.jtaTx = null;
                        this.joinStatus = JoinStatus.NO_TXN;
                        this.joinTransaction();
                        break block12;
                    }
                    if (this.jtaTx != null) break block12;
                    this.jtaTx = txn;
                    boolean bl = allow_join = txnstat == 0;
                    if (allow_join) {
                        this.joinStatus = JoinStatus.IMPOSSIBLE;
                        try {
                            if (this.jtaSyncRegistry != null) {
                                this.jtaSyncRegistry.register(this);
                            } else {
                                this.jtaTx.registerSynchronization((Synchronization)this);
                            }
                            boolean was_active = super.isActive();
                            if (!was_active) {
                                this.internalBegin();
                            }
                        }
                        catch (Exception e) {
                            throw new NucleusTransactionException("Cannot register Synchronization to a valid JTA Transaction", e);
                        }
                        this.joinStatus = JoinStatus.JOINED;
                        break block12;
                    }
                    if (this.jtaTx != null) {
                        this.joinStatus = JoinStatus.IMPOSSIBLE;
                    }
                }
                catch (SystemException e) {
                    throw new NucleusTransactionException(Localiser.msg("015026"), e);
                }
            }
        }
    }

    @Override
    public boolean getIsActive() {
        if (this.closed) {
            return false;
        }
        int txnStatus = this.getTransactionStatus();
        if (txnStatus == 3 || txnStatus == 4) {
            return false;
        }
        return super.getIsActive();
    }

    @Override
    public boolean isActive() {
        if (this.autoJoin) {
            if (this.joinStatus == JoinStatus.JOINED) {
                return super.isActive();
            }
            this.joinTransaction();
            return super.isActive() || this.joinStatus == JoinStatus.IMPOSSIBLE;
        }
        return super.isActive();
    }

    @Override
    public void begin() {
        UserTransaction utx;
        this.joinTransaction();
        if (this.joinStatus != JoinStatus.NO_TXN) {
            throw new NucleusTransactionException("JTA Transaction is already active");
        }
        try {
            InitialContext ctx = new InitialContext();
            utx = JBOSS_SERVER ? (UserTransaction)ctx.lookup("UserTransaction") : (UserTransaction)ctx.lookup("java:comp/UserTransaction");
        }
        catch (NamingException e) {
            throw this.ec.getApiAdapter().getUserExceptionForException("Failed to obtain UserTransaction", e);
        }
        try {
            utx.begin();
        }
        catch (NotSupportedException e) {
            throw this.ec.getApiAdapter().getUserExceptionForException("Failed to begin UserTransaction", (Exception)((Object)e));
        }
        catch (SystemException e) {
            throw this.ec.getApiAdapter().getUserExceptionForException("Failed to begin UserTransaction", (Exception)((Object)e));
        }
        this.joinTransaction();
        if (this.joinStatus != JoinStatus.JOINED) {
            throw new NucleusTransactionException("Cannot join an auto started UserTransaction");
        }
        this.userTransaction = utx;
    }

    @Override
    public void commit() {
        if (this.userTransaction == null) {
            throw new NucleusTransactionException("No internal UserTransaction");
        }
        try {
            this.userTransaction.commit();
        }
        catch (Exception e) {
            throw this.ec.getApiAdapter().getUserExceptionForException("Failed to commit UserTransaction", e);
        }
        finally {
            this.userTransaction = null;
        }
    }

    @Override
    public void rollback() {
        if (this.userTransaction == null) {
            throw new NucleusTransactionException("No internal UserTransaction");
        }
        try {
            this.userTransaction.rollback();
        }
        catch (Exception e) {
            throw this.ec.getApiAdapter().getUserExceptionForException("Failed to rollback UserTransaction", e);
        }
        finally {
            this.userTransaction = null;
        }
    }

    @Override
    public void setRollbackOnly() {
        if (this.userTransaction == null) {
            throw new NucleusTransactionException("No internal UserTransaction");
        }
        try {
            this.userTransaction.setRollbackOnly();
        }
        catch (Exception e) {
            throw this.ec.getApiAdapter().getUserExceptionForException("Failed to rollback-only UserTransaction", e);
        }
    }

    public void beforeCompletion() {
        RuntimeException thr = null;
        boolean success = false;
        try {
            this.flush();
            this.internalPreCommit();
            this.flush();
            success = true;
        }
        catch (RuntimeException e) {
            thr = e;
            throw e;
        }
        finally {
            if (!success) {
                NucleusLogger.TRANSACTION.error(Localiser.msg("015044"), thr);
                try {
                    this.jtaTx.setRollbackOnly();
                }
                catch (Exception e) {
                    NucleusLogger.TRANSACTION.fatal(Localiser.msg("015045"), e);
                }
            }
        }
    }

    public synchronized void afterCompletion(int status) {
        if (this.closed) {
            NucleusLogger.TRANSACTION.warn(Localiser.msg("015048", this));
            return;
        }
        RuntimeException thr = null;
        boolean success = false;
        try {
            if (status == 4) {
                super.rollback();
            } else if (status == 3) {
                super.internalPostCommit();
            } else {
                NucleusLogger.TRANSACTION.fatal(Localiser.msg("015047", status));
            }
            success = true;
        }
        catch (RuntimeException re) {
            thr = re;
            NucleusLogger.TRANSACTION.error("Exception in afterCompletion : " + re.getMessage(), re);
            throw re;
        }
        finally {
            this.jtaTx = null;
            this.joinStatus = JoinStatus.NO_TXN;
            if (!success) {
                NucleusLogger.TRANSACTION.error(Localiser.msg("015046"), thr);
            }
        }
        if (this.active) {
            throw new NucleusTransactionException("internal error, must not be active after afterCompletion()!");
        }
    }

    private static enum JoinStatus {
        NO_TXN,
        IMPOSSIBLE,
        JOINED;

    }
}

