/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.iceberg.BlobMetadata;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

public class GenericStatisticsFile
implements StatisticsFile {
    private final long snapshotId;
    private final String path;
    private final long fileSizeInBytes;
    private final long fileFooterSizeInBytes;
    private final List<BlobMetadata> blobMetadata;

    public GenericStatisticsFile(long snapshotId, String path, long fileSizeInBytes, long fileFooterSizeInBytes, List<BlobMetadata> blobMetadata) {
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        Preconditions.checkNotNull(blobMetadata, (Object)"blobMetadata is null");
        this.snapshotId = snapshotId;
        this.path = path;
        this.fileSizeInBytes = fileSizeInBytes;
        this.fileFooterSizeInBytes = fileFooterSizeInBytes;
        this.blobMetadata = ImmutableList.copyOf(blobMetadata);
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public String path() {
        return this.path;
    }

    public long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public long fileFooterSizeInBytes() {
        return this.fileFooterSizeInBytes;
    }

    public List<BlobMetadata> blobMetadata() {
        return this.blobMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericStatisticsFile that = (GenericStatisticsFile)o;
        return this.snapshotId == that.snapshotId && this.fileSizeInBytes == that.fileSizeInBytes && this.fileFooterSizeInBytes == that.fileFooterSizeInBytes && Objects.equals(this.path, that.path) && Objects.equals(this.blobMetadata, that.blobMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotId, this.path, this.fileSizeInBytes, this.fileFooterSizeInBytes, this.blobMetadata);
    }

    public String toString() {
        return new StringJoiner(", ", GenericStatisticsFile.class.getSimpleName() + "[", "]").add("snapshotId=" + this.snapshotId).add("path='" + this.path + "'").add("fileSizeInBytes=" + this.fileSizeInBytes).add("fileFooterSizeInBytes=" + this.fileFooterSizeInBytes).add("blobMetadata=" + String.valueOf(this.blobMetadata)).toString();
    }
}

