/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.gravitino.dto.job.JobDTO;
import org.apache.gravitino.dto.responses.BaseResponse;

public class JobListResponse
extends BaseResponse {
    @JsonProperty(value="jobs")
    private final List<JobDTO> jobs;

    public JobListResponse(List<JobDTO> jobs) {
        super(0);
        this.jobs = jobs;
    }

    private JobListResponse() {
        this(null);
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument((this.jobs != null ? 1 : 0) != 0, (Object)"\"jobs\" must not be null");
        this.jobs.forEach(JobDTO::validate);
    }

    public List<JobDTO> getJobs() {
        return this.jobs;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobListResponse)) {
            return false;
        }
        JobListResponse other = (JobListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<JobDTO> this$jobs = this.getJobs();
        List<JobDTO> other$jobs = other.getJobs();
        return !(this$jobs == null ? other$jobs != null : !((Object)this$jobs).equals(other$jobs));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JobListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<JobDTO> $jobs = this.getJobs();
        result = result * 59 + ($jobs == null ? 43 : ((Object)$jobs).hashCode());
        return result;
    }
}

